/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class EntityReference<E extends Entity>
implements IDataSerializable {
    private World world;
    private E tracked_entity;
    private UUID entity_uuid = null_uuid;
    private static final UUID null_uuid = UUID.fromString("00000000-0000-0000-0000-000000000000");
    protected transient int fails = 0;

    public EntityReference() {
    }

    public EntityReference(World world) {
        this.world = world;
    }

    public EntityReference(E ent) {
        this.world = ((Entity)ent).field_70170_p;
        this.trackEntity(ent);
    }

    public void setWorld(World w) {
        this.world = w;
    }

    public void trackEntity(E ent) {
        if (this.world == null && ent != null) {
            this.world = ((Entity)ent).field_70170_p;
        }
        if (ent != null && ((Entity)ent).field_70128_L) {
            ent = null;
        }
        this.tracked_entity = ent;
        this.entity_uuid = ent == null ? null_uuid : ent.func_110124_au();
    }

    public boolean trackingEntity() {
        return !null_uuid.equals(this.entity_uuid);
    }

    public E getEntity() {
        if (this.tracked_entity == null) {
            if (!this.trackingEntity()) {
                return null;
            }
            this.fetchEntity();
        }
        return this.tracked_entity;
    }

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.entity_uuid = data.asSameShare(prefix + "entity_uuid").putUUID(this.entity_uuid);
        return this;
    }

    protected void fetchEntity() {
        if (this.world == null) {
            return;
        }
        if (this.fails++ > 4 && this.fails % 40 != 0) {
            return;
        }
        for (Entity ent : this.world.field_72996_f) {
            if (!this.entity_uuid.equals(ent.func_110124_au())) continue;
            this.tracked_entity = ent;
            this.fails = 0;
            break;
        }
    }

    public boolean entityFound() {
        return this.tracked_entity != null;
    }

    public boolean trackedAndAlive() {
        if (!this.trackingEntity()) {
            return false;
        }
        if (!this.entityFound()) {
            return true;
        }
        return !((Entity)this.tracked_entity).field_70128_L;
    }
}

