/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import com.google.common.base.Splitter;
import factorization.util.DataUtil;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

public class Graylist<E> {
    private static final Comparator identityComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return o1 == o2 ? 0 : 1;
        }
    };
    private final boolean defaultMode;
    private final Comparator<E> comparator;
    private final ArrayList<E> members = new ArrayList();

    public Graylist(String source, Loader<E> loader, Comparator<E> comparator) {
        if (source == null || source.isEmpty()) {
            source = "-";
        }
        if (source.startsWith("+")) {
            this.defaultMode = false;
        } else if (source.startsWith("-")) {
            this.defaultMode = true;
        } else {
            throw new IllegalArgumentException("Graylist must start with either a + (meaning only the listed objects can be used) or a - (indicating that anything but the listed objects can be used)");
        }
        this.comparator = comparator;
        source = source.substring(1);
        Splitter commas = Splitter.on((String)",");
        for (String part : commas.split((CharSequence)source)) {
            this.members.add(loader.load(part));
        }
    }

    public static Graylist<Block> ofBlocks(String source) {
        return new Graylist<Block>(source, new Loader<Block>(){

            @Override
            public Block load(String name2) {
                return DataUtil.getBlockFromName(name2);
            }
        }, identityComparator);
    }

    public static Graylist<Item> ofItems(String source) {
        return new Graylist<Item>(source, new Loader<Item>(){

            @Override
            public Item load(String name2) {
                return DataUtil.getItemFromName(name2);
            }
        }, identityComparator);
    }

    public boolean passes(E element) {
        for (E member : this.members) {
            if (this.comparator.compare(member, element) != 0) continue;
            return !this.defaultMode;
        }
        return this.defaultMode;
    }

    public static interface Loader<L> {
        public L load(String var1);
    }
}

