/*
 * Decompiled with CFR 0.152.
 */
package factorization.sockets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.FzOrientation;
import factorization.api.Quaternion;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.common.ItemIcons;
import factorization.notify.Notice;
import factorization.servo.ServoMotor;
import factorization.shared.Core;
import factorization.shared.DropCaptureHandler;
import factorization.shared.FactorizationBlockRender;
import factorization.shared.ICaptureDrops;
import factorization.shared.NetworkFactorization;
import factorization.shared.ObjectModel;
import factorization.sockets.ISocketHolder;
import factorization.sockets.TileEntitySocketBase;
import factorization.util.InvUtil;
import factorization.util.ItemUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockTripWire;
import net.minecraft.block.BlockVine;
import net.minecraft.block.BlockWeb;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class SocketScissors
extends TileEntitySocketBase
implements ICaptureDrops {
    private boolean wasPowered = false;
    private ArrayList<ItemStack> buffer = new ArrayList();
    private byte openCount = 0;
    private static byte openTime = (byte)6;
    private boolean sound = false;
    private boolean blocked = false;
    private boolean dirty = false;
    public static Entity lootingPlayer;
    public static final DamageSource ScissorsDamge;
    @SideOnly(value=Side.CLIENT)
    private static ObjectModel piston_base;
    @SideOnly(value=Side.CLIENT)
    private static ObjectModel piston_head;

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.SOCKET_SCISSORS;
    }

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.wasPowered = data.as(Share.PRIVATE, "pow").putBoolean(this.wasPowered);
        this.buffer = data.as(Share.PRIVATE, "buf").putItemArray(this.buffer);
        this.openCount = data.as(Share.VISIBLE, "open").putByte(this.openCount);
        return this;
    }

    @Override
    public FactoryType getParentFactoryType() {
        return FactoryType.SOCKET_EMPTY;
    }

    @Override
    public ItemStack getCreatingItem() {
        return new ItemStack((Item)Core.registry.giant_scissors);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public boolean activate(EntityPlayer entityplayer, ForgeDirection side) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        if (!this.buffer.isEmpty()) {
            new Notice(this, "%s items buffered", "" + this.buffer.size()).send(entityplayer);
            return false;
        }
        if (this.getBackingInventory(this) == null) {
            new Notice(this, "No output inventory", new String[0]).send(entityplayer);
            return false;
        }
        return false;
    }

    @Override
    public void genericUpdate(ISocketHolder socket, Coord coord, boolean powered) {
        if (this.sound) {
            this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "mob.sheep.shear", 1.0f, 1.0f, false);
        }
        this.sound = false;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!(this.openCount <= 0 || powered && this.openCount >= openTime)) {
            this.openCount = (byte)(this.openCount - 1);
            this.dirty = true;
        }
        if (this.wasPowered || !powered) {
            this.wasPowered = powered;
        } else {
            this.wasPowered = true;
            FzOrientation orientation = FzOrientation.fromDirection(this.facing).getSwapped();
            if (this.openCount == 0 && this.getBackingInventory(socket) != null) {
                this.blocked = false;
                this.rayTrace(socket, coord, orientation, powered, false, true);
                if (!this.blocked) {
                    this.sound = true;
                    this.openCount = openTime;
                    this.dirty = true;
                }
            }
        }
        if (socket.dumpBuffer(this.buffer)) {
            Iterator<ItemStack> iterator = this.buffer.iterator();
            while (iterator.hasNext()) {
                ItemStack is = iterator.next();
                if (ItemUtil.normalize(is) != null) continue;
                iterator.remove();
            }
        }
        if (this.dirty) {
            socket.sendMessage(NetworkFactorization.MessageType.ScissorState, this.openCount, this.sound);
            this.dirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleRay(ISocketHolder socket, MovingObjectPosition mop, boolean mopIsThis, boolean powered) {
        DropCaptureHandler.startCapture(this);
        try {
            boolean bl = this._handleRay(socket, mop, mopIsThis, powered);
            return bl;
        }
        finally {
            DropCaptureHandler.endCapture();
        }
    }

    public boolean _handleRay(ISocketHolder socket, MovingObjectPosition mop, boolean mopIsThis, boolean powered) {
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
            Entity entity;
            ItemStack sword = new ItemStack(Items.field_151048_u, 0);
            if (this.field_145850_b.field_73012_v.nextInt(10) > 3) {
                sword.func_77966_a(Enchantment.field_77335_o, 1);
            }
            if ((entity = mop.field_72308_g) instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)entity;
                EntityPlayer player = this.getFakePlayer();
                player.field_71071_by.field_70462_a[0] = sword;
                lootingPlayer = player;
                int prevRecentlyHit = living.field_70718_bc;
                living.func_70097_a(ScissorsDamge, 2.0f);
                living.field_70718_bc = prevRecentlyHit;
                SocketScissors.lootingPlayer.field_70128_L = true;
                return true;
            }
        }
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            ItemStack shears = new ItemStack((Item)Items.field_151097_aZ, 0);
            shears.func_77966_a(Enchantment.field_77348_q, 1);
            Block block = this.field_145850_b.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            int metadata = this.field_145850_b.func_72805_g(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            if (block.isAir((IBlockAccess)this.field_145850_b, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)) {
                return false;
            }
            EntityPlayer player = this.getFakePlayer();
            if (SocketScissors.canCutBlock(player, this.field_145850_b, block, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)) {
                boolean didRemove;
                IShearable shearable;
                player.field_71071_by.field_70462_a[0] = shears;
                boolean sheared = false;
                if (block instanceof IShearable && (shearable = (IShearable)block).isShearable(shears, (IBlockAccess)this.field_145850_b, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)) {
                    ArrayList drops = shearable.onSheared(shears, (IBlockAccess)this.field_145850_b, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, 0);
                    this.processCollectedItems(drops);
                    sheared = true;
                }
                if ((didRemove = this.removeBlock(player, block, metadata, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)) && !sheared) {
                    block.func_149636_a(this.field_145850_b, player, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, metadata);
                }
            } else {
                this.blocked = true;
            }
        }
        return false;
    }

    private boolean removeBlock(EntityPlayer thisPlayerMP, Block block, int md, int x, int y, int z) {
        if (block == null) {
            return false;
        }
        block.func_149681_a(this.field_145850_b, x, y, z, md, thisPlayerMP);
        if (block.removedByPlayer(this.field_145850_b, thisPlayerMP, x, y, z, false)) {
            block.func_149664_b(this.field_145850_b, x, y, z, md);
            return true;
        }
        return false;
    }

    public static boolean canCutBlock(EntityPlayer player, World world, Block block, int x, int y, int z) {
        int md = world.func_72805_g(x, y, z);
        Material mat = block.func_149688_o();
        if (block.func_149712_f(world, x, y, z) == 0.0f && mat != Material.field_151594_q && mat != Material.field_151581_o && mat != Material.field_151579_a) {
            return true;
        }
        if (block instanceof BlockPortal) {
            return true;
        }
        if (block.func_149712_f(world, x, y, z) == 0.0f && mat != Material.field_151594_q && mat != Material.field_151581_o && mat != Material.field_151579_a) {
            return true;
        }
        if (mat == Material.field_151584_j || mat == Material.field_151570_A || mat == Material.field_151585_k || mat == Material.field_151580_n || mat == Material.field_151593_r) {
            return true;
        }
        return block instanceof BlockWeb || block instanceof BlockTallGrass || block instanceof BlockVine || block instanceof BlockTripWire;
    }

    @Override
    public boolean captureDrops(int x, int y, int z, ArrayList<ItemStack> stacks) {
        int maxDist = 9;
        double dx = (double)this.field_145851_c + 0.5 - (double)x;
        double dy = (double)this.field_145848_d + 0.5 - (double)y;
        double dz = (double)this.field_145849_e + 0.5 - (double)z;
        double dist = dx * dx + dy * dy + dz * dz;
        if (dist > 9.0) {
            return false;
        }
        this.processCollectedItems(stacks);
        return true;
    }

    void processCollectedItems(Collection<ItemStack> items) {
        if (items == null) {
            return;
        }
        this.buffer.addAll(items);
        items.clear();
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        Coord here = this.getCoord();
        for (ItemStack is : this.buffer) {
            InvUtil.spawnItemStack(here, is);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderTesr(ServoMotor motor, float partial) {
        float d = 0.5f;
        GL11.glTranslatef((float)d, (float)d, (float)d);
        Quaternion.fromOrientation(FzOrientation.fromDirection(this.facing.getOpposite())).glRotate();
        float turn = 28.0f * ((float)this.openCount / (float)openTime);
        GL11.glTranslatef((float)0.0f, (float)-0.1875f, (float)0.0f);
        float n = -0.125f;
        GL11.glTranslatef((float)0.0f, (float)n, (float)0.0f);
        GL11.glRotatef((float)turn, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)(-n), (float)0.0f);
        float sd = motor == null ? -0.125f : 0.1875f;
        GL11.glTranslatef((float)0.0f, (float)sd, (float)0.0f);
        if (motor != null) {
            GL11.glTranslatef((float)0.0f, (float)-0.375f, (float)0.0f);
        }
        GL11.glPushMatrix();
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)0.5f);
        FactorizationBlockRender.renderItemIIcon(ItemIcons.socket$half_scissors);
        GL11.glPopMatrix();
        GL11.glRotatef((float)(-turn * 2.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glPushMatrix();
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)0.5f);
        FactorizationBlockRender.renderItemIIcon(ItemIcons.socket$half_scissors);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glRotatef((float)(turn + 180.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)-0.5625f, (float)0.1875f);
        TextureManager tex = Minecraft.func_71410_x().field_71446_o;
        tex.func_110577_a(Core.blockAtlas);
        piston_base.render(BlockIcons.socket$mini_piston);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.375f);
        piston_base.render(BlockIcons.socket$mini_piston);
        float offset = -0.0625f * ((float)this.openCount / (float)openTime) - 0.0625f;
        GL11.glTranslatef((float)0.0f, (float)offset, (float)0.0f);
        piston_head.render(BlockIcons.socket$mini_piston);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.375f);
        piston_head.render(BlockIcons.socket$mini_piston);
        GL11.glPopMatrix();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void representYoSelf() {
        super.representYoSelf();
        piston_base = new ObjectModel(Core.getResource("models/mini_piston/mini_piston_base.obj"));
        piston_head = new ObjectModel(Core.getResource("models/mini_piston/mini_piston_head.obj"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.ScissorState) {
            this.openCount = input.readByte();
            this.sound = input.readBoolean();
            return true;
        }
        return false;
    }

    static {
        ScissorsDamge = new DamageSource("scissors"){

            public IChatComponent func_151519_b(EntityLivingBase victim) {
                String ret = "death.attack.scissors.";
                if (victim.field_70170_p != null) {
                    long now = victim.field_70170_p.func_82737_E();
                    ret = ret + (now % 3L + 1L);
                } else {
                    ret = ret + "1";
                }
                EntityLivingBase attacker = victim.func_94060_bK();
                String fightingMessage = ret + ".player";
                if (attacker != null && StatCollector.func_94522_b((String)fightingMessage)) {
                    return new ChatComponentTranslation(fightingMessage, new Object[]{victim.func_145748_c_(), attacker.func_145748_c_()});
                }
                return new ChatComponentTranslation(ret, new Object[]{victim.func_145748_c_()});
            }

            public Entity func_76346_g() {
                return lootingPlayer;
            }
        };
    }
}

