/*
 * Decompiled with CFR 0.152.
 */
package factorization.sockets.fanturpeller;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Charge;
import factorization.api.Coord;
import factorization.api.FzOrientation;
import factorization.api.IChargeConductor;
import factorization.api.Quaternion;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.servo.RenderServoMotor;
import factorization.servo.ServoMotor;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.shared.FactorizationBlockRender;
import factorization.shared.NetworkFactorization;
import factorization.sockets.ISocketHolder;
import factorization.sockets.TileEntitySocketBase;
import factorization.sockets.fanturpeller.PumpLiquids;
import factorization.util.NumUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;
import org.lwjgl.opengl.GL11;

public abstract class SocketFanturpeller
extends TileEntitySocketBase
implements IChargeConductor {
    Charge charge = new Charge(this);
    boolean isSucking = true;
    byte target_speed = 1;
    float fan\u03c9;
    boolean dirty = false;
    transient float fanRotation;
    transient float prevFanRotation;

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.charge = data.as(Share.PRIVATE, "charge").put(this.charge);
        this.isSucking = data.as(Share.MUTABLE, "suck").put(this.isSucking);
        this.target_speed = data.as(Share.MUTABLE, "target_speed").putByte(this.target_speed);
        if (this.target_speed < 0) {
            this.target_speed = 0;
        }
        if (this.target_speed > 3) {
            this.target_speed = (byte)3;
        }
        this.fan\u03c9 = data.as(Share.VISIBLE, "fanw").putFloat(this.fan\u03c9);
        return this;
    }

    @Override
    public ItemStack getCreatingItem() {
        return new ItemStack((Item)Core.registry.fan);
    }

    @Override
    public FactoryType getParentFactoryType() {
        return FactoryType.SOCKET_BARE_MOTOR;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public String getInfo() {
        return null;
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public void func_145845_h() {
        this.charge.update();
        super.func_145845_h();
    }

    boolean isLiquid(Coord at) {
        Block block = at.getBlock();
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i || block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
            return at.getMd() == 0;
        }
        if (block instanceof IFluidBlock) {
            IFluidBlock ifb = (IFluidBlock)block;
            return ifb.canDrain(this.field_145850_b, at.x, at.y, at.z);
        }
        return false;
    }

    boolean hasTank(Coord at) {
        return at.getTE(IFluidHandler.class) != null;
    }

    boolean hasInv(Coord at) {
        return at.getTE(IInventory.class) != null;
    }

    boolean isClear(Coord at) {
        return at.isReplacable() && !this.isLiquid(at);
    }

    boolean noCollision(Coord at) {
        return at.getCollisionBoundingBoxFromPool() == null;
    }

    @Override
    protected void replaceWith(TileEntitySocketBase baseReplacement, ISocketHolder socket) {
        if (baseReplacement instanceof SocketFanturpeller) {
            SocketFanturpeller replacement = (SocketFanturpeller)baseReplacement;
            if (!this.isSafeToDiscard()) {
                if (replacement instanceof PumpLiquids && this instanceof PumpLiquids) {
                    PumpLiquids old = (PumpLiquids)this;
                    PumpLiquids rep = (PumpLiquids)replacement;
                    rep.buffer = old.buffer;
                } else {
                    return;
                }
            }
            replacement.isSucking = this.isSucking;
            replacement.target_speed = this.target_speed;
            replacement.fan\u03c9 = this.fan\u03c9;
            replacement.fanRotation = this.fanRotation;
            replacement.prevFanRotation = this.prevFanRotation;
            replacement.charge = this.charge;
        }
        super.replaceWith(baseReplacement, socket);
    }

    float getTargetSpeed() {
        if (!this.shouldFeedJuice()) {
            return 0.0f;
        }
        return this.target_speed * 10;
    }

    boolean shouldDoWork() {
        if (this.target_speed == 0) {
            return false;
        }
        int direction = this.isSucking ? -1 : 1;
        float ts = this.getTargetSpeed();
        if (Math.signum(this.fan\u03c9) != (float)direction) {
            return false;
        }
        float \u03c9 = Math.abs(this.fan\u03c9);
        return \u03c9 >= ts;
    }

    int getRequiredCharge() {
        return 0;
    }

    @Override
    public final void genericUpdate(ISocketHolder socket, Coord coord, boolean powered) {
        this.prevFanRotation = this.fanRotation;
        this.fanturpellerUpdate(socket, coord, powered);
        if (!this.field_145850_b.field_72995_K) {
            int need = this.getRequiredCharge();
            float orig_speed = this.fan\u03c9;
            if (powered || !this.shouldFeedJuice()) {
                this.fan\u03c9 = (float)((double)this.fan\u03c9 * 0.95);
            } else if (need > 0) {
                float ts = this.getTargetSpeed() * (float)(this.isSucking ? -1 : 1);
                if (!socket.extractCharge(need)) {
                    this.fan\u03c9 = (float)((double)this.fan\u03c9 * 0.9);
                } else if (Math.abs(this.fan\u03c9) > Math.abs(ts)) {
                    this.fan\u03c9 = (this.fan\u03c9 * 9.0f + ts) / 10.0f;
                    if (Math.abs(this.fan\u03c9) < Math.abs(ts)) {
                        this.fan\u03c9 = ts;
                    }
                } else if (this.isSucking && ts < this.fan\u03c9 || !this.isSucking && ts > this.fan\u03c9) {
                    this.fan\u03c9 += Math.signum(ts);
                    if (this.fan\u03c9 > Math.abs(ts)) {
                        this.fan\u03c9 = ts;
                    }
                }
            }
            if (this.dirty || orig_speed != this.fan\u03c9) {
                socket.sendMessage(NetworkFactorization.MessageType.FanturpellerSpeed, Float.valueOf(this.fan\u03c9), this.isSucking, this.target_speed);
                this.dirty = false;
            }
        }
        this.fanRotation += this.fan\u03c9;
    }

    protected boolean shouldFeedJuice() {
        return false;
    }

    protected void fanturpellerUpdate(ISocketHolder socket, Coord coord, boolean powered) {
        this.fan\u03c9 *= 0.95f;
    }

    protected boolean isSafeToDiscard() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(ServoMotor motor, Tessellator tess) {
        if (motor != null) {
            TextureManager tex = Minecraft.func_71410_x().field_71446_o;
            tex.func_110577_a(Core.blockAtlas);
        }
        BlockRenderHelper block = BlockRenderHelper.instance;
        Quaternion rotation = Quaternion.fromOrientation(FzOrientation.fromDirection(this.facing.getOpposite()));
        IIcon metal = BlockIcons.motor_texture;
        float d = 0.25f;
        float yd = -d + 0.003f;
        block.useTextures(metal, null, metal, metal, metal, metal);
        float yoffset = 0.3125f;
        float sd = motor == null ? 0.0f : 0.125f;
        block.func_149676_a(d, d + yd + yoffset + 0.125f + sd, d, 1.0f - d, 1.0f - (d + 0.0f) + yd + yoffset, 1.0f - d);
        block.beginWithMirroredUVs();
        block.rotateCenter(rotation);
        block.renderRotated(tess, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    protected float scaleRotation(float rotation) {
        return rotation;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderTesr(ServoMotor motor, float partial) {
        float d = 0.5f;
        GL11.glTranslatef((float)d, (float)d, (float)d);
        Quaternion.fromOrientation(FzOrientation.fromDirection(this.facing.getOpposite())).glRotate();
        float turn = this.scaleRotation(NumUtil.interp(this.prevFanRotation, this.fanRotation, partial));
        float dr = Math.abs(this.scaleRotation(this.fanRotation) - this.scaleRotation(this.prevFanRotation));
        GL11.glRotatef((float)turn, (float)0.0f, (float)1.0f, (float)0.0f);
        float sd = motor == null ? -0.125f : 0.1875f;
        GL11.glTranslatef((float)0.0f, (float)sd, (float)0.0f);
        float s = 0.75f;
        if (motor != null) {
            s = 0.625f;
            GL11.glTranslatef((float)0.0f, (float)-0.1875f, (float)0.0f);
        }
        GL11.glScalef((float)s, (float)1.0f, (float)s);
        float count = dr / 60.0f;
        if (count > 2.0f) {
            count = 2.0f;
        }
        if (count < 1.0f) {
            count = 1.0f;
        }
        for (float i = 0.0f; i < count; i += 1.0f) {
            if (i > 0.0f) {
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)-0.015625f, (float)0.0f);
            }
            GL11.glPushMatrix();
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.0f);
            FactorizationBlockRender.renderItemIIcon(Core.registry.fan.func_77617_a(0));
            GL11.glPopMatrix();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.FanturpellerSpeed) {
            this.fan\u03c9 = input.readFloat();
            this.isSucking = input.readBoolean();
            this.target_speed = input.readByte();
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderItemOnServo(RenderServoMotor render, ServoMotor motor, ItemStack is, float partial) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.5f, (float)0.0625f, (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        render.renderItem(is);
        GL11.glPopMatrix();
    }
}

