/*
 * Decompiled with CFR 0.152.
 */
package factorization.util;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public final class DataUtil {
    public static final ItemStack NULL_ITEM = new ItemStack((Item)null, 0, 0);

    public static void writeTank(NBTTagCompound tag, FluidTank tank, String name2) {
        FluidStack ls = tank.getFluid();
        if (ls == null) {
            return;
        }
        NBTTagCompound liquid_tag = new NBTTagCompound();
        ls.writeToNBT(liquid_tag);
        tag.func_74782_a(name2, (NBTBase)liquid_tag);
    }

    public static void readTank(NBTTagCompound tag, FluidTank tank, String name2) {
        NBTTagCompound liquid_tag = tag.func_74775_l(name2);
        FluidStack ls = FluidStack.loadFluidStackFromNBT((NBTTagCompound)liquid_tag);
        tank.setFluid(ls);
    }

    public static NBTTagCompound readTag(DataInput input, NBTSizeTracker tracker) throws IOException {
        return CompressedStreamTools.func_152456_a((DataInput)input, (NBTSizeTracker)tracker);
    }

    public static ItemStack readStack(DataInput input, NBTSizeTracker tracker) throws IOException {
        ItemStack is = ItemStack.func_77949_a((NBTTagCompound)DataUtil.readTag(input, tracker));
        if (is == null || is.func_77973_b() == null) {
            return null;
        }
        return is;
    }

    public static NBTTagCompound readTag(DataInput input) throws IOException {
        return DataUtil.readTag(input, NBTSizeTracker.field_152451_a);
    }

    public static ItemStack readStack(DataInput input) throws IOException {
        return DataUtil.readStack(input, NBTSizeTracker.field_152451_a);
    }

    public static NBTTagCompound readTag(ByteBuf input) throws IOException {
        return ByteBufUtils.readTag((ByteBuf)input);
    }

    public static ItemStack readStack(ByteBuf input) throws IOException {
        return ByteBufUtils.readItemStack((ByteBuf)input);
    }

    public static NBTTagCompound item2tag(ItemStack is) {
        NBTTagCompound tag = new NBTTagCompound();
        is.func_77955_b(tag);
        tag.func_82580_o("id");
        String name2 = DataUtil.getName(is);
        if (name2 != null) {
            tag.func_74778_a("name", name2);
        }
        return tag;
    }

    public static ItemStack tag2item(NBTTagCompound tag, ItemStack defaultValue) {
        if (tag == null || tag.func_82582_d()) {
            return defaultValue.func_77946_l();
        }
        if (tag.func_74764_b("id")) {
            ItemStack is = ItemStack.func_77949_a((NBTTagCompound)tag);
            if (is == null) {
                return defaultValue.func_77946_l();
            }
            return is;
        }
        String itemName = tag.func_74779_i("name");
        if (StringUtils.func_151246_b((String)itemName)) {
            return defaultValue.func_77946_l();
        }
        byte stackSize = tag.func_74771_c("Count");
        short itemDamage = tag.func_74765_d("Damage");
        Item it = DataUtil.getItemFromName(itemName);
        if (it == null) {
            return defaultValue.func_77946_l();
        }
        ItemStack ret = new ItemStack(it, (int)stackSize, (int)itemDamage);
        if (tag.func_150297_b("tag", 10)) {
            ret.func_77982_d(tag.func_74775_l("tag"));
        }
        return ret;
    }

    public static TileEntity cloneTileEntity(TileEntity orig) {
        NBTTagCompound tag = new NBTTagCompound();
        orig.func_145841_b(tag);
        return TileEntity.func_145827_c((NBTTagCompound)tag);
    }

    public static Block getBlock(ItemStack is) {
        if (is == null) {
            return null;
        }
        return Block.func_149634_a((Item)is.func_77973_b());
    }

    public static Block getBlock(Item it) {
        return Block.func_149634_a((Item)it);
    }

    public static Block getBlock(int id) {
        return Block.func_149729_e((int)id);
    }

    public static Item getItem(int id) {
        return Item.func_150899_d((int)id);
    }

    public static Item getItem(Block block) {
        return Item.func_150898_a((Block)block);
    }

    public static int getId(Block block) {
        return Block.func_149682_b((Block)block);
    }

    public static int getId(Item it) {
        return Item.func_150891_b((Item)it);
    }

    public static int getId(ItemStack is) {
        if (is == null) {
            return 0;
        }
        return Item.func_150891_b((Item)is.func_77973_b());
    }

    public static String getName(Item it) {
        return Item.field_150901_e.func_148750_c((Object)it);
    }

    public static String getName(ItemStack is) {
        return DataUtil.getName(is == null ? null : is.func_77973_b());
    }

    public static String getName(Block b) {
        return Block.field_149771_c.func_148750_c((Object)b);
    }

    public static Block getBlockFromName(String blockName) {
        return (Block)Block.field_149771_c.func_82594_a(blockName);
    }

    public static Item getItemFromName(String itemName) {
        return (Item)Item.field_150901_e.func_82594_a(itemName);
    }
}

