/*
 * Decompiled with CFR 0.152.
 */
package factorization.util;

import com.mojang.authlib.GameProfile;
import factorization.api.Coord;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.stats.StatisticsFile;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;

public final class PlayerUtil {
    private static final UUID FZ_UUID = null;
    private static HashMap<String, WeakHashMap<World, FzFakePlayer>> usedPlayerCache = new HashMap();

    public static EntityPlayer makePlayer(Coord where, String use) {
        FzFakePlayer found;
        WeakHashMap<Object, FzFakePlayer> fakePlayerCache = usedPlayerCache.get(use);
        if (fakePlayerCache == null) {
            fakePlayerCache = new WeakHashMap();
            usedPlayerCache.put(use, fakePlayerCache);
        }
        if ((found = fakePlayerCache.get(where.w)) == null) {
            if (!(where.w instanceof WorldServer)) {
                throw new IllegalArgumentException("Can't construct fake players on the client");
            }
            found = new FzFakePlayer((WorldServer)where.w, "[FZ." + use + "]", where);
            fakePlayerCache.put(where.w, found);
        }
        found.where = where;
        where.setAsEntityLocation((Entity)found);
        Arrays.fill(found.field_71071_by.field_70460_b, null);
        Arrays.fill(found.field_71071_by.field_70462_a, null);
        found.field_70128_L = false;
        return found;
    }

    private static GameProfile makeProfile(String name2) {
        if (StringUtils.func_151246_b((String)name2)) {
            return new GameProfile(FZ_UUID, "[FZ]");
        }
        return new GameProfile(FZ_UUID, "[FZ:" + name2 + "]");
    }

    public static EntityPlayer fakeplayerToNull(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            if (player instanceof FakePlayer) {
                return null;
            }
            return player;
        }
        return null;
    }

    public static boolean isPlayerOpped(EntityPlayer player) {
        if ((player = PlayerUtil.fakeplayerToNull(player)) == null) {
            return false;
        }
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server == null) {
            return false;
        }
        return server.func_71203_ab().func_152596_g(player.func_146103_bH());
    }

    public static boolean isCommandSenderOpped(ICommandSender player) {
        if (player instanceof EntityPlayer) {
            return PlayerUtil.isPlayerOpped((EntityPlayer)player);
        }
        return player instanceof MinecraftServer || player instanceof RConConsoleSource;
    }

    public static boolean isPlayerCreative(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d;
    }

    public static StatisticsFile getStatsFile(EntityPlayer player) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server == null) {
            return null;
        }
        ServerConfigurationManager cm = server.func_71203_ab();
        return cm.func_152602_a(player);
    }

    private static class FzFakePlayer
    extends FakePlayer {
        Coord where;

        private FzFakePlayer(WorldServer world, String name2, Coord where) {
            super(world, PlayerUtil.makeProfile(name2));
            this.where = where;
            this.field_71135_a = new FakeNetHandler((EntityPlayerMP)this);
        }

        public ChunkCoordinates func_82114_b() {
            return new ChunkCoordinates(this.where.x, this.where.y, this.where.z);
        }

        public boolean func_85032_ar() {
            return true;
        }
    }

    private static class FakeNetHandler
    extends NetHandlerPlayServer {
        public FakeNetHandler(EntityPlayerMP player) {
            super(MinecraftServer.func_71276_C(), (NetworkManager)new FakeNetManager(), player);
        }

        public void func_147359_a(Packet ignored) {
        }
    }

    private static class FakeNetManager
    extends NetworkManager {
        public FakeNetManager() {
            super(false);
            this.field_150746_k = new EmbeddedChannel(new ChannelHandler[]{new ChannelHandler(){

                public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                }

                public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
                }

                @Deprecated
                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                }
            }});
            this.field_150746_k.pipeline().addFirst("fz:null", (ChannelHandler)new ChannelOutboundHandlerAdapter(){

                public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                }
            });
        }
    }
}

