/*
 * Decompiled with CFR 0.152.
 */
package factorization.utiligoo;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.common.BlockIcons;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.util.RenderUtil;
import factorization.utiligoo.GooData;
import javax.vecmath.Matrix4f;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.shader.ShaderManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public enum GooRenderer {
    INSTANCE;

    Minecraft mc = Minecraft.func_71410_x();
    ShaderManager sobel = null;
    boolean loaded = false;
    Matrix4f projectionMatrix;

    void resetProjectionMatrix() {
        this.projectionMatrix = new Matrix4f();
        this.projectionMatrix.setIdentity();
        this.projectionMatrix.m00 = 2.0f / (float)this.mc.field_71443_c;
        this.projectionMatrix.m11 = 2.0f / (float)(-this.mc.field_71440_d);
        this.projectionMatrix.m22 = -0.0020001999f;
        this.projectionMatrix.m33 = 1.0f;
        this.projectionMatrix.m03 = -1.0f;
        this.projectionMatrix.m13 = 1.0f;
        this.projectionMatrix.m23 = -1.0001999f;
    }

    private boolean useShaders() {
        return false;
    }

    private void beginGlWithShaders() {
        this.resetProjectionMatrix();
        int width = this.mc.func_147110_a().field_147621_c;
        int height = this.mc.func_147110_a().field_147618_d;
        this.sobel.func_147995_c();
    }

    private void endGlWithShaders() {
        this.sobel.func_147993_b();
    }

    private void beginGlNoShaders() {
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3042);
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)0.9);
        OpenGlHelper.func_148821_a((int)774, (int)768, (int)1, (int)0);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)32823);
        GL11.glPolygonOffset((float)0.0f, (float)-100.0f);
    }

    private void endGlNoShaders() {
        GL11.glPolygonOffset((float)0.0f, (float)0.0f);
        GL11.glPopAttrib();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderGoo(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        boolean rendered_something = false;
        for (int slot = 0; slot < 9; ++slot) {
            GooData data;
            ItemStack is = player.field_71071_by.func_70301_a(slot);
            if (is == null || is.func_77973_b() != Core.registry.utiligoo || (data = GooData.getNullGooData(is, (World)mc.field_71441_e)) == null || data.dimensionId != mc.field_71441_e.field_73011_w.field_76574_g || data.coords.length == 0) continue;
            if (!rendered_something) {
                rendered_something = true;
                EntityLivingBase camera = Minecraft.func_71410_x().field_71451_h;
                double cx = camera.field_70142_S + (camera.field_70165_t - camera.field_70142_S) * (double)event.partialTicks;
                double cy = camera.field_70137_T + (camera.field_70163_u - camera.field_70137_T) * (double)event.partialTicks;
                double cz = camera.field_70136_U + (camera.field_70161_v - camera.field_70136_U) * (double)event.partialTicks;
                mc.field_71446_o.func_110577_a(Core.blockAtlas);
                GL11.glPushMatrix();
                GL11.glTranslated((double)(-cx), (double)(-cy), (double)(-cz));
                if (this.useShaders()) {
                    this.beginGlWithShaders();
                } else {
                    this.beginGlNoShaders();
                }
            }
            this.renderGooFor(event, data, (EntityPlayer)player);
        }
        if (rendered_something) {
            GL11.glPopMatrix();
            if (this.useShaders()) {
                this.endGlWithShaders();
            } else {
                this.endGlNoShaders();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    void renderGooFor(RenderWorldLastEvent event, GooData data, EntityPlayer player) {
        boolean rendered_something = false;
        double render_dist_sq = 1024.0;
        Tessellator tess = Tessellator.field_78398_a;
        BlockRenderHelper block = BlockRenderHelper.instance;
        RenderBlocks rb = RenderUtil.getRB();
        for (int i = 0; i < data.coords.length; i += 3) {
            int x = data.coords[i + 0];
            int y = data.coords[i + 1];
            int z = data.coords[i + 2];
            if (player.func_70092_e((double)x, (double)y, (double)z) > render_dist_sq) continue;
            if (!rendered_something) {
                tess.func_78382_b();
                tess.func_78383_c();
                rendered_something = true;
            }
            Block b = player.field_70170_p.func_147439_a(x, y, z);
            Material mat = b.func_149688_o();
            int md = player.field_70170_p.func_72805_g(x, y, z);
            if (this.useShaders()) {
                if (mat.func_76230_c() && !b.hasTileEntity(md)) {
                    rb.func_147805_b(b, x, y, z);
                    continue;
                }
                b.func_149719_a((IBlockAccess)player.field_70170_p, x, y, z);
                block.func_149676_a((float)b.func_149704_x(), (float)b.func_149665_z(), (float)b.func_149706_B(), (float)b.func_149753_y(), (float)b.func_149669_A(), (float)b.func_149693_C());
                block.useTexture(BlockIcons.utiligoo$invasion);
                block.render(rb, x, y, z);
                continue;
            }
            if (mat.func_76230_c() && !b.hasTileEntity(md)) {
                rb.func_147792_a(b, x, y, z, BlockIcons.utiligoo$invasion);
                continue;
            }
            if (b.func_149645_b() == 2) {
                float d = 0.25f;
                block.setBlockBoundsOffset(d, d, d);
                block.useTexture(BlockIcons.utiligoo$invasion);
                block.render(rb, x, y, z);
                continue;
            }
            b.func_149719_a((IBlockAccess)player.field_70170_p, x, y, z);
            block.func_149676_a((float)b.func_149704_x(), (float)b.func_149665_z(), (float)b.func_149706_B(), (float)b.func_149753_y(), (float)b.func_149669_A(), (float)b.func_149693_C());
            block.useTexture(BlockIcons.utiligoo$invasion);
            block.render(rb, x, y, z);
        }
        if (rendered_something) {
            tess.func_78381_a();
        }
    }
}

