/*
 * Decompiled with CFR 0.152.
 */
package factorization.utiligoo;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.common.Command;
import factorization.common.ItemIcons;
import factorization.coremodhooks.HandleAttackKeyEvent;
import factorization.coremodhooks.HandleUseKeyEvent;
import factorization.shared.Core;
import factorization.shared.DropCaptureHandler;
import factorization.shared.ICaptureDrops;
import factorization.shared.ItemFactorization;
import factorization.shared.NetworkFactorization;
import factorization.util.InvUtil;
import factorization.util.ItemUtil;
import factorization.utiligoo.GooData;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;
import org.apache.commons.lang3.ArrayUtils;

public class ItemGoo
extends ItemFactorization {
    long break_prevention = 0L;
    int goo_recently_clicked_index = -1;
    ThreadLocal<Boolean> processing = new ThreadLocal();

    public ItemGoo(String name2, Core.TabType tabType) {
        super(name2, tabType);
        this.func_77625_d(32);
        this.func_77627_a(true);
        Core.loadBus((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
    }

    public boolean onItemUseFirst(ItemStack is, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        GooData data = GooData.getNullGooData(is, world);
        if (data != null && data.checkWorld(player, new Coord(world, x, y, z))) {
            return false;
        }
        if (player.func_70093_af()) {
            if (data == null) {
                return false;
            }
            ForgeDirection fd = ForgeDirection.getOrientation((int)side);
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            for (int i = 0; i < data.coords.length; i += 3) {
                data.coords[i + 0] = data.coords[i + 0] + fd.offsetX;
                int n = data.coords[i + 1] + fd.offsetY;
                data.coords[i + 1] = n;
                int goo_y = n;
                data.coords[i + 2] = data.coords[i + 2] + fd.offsetZ;
                if (goo_y >= 0 && goo_y <= 255) continue;
                toRemove.add(i + 0);
                toRemove.add(i + 1);
                toRemove.add(i + 2);
            }
            if (!toRemove.isEmpty()) {
                int[] removed = new int[toRemove.size()];
                int i = 0;
                for (Integer val : toRemove) {
                    removed[i++] = val;
                }
                data.coords = ArrayUtils.removeAll((int[])data.coords, (int[])removed);
                if (data.coords.length == 0) {
                    data.wipe(is, world);
                }
                is.field_77994_a += removed.length / 3;
            }
            data.func_76185_a();
            return true;
        }
        if (is.field_77994_a <= 1) {
            return false;
        }
        if (data == null) {
            data = GooData.getGooData(is, world);
        }
        for (int i = 0; i < data.coords.length; i += 3) {
            int ix = data.coords[i + 0];
            int iy = data.coords[i + 1];
            int iz = data.coords[i + 2];
            if (x != ix || y != iy || z != iz) continue;
            this.expandSelection(is, data, player, world, x, y, z, ForgeDirection.getOrientation((int)side));
            return true;
        }
        data.coords = ArrayUtils.addAll((int[])data.coords, (int[])new int[]{x, y, z});
        data.dimensionId = world.field_73011_w.field_76574_g;
        data.func_76185_a();
        --is.field_77994_a;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCommand(Command command, EntityPlayerMP player) {
        ItemStack held = player.func_70694_bm();
        if (command == Command.gooSelectNone) {
            this.trySelectNone((EntityPlayer)player, held);
            return;
        }
        MovingObjectPosition mop = this.func_77621_a(player.field_70170_p, (EntityPlayer)player, false);
        if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return;
        }
        for (int slot = 0; slot < 9; ++slot) {
            GooData data;
            ItemStack is = player.field_71071_by.func_70301_a(slot);
            if (is == null || is.func_77973_b() != this || (data = GooData.getNullGooData(is, player.field_70170_p)) == null || data.checkWorld((EntityPlayer)player, null)) continue;
            for (int i = 0; i < data.coords.length; i += 3) {
                int ix = data.coords[i + 0];
                int iy = data.coords[i + 1];
                int iz = data.coords[i + 2];
                if (ix != mop.field_72311_b || iy != mop.field_72312_c || iz != mop.field_72309_d) continue;
                final InvUtil.FzInv playerInv = InvUtil.openInventory((Entity)player, true);
                DropCaptureHandler.startCapture(new ICaptureDrops(){

                    @Override
                    public boolean captureDrops(int x, int y, int z, ArrayList<ItemStack> stacks) {
                        boolean any = false;
                        for (ItemStack is : stacks) {
                            if (ItemUtil.normalize(is) == null) continue;
                            is.field_77994_a = ItemUtil.getStackSize(playerInv.push(is.func_77946_l()));
                            any = true;
                        }
                        return any;
                    }
                });
                try {
                    if (command == Command.gooLeftClick) {
                        this.leftClick(player, data, is, held, mop);
                    } else if (command == Command.gooRightClick) {
                        this.rightClick((EntityPlayer)player, data, is, held, mop);
                    }
                }
                finally {
                    DropCaptureHandler.endCapture();
                }
                return;
            }
        }
    }

    private void leftClick(EntityPlayerMP player, GooData data, ItemStack gooItem, ItemStack held, MovingObjectPosition mop) {
        if (held == null || !(held.func_77973_b() instanceof ItemTool) && held.func_77973_b().getToolClasses(held).isEmpty()) {
            int radius = player.func_70093_af() ? 0 : 2;
            this.degooArea((EntityPlayer)player, data, gooItem, mop, radius);
        }
    }

    private void rightClick(EntityPlayer player, GooData data, ItemStack gooItem, ItemStack held, MovingObjectPosition mop) {
        block7: {
            block8: {
                block6: {
                    if (held != null) break block6;
                    Coord at = new Coord(player.field_70170_p, mop);
                    Block bat = at.getBlock();
                    if (!(bat instanceof BlockStairs) && !(bat instanceof BlockSlab)) {
                        return;
                    }
                    for (int i = 0; i < data.coords.length; i += 3) {
                        int md;
                        at.x = data.coords[i + 0];
                        at.y = data.coords[i + 1];
                        at.z = data.coords[i + 2];
                        Block b = at.getBlock();
                        if (b.hasTileEntity(md = at.getMd())) {
                            return;
                        }
                        if (b instanceof BlockStairs) {
                            md = !player.func_70093_af() ? (md ^= 4) : (md + 1) % 4 | md & 4;
                            at.setMd(md);
                            continue;
                        }
                        if (!(b instanceof BlockSlab) || player.func_70093_af()) continue;
                        at.setMd(md ^ 8);
                    }
                    break block7;
                }
                if (held.func_77973_b() != this) break block8;
                int n = player.func_70093_af() ? 1 : 2;
                for (int i = 0; i < n; ++i) {
                    this.expandSelection(gooItem, data, player, player.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, ForgeDirection.getOrientation((int)mop.field_72310_e));
                }
                break block7;
            }
            if (!(held.func_77973_b() instanceof ItemBlock)) break block7;
            this.replaceBlocks(gooItem, data, player.field_70170_p, player, mop, held);
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack is = player.field_71071_by.func_70301_a(i);
                if (is == null || ItemUtil.normalize(is) != null) continue;
                player.field_71071_by.func_70299_a(i, null);
            }
        }
    }

    private boolean check(int offset, int i, int x) {
        return offset == 0 || i == x;
    }

    boolean similarBlocks(Coord a, Coord b) {
        if (a.getBlock() == b.getBlock()) {
            return true;
        }
        ItemStack ais = a.getBrokenBlock();
        if (ais == null) {
            return false;
        }
        return ItemUtil.identical(ais, b.getBrokenBlock());
    }

    private void expandSelection(ItemStack is, GooData data, EntityPlayer player, World world, int x, int y, int z, ForgeDirection dir) {
        int i;
        Coord src = new Coord(world, x, y, z);
        HashSet<Coord> found = new HashSet<Coord>();
        for (int i2 = 0; i2 < data.coords.length; i2 += 3) {
            Coord at;
            Coord adj;
            int ix = data.coords[i2 + 0];
            int iy = data.coords[i2 + 1];
            int iz = data.coords[i2 + 2];
            if (!this.check(dir.offsetX, ix, x) || !this.check(dir.offsetY, iy, y) || !this.check(dir.offsetZ, iz, z) || (adj = (at = new Coord(world, ix, iy, iz)).add(dir)).isSolid() || adj.isSolidOnSide(dir.getOpposite()) || !this.similarBlocks(src, at)) continue;
            for (ForgeDirection fd : ForgeDirection.VALID_DIRECTIONS) {
                Coord nadj;
                Coord n;
                if (fd == dir || fd == dir.getOpposite() || !this.similarBlocks(at, n = at.add(fd)) || (nadj = n.add(dir)).isSolidOnSide(dir.getOpposite()) || nadj.getBlock() instanceof BlockSlab && (nadj.getMd() & 8) == 0) continue;
                found.add(n);
            }
        }
        ArrayList<Coord> addable = new ArrayList<Coord>();
        block2: for (Coord c : found) {
            for (i = 0; i < data.coords.length; i += 3) {
                int ix = data.coords[i + 0];
                int iy = data.coords[i + 1];
                int iz = data.coords[i + 2];
                if (c.x == ix && c.y == iy && c.z == iz) continue block2;
            }
            addable.add(c);
        }
        Collections.sort(addable);
        int count = addable.size();
        if (!player.field_71075_bZ.field_75098_d) {
            count = Math.min(count, is.field_77994_a - 1);
            count = Math.min(this.field_77777_bU - 1 - data.coords.length / 3, count);
        } else {
            int creativeMax = 1024;
            count = Math.min(count, creativeMax -= data.coords.length / 3);
        }
        if (count <= 0) {
            return;
        }
        int[] use = new int[count * 3];
        for (i = 0; i < count; ++i) {
            Coord c = (Coord)addable.get(i);
            use[i * 3 + 0] = c.x;
            use[i * 3 + 1] = c.y;
            use[i * 3 + 2] = c.z;
        }
        is.field_77994_a -= count;
        if (player.field_71075_bZ.field_75098_d) {
            is.field_77994_a = Math.max(1, is.field_77994_a);
        }
        data.coords = ArrayUtils.addAll((int[])data.coords, (int[])use);
        data.func_76185_a();
    }

    private boolean degooArea(EntityPlayer player, GooData data, ItemStack gooItem, MovingObjectPosition mop, int radius) {
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        if (data == null) {
            return false;
        }
        if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return false;
        }
        int d = radius;
        boolean any = false;
        for (int dx = -d; dx <= d; ++dx) {
            for (int dy = -d; dy <= d; ++dy) {
                for (int dz = -d; dz <= d; ++dz) {
                    any |= this.deselectCoord(gooItem, data, player.field_70170_p, mop.field_72311_b + dx, mop.field_72312_c + dy, mop.field_72309_d + dz, false);
                }
            }
        }
        if (any) {
            data.func_76185_a();
        }
        return false;
    }

    private void replaceBlocks(ItemStack is, GooData data, World world, EntityPlayer player, MovingObjectPosition mop, ItemStack source) {
        if (ItemUtil.normalize(source) == null) {
            return;
        }
        int removed = 0;
        Coord at = new Coord(world, 0, 0, 0);
        boolean creative = player.field_71075_bZ.field_75098_d;
        ArrayList<Integer> to_remove = new ArrayList<Integer>();
        for (int i = 0; i < data.coords.length; i += 3) {
            if (source.field_77994_a <= 0) {
                for (ItemStack replace : player.field_71071_by.field_70462_a) {
                    if (source == replace || !ItemUtil.identical(source, replace) || ItemUtil.normalize(replace) == null) continue;
                    source = replace;
                    break;
                }
                if (ItemUtil.normalize(source) == null) break;
            }
            at.x = data.coords[i + 0];
            at.y = data.coords[i + 1];
            at.z = data.coords[i + 2];
            if (creative) {
                at.setAir();
            } else {
                if (at.getHardness() < 0.0f) continue;
                Block block = at.getBlock();
                int md = at.getMd();
                EntityPlayerMP emp = (EntityPlayerMP)player;
                block.func_149681_a(world, at.x, at.y, at.z, md, (EntityPlayer)emp);
                boolean destroyed = block.removedByPlayer(world, (EntityPlayer)emp, at.x, at.y, at.z, true);
                if (destroyed) {
                    block.func_149664_b(world, at.x, at.y, at.z, md);
                }
                block.func_149636_a(world, (EntityPlayer)emp, at.x, at.y, at.z, md);
            }
            to_remove.add(i + 0);
            to_remove.add(i + 1);
            to_remove.add(i + 2);
            ItemBlock ib = (ItemBlock)source.func_77973_b();
            int origSize = source.field_77994_a;
            ib.func_77648_a(source, player, player.field_70170_p, at.x, at.y, at.z, mop.field_72310_e, (float)mop.field_72307_f.field_72450_a, (float)mop.field_72307_f.field_72448_b, (float)mop.field_72307_f.field_72449_c);
            if (creative) {
                source.field_77994_a = origSize;
            }
            ++removed;
        }
        if (removed <= 0) {
            return;
        }
        data.removeIndices(to_remove, is, world);
        if (!creative) {
            this.misplaceSomeGoo(is, world.field_73012_v, removed);
        } else {
            is.field_77994_a += removed;
            is.field_77994_a = Math.min(is.field_77994_a, this.field_77777_bU);
        }
    }

    private boolean deselectCoord(ItemStack is, GooData data, World world, int x, int y, int z, boolean bulkAction) {
        for (int i = 0; i < data.coords.length; i += 3) {
            int ix = data.coords[i + 0];
            int iy = data.coords[i + 1];
            int iz = data.coords[i + 2];
            if (ix != x || iy != y || iz != z) continue;
            data.coords = ArrayUtils.removeAll((int[])data.coords, (int[])new int[]{i, i + 1, i + 2});
            ++is.field_77994_a;
            if (data.coords.length == 0) {
                data.wipe(is, world);
            } else if (!bulkAction) {
                data.func_76185_a();
            }
            return true;
        }
        return false;
    }

    private void mineSelection(ItemStack is, GooData data, World world, MovingObjectPosition mop, EntityPlayerMP player, ItemStack tool) {
        boolean creative = player.field_71075_bZ.field_75098_d;
        Item toolItem = creative ? null : tool.func_77973_b();
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        int removed = 0;
        float origHardness = Float.POSITIVE_INFINITY;
        for (int i = 0; i < data.coords.length; i += 3) {
            boolean canBreak;
            float hardness;
            int ix = data.coords[i + 0];
            int iy = data.coords[i + 1];
            int iz = data.coords[i + 2];
            Block b = world.func_147439_a(ix, iy, iz);
            if (b.isAir((IBlockAccess)world, ix, iy, iz) || (hardness = b.func_149712_f(world, ix, iy, iz)) < 0.0f && !creative || hardness > origHardness) continue;
            boolean bl = canBreak = creative || hardness == 0.0f;
            if (toolItem != null) {
                canBreak |= toolItem.canHarvestBlock(b, tool) || toolItem.func_150893_a(tool, b) > 1.0f;
            }
            if (canBreak && player.field_71134_c.func_73084_b(ix, iy, iz)) {
                ++removed;
                toRemove.add(i);
                toRemove.add(i + 1);
                toRemove.add(i + 2);
            }
            if (ItemUtil.normalize(tool) == null) break;
        }
        if (removed == 0) {
            return;
        }
        data.removeIndices(toRemove, is, world);
        if (!creative) {
            this.misplaceSomeGoo(is, world.field_73012_v, removed);
        } else {
            is.field_77994_a += removed;
            is.field_77994_a = Math.min(is.field_77994_a, this.field_77777_bU);
        }
    }

    private void misplaceSomeGoo(ItemStack is, Random rand, int removed) {
        if (rand.nextInt(100) < 20) {
            --removed;
        }
        is.field_77994_a += removed;
    }

    public void func_77663_a(ItemStack is, World world, Entity player, int inventoryIndex, boolean isHeld) {
        if (world.field_72995_K) {
            return;
        }
        GooData data = GooData.getNullGooData(is, world);
        if (data == null) {
            return;
        }
        if (!(player instanceof EntityPlayer)) {
            return;
        }
        if (!data.isPlayerOutOfDate(player)) {
            return;
        }
        NBTTagCompound dataTag = new NBTTagCompound();
        data.func_76187_b(dataTag);
        FMLProxyPacket toSend = Core.network.entityPacket(player, NetworkFactorization.MessageType.UtilityGooState, dataTag);
        Core.network.broadcastPacket((EntityPlayer)player, new Coord(player), toSend);
    }

    @SideOnly(value=Side.CLIENT)
    public static void handlePacket(ByteBuf input) throws IOException {
        NBTTagCompound dataTag = ByteBufUtils.readTag((ByteBuf)input);
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        GooData data = new GooData(dataTag.func_74779_i("mapname"));
        data.func_76184_a(dataTag);
        world.func_72823_a(data.field_76190_i, (WorldSavedData)data);
    }

    public IIcon func_77650_f(ItemStack is) {
        int size = is.field_77994_a;
        int third = is.func_77976_d() / 3;
        int fullness = size / third;
        if (fullness <= 1) {
            return ItemIcons.utiligoo$low;
        }
        if (fullness <= 2) {
            return ItemIcons.utiligoo$medium;
        }
        return ItemIcons.utiligoo$high;
    }

    public IIcon getIcon(ItemStack is, int pass) {
        return this.func_77650_f(is);
    }

    @Override
    protected void addExtraInformation(ItemStack is, EntityPlayer player, List list, boolean verbose) {
        super.addExtraInformation(is, player, list, verbose);
        GooData data = GooData.getNullGooData(is, player.field_70170_p);
        if (data != null) {
            list.add(I18n.func_135052_a((String)"item.factorization:utiligoo.placed", (Object[])new Object[]{data.coords.length / 3}));
            if (player != null && player.field_70170_p != null && data.dimensionId != player.field_70170_p.field_73011_w.field_76574_g) {
                list.add(I18n.func_135052_a((String)"item.factorization:utiligoo.wrongDimension", (Object[])new Object[0]));
            }
            int minX = 0;
            int minY = 0;
            int minZ = 0;
            int maxX = 0;
            int maxY = 0;
            int maxZ = 0;
            for (int i = 0; i < data.coords.length; i += 3) {
                int x = data.coords[i + 0];
                int y = data.coords[i + 1];
                int z = data.coords[i + 2];
                if (i == 0) {
                    minX = maxX = x;
                    minY = maxY = y;
                    minZ = maxZ = z;
                    continue;
                }
                minX = Math.min(x, minX);
                minY = Math.min(y, minY);
                minZ = Math.min(z, minZ);
                maxX = Math.max(x, maxX);
                maxY = Math.max(y, maxY);
                maxZ = Math.max(z, maxZ);
            }
            list.add(I18n.func_135052_a((String)"item.factorization:utiligoo.min", (Object[])new Object[]{minX, minY, minZ}));
            list.add(I18n.func_135052_a((String)"item.factorization:utiligoo.max", (Object[])new Object[]{maxX, maxY, maxZ}));
            if (Core.dev_environ) {
                list.add("#" + data.field_76190_i);
            }
        }
    }

    boolean gooHilighted(EntityPlayer player, MovingObjectPosition mop) {
        if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return false;
        }
        for (int slot = 0; slot < 9; ++slot) {
            GooData data;
            ItemStack is = player.field_71071_by.func_70301_a(slot);
            if (is == null || is.func_77973_b() != this || (data = GooData.getNullGooData(is, player.field_70170_p)) == null) continue;
            for (int i = 0; i < data.coords.length; i += 3) {
                int x = data.coords[i + 0];
                int y = data.coords[i + 1];
                int z = data.coords[i + 2];
                if (x != mop.field_72311_b || y != mop.field_72312_c || z != mop.field_72309_d) continue;
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void interceptGooClick(HandleUseKeyEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        MovingObjectPosition mop = mc.field_71476_x;
        if (this.gooHilighted((EntityPlayer)player, mop)) {
            Command.gooRightClick.call((EntityPlayer)player);
            event.setCanceled(true);
            mc.field_71467_ac = 4;
        }
    }

    private boolean trySelectNone(EntityPlayer player, ItemStack is) {
        if (is == null || !(is.func_77973_b() instanceof ItemGoo)) {
            return false;
        }
        GooData data = GooData.getNullGooData(is, player.field_70170_p);
        if (data == null) {
            return false;
        }
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        int deployed_goo = data.coords.length / 3;
        data.wipe(is, player.field_70170_p);
        is.field_77994_a += deployed_goo;
        is.field_77994_a = Math.min(is.field_77994_a, this.field_77777_bU);
        return true;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void interceptGooBreak(HandleAttackKeyEvent event) {
        ItemStack held;
        Minecraft mc = Minecraft.func_71410_x();
        MovingObjectPosition mop = mc.field_71476_x;
        EntityClientPlayerMP player = mc.field_71439_g;
        if (this.break_prevention > 0L) {
            if (this.break_prevention > System.currentTimeMillis()) {
                if (this.goo_recently_clicked_index == this.idOfHeld((EntityPlayer)player) && !player.func_70093_af()) {
                    Command.gooSelectNone.call((EntityPlayer)player);
                    this.goo_recently_clicked_index = -1;
                }
                event.setCanceled(true);
                this.delayBreak();
                return;
            }
            this.break_prevention = 0L;
        }
        if ((held = player.func_70694_bm()) != null && (held.func_77973_b() instanceof ItemTool || !held.func_77973_b().getToolClasses(held).isEmpty())) {
            return;
        }
        if (this.gooHilighted((EntityPlayer)player, mop)) {
            Command.gooLeftClick.call((EntityPlayer)player);
            event.setCanceled(true);
            this.delayBreak();
            this.goo_recently_clicked_index = this.idOfHeld((EntityPlayer)player);
        }
    }

    private int idOfHeld(EntityPlayer player) {
        if (player == null) {
            return -1;
        }
        GooData gd = GooData.getNullGooData(player.func_70694_bm(), player.field_70170_p);
        if (gd == null) {
            return -1;
        }
        return player.func_70694_bm().func_77960_j();
    }

    private void delayBreak() {
        int delay = 450;
        Minecraft mc = Minecraft.func_71410_x();
        this.break_prevention = System.currentTimeMillis() + (long)delay;
        mc.field_71429_W = delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void mineGooeyBlocks(BlockEvent.BreakEvent event) {
        if (this.processing.get() != null) {
            return;
        }
        EntityPlayer p = event.getPlayer();
        if (!(p instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)p;
        boolean creative = player.field_71075_bZ.field_75098_d;
        ItemStack held = player.func_70694_bm();
        if (held == null && !creative) {
            return;
        }
        MovingObjectPosition mop = this.func_77621_a(player.field_70170_p, (EntityPlayer)player, false);
        if (mop == null) {
            return;
        }
        for (int slot = 0; slot < 9; ++slot) {
            GooData data;
            ItemStack is = ItemUtil.normalize(player.field_71071_by.func_70301_a(slot));
            if (is == null || is.func_77973_b() != this || (data = GooData.getNullGooData(is, player.field_70170_p)) == null) continue;
            for (int i = 0; i < data.coords.length; i += 3) {
                int ix = data.coords[i + 0];
                int iy = data.coords[i + 1];
                int iz = data.coords[i + 2];
                if (ix != mop.field_72311_b || iy != mop.field_72312_c || iz != mop.field_72309_d) continue;
                this.processing.set(true);
                try {
                    this.mineSelection(is, data, player.field_70170_p, mop, player, held);
                }
                finally {
                    this.processing.remove();
                }
                return;
            }
        }
    }
}

