
local L, addon, ns = {}, ...;

ns.L = setmetatable(L,{__index=function(t,k)
	local v = tostring(k);
	rawset(t,k,v);
	return v;
end});

-- Do you want to help localize this addon?
-- https://www.curseforge.com/wow/addons/@cf-project-name@/localization

L["AddOnLoaded"] = "AddOn loaded..."
L["AddOnLoadedDesc"] = "Show 'AddOn Loaded...' message on logins and UI reloads."
L["AddOnLoadedDescAlt"] = "Alternatively you can hold shift key on loading screen to display this message for this login only."
L["AnotherAddOnsHijackedFunc"] = "Warning: Another addon has hijacked some essential functions. See following List:"
L["BgTransparency"] = "Background transparency"
L["Black player dot"] = "Black player dot"
L["Blizzards player arrow"] = "Blizzards player arrow"
L["Blizzards player arrow (smaller)"] = "Blizzards player arrow (smaller)"
L["CardinalPoints"] = "Cardinal points"
L["CardinalPointsColorDesc"] = "Adjust the color of cardinal points (%s)"
L["CardinalPointsColorResetDesc"] = "Reset the color of cardinal points (%s)"
L["CardinalPointsGroup1"] = "N, W, S, E"
L["CardinalPointsGroup2"] = "NW, NE, SW, SE"
L["CardinalPointsShow"] = "Show cardinal points"
L["CardinalPointsShowDesc"] = "Display the cardinal points on HUD"
L["ChangeRadius"] = "Distance from center"
L["ChangeRadiusDesc"] = "Change the distance from center from the HUD"
L["Coords"] = "Coordinations"
L["CoordsBottom"] = "Coordinations on bottom"
L["CoordsBottomDesc"] = "Display the player coordinations on bottom"
L["CoordsColorDesc"] = "Adjust the color of coordations"
L["CoordsColorResetDesc"] = "Reset the color of coordations"
L["CoordsShow"] = "Show coordinations"
L["CoordsShowDesc"] = "Show player coordinations on HUD"
L["DataBrokerOptions"] = "to open FarmHud options"
L["DataBrokerToggle"] = "to toggle FarmHud"
L["DataBrokerToggleBackground"] = "to toggle minimap background"
L["DebugOptFrames"] = "Print unwanted elements"
L["DebugOptFramesDesc"] = "Print a list of unwanted elements anchored on Minimap if FarmHud enabled."
L["DebugOptInfo"] = "This section contains options to help tracking problems with other addons."
L["E"] = "E"
L["ExtraAddOnLoaded"] = "The extra addon '%s' is enabled!"
L["ExtraAddOnNotLoaded"] = "The extra addon '%s' must be enabled for this option!"
L["GatherCircle"] = "Gather circle"
L["GatherCircleColorDesc"] = "Adjust the color of the gather circle"
L["GatherCircleDesc"] = "The gather circle is a visual help line. It stands for the distance around your position in there all points of interest (mailbox, ore, herb) will be appear on minimap and FarmHud"
L["GatherCircleShow"] = "Show gather circle"
L["GatherCircleShowDesc"] = "Show the gather circle on HUD"
L["Golden player dot"] = "Golden player dot"
L["HealCircle"] = "Heal range circle"
L["HealcircleColorDesc"] = "Adjust the color of the heal range circle"
L["HealcircleDesc"] = "The heal range circle is a visual help line. It stands for the distance to your position in which you can heal other players"
L["HealcircleShow"] = "Show heal range circle"
L["HealcircleShowDesc"] = "Show the heal range circle on HUD"
L["Hide player arrow"] = "Hide player arrow"
L["HudSize"] = "HUD Size"
L["HudSizeDesc"] = "Sets the HUD size to a percentage of screen height"
L["HudSymbolScale"] = "HUD symbol scale"
L["HudSymbolScaleDesc"] = "Scale the symbols on HUD"
L["KeyBindBackground"] = "Toggle FarmHud's minimap background"
L["KeyBindBackgroundDesc"] = "Set the keybinding to show minimap background."
L["KeyBindMouse"] = "Toggle FarmHud's tooltips (Can't click through Hud)"
L["KeyBindMouseDesc"] = "Set the keybinding to allow mouse over for tooltips from point of interest nodes (like ore,herb or quest giver). Or for clicking on the hud to submit a ping to your group or raid."
L["KeyBindToggle"] = "Toggle FarmHud's Display"
L["KeyBindToggleDesc"] = "Set the keybinding to show FarmHud."
L["KnownProblematicAddOnDetected"] = "WARNING: you are using an addon that makes a smooth cooperation with FarmHud difficult. Possible Workaround: You can try to hide disturbing elements. Disable \\\"Show elements\\\" in FarmHud options."
L["MinimapIcon"] = "Minimap Icon"
L["MinimapIconDesc"] = "Show the minimap icon."
L["MouseOn"] = "MOUSE ON"
L["MouseOver"] = "Mouse over options"
L["MouseOverInfoColorDesc"] = "Adjust color for the text 'MOUSE ON' on the HUD"
L["MouseOverOnHold"] = "Mouse over on hold modifier key"
L["MouseOverOnHoldDesc"] = "This is an option to enable mouse over mode while you are holding a modifier key like Alt"
L["N"] = "N"
L["NE"] = "NE"
L["NW"] = "NW"
L["OnScreen"] = "OnScreen buttons"
L["OnScreenAlphaDesc"] = "Adjust the transparency the the OnScreen buttons"
L["OnScreenBottom"] = "OnScreen buttons on bottom"
L["OnScreenBottomDesc"] = "Display the OnScreen buttons on bottom from center of the HUD"
L["OnScreenShow"] = "Show OnScreen buttons"
L["OnScreenShowDesc"] = "Show OnScreen buttons (\"mouse on\"-mode, hud close button and more)"
L["PlaceholderDesc"] = "The placeholder is an element to hold all visible elements of your minimap in place while Farmhud is active."
L["PlayerDot"] = "Player arrow or dot"
L["PlayerDotDesc"] = "Change the look of your player dot/arrow on opened FarmHud"
L["PleaseReportThisMessage"] = "Please report this message on curseforge issues as Screenshots or text."
L["QuestArrow"] = "Quest arrow"
L["QuestArrowDesc"] = "Display quest arrow on opened HUD"
L["QuestArrowHide"] = "Hide quest arrow on opened HUD"
L["QuestArrowInfoMsg"] = "Show info message"
L["QuestArrowInfoMsgDesc"] = "Display info message in general chat window"
L["QuestArrowInfoMsgDisabled"] = "Quest tracking disabled"
L["QuestArrowInfoMsgRestored"] = "Quest tracking restored"
L["RangeCircles"] = "Range circles"
L["ResetColor"] = "Reset color"
L["Rotation"] = "Rotation"
L["RotationDesc"] = "Force enable minimap rotation on HUD mode"
L["S"] = "S"
L["SE"] = "SE"
L["ShowPlaceholder"] = "Show elements"
L["ShowPlaceholderBg"] = "Show Background"
L["ShowPlaceholderBgDesc"] = "Display a black background instead of the minimap while FarmHud is active."
L["ShowPlaceholderDesc"] = "The elements of your minimap remain visible even when FarmHud is active."
L["SupportBlizzard"] = "Blizzard have made some changes that makes useless to offer optional support of single addons or libraries."
L["SupportHereBeDragon"] = "Tomtom and HandyNotes are supported through the library HereBeDragon but HandyNotes have a problem with Hud toggling. All icons around you position will be disappear by toggling FarmHud. But through a littble bit walking/flying arround should be displayed again."
L["SupportOptions"] = "Support options"
L["SW"] = "SW"
L["TextScale"] = "Text scale"
L["TextScaleDesc"] = "Text scaling on HUD for cardinal points, mouse on and coordinations"
L["Time"] = "Server/Local time"
L["TimeBottom"] = "Time on bottom"
L["TimeBottomDesc"] = "Display the time on bottom"
L["TimeColorDesc"] = "Adjust the color of time"
L["TimeColorResetDesc"] = "Reset the color of time"
L["TimeLocal"] = "Local time"
L["TimeLocalDesc"] = "Display local time."
L["TimeServer"] = "Server time"
L["TimeServerDesc"] = "Display server time."
L["TimeShow"] = "Show time"
L["TimeShowDesc"] = "Display server or local time on HUD mode"
L["TrackingOptions"] = "Tracking Options"
L["TrackingOptionsDesc"] = "Toggle tracking icons on opened FarmHud.|n|n\"Like minimap\" means your settings/changes over the minimap tracking button will be used on opened FarmHud."
L["TrackingOptionsLikeMinimap"] = "Like minimap"
L["TrailPath"] = "Trail path"
L["TrailPathColorsDesc"] = "Adjust color of trail path icons"
L["TrailPathCount"] = "Point count"
L["TrailPathCountDesc"] = "Adjust the max. amount of footprints on minimap/farmhud."
L["TrailPathIcon"] = "Icon"
L["TrailPathIconDesc"] = "Choose an icon for your footprints."
L["TrailPathScale"] = "Icon scaling"
L["TrailPathScaleDesc"] = "Adjust the size of your footprints."
L["TrailPathShow"] = "Show trail path"
L["TrailPathTimeout"] = "Fade out (sec.)"
L["TrailPathTimeoutDesc"] = "Adjust the time after which you footprints are removed from minimap/farmhud."
L["W"] = "W"
L["White player dot"] = "White player dot"

if LOCALE_deDE then
L["AddOnLoaded"] = "AddOn geladen..."
L["AddOnLoadedDesc"] = "Zeigt die Nachricht 'AddOn geladen...' beim Einloggen und Neuladen des UIs."
L["AddOnLoadedDescAlt"] = "Alternativ kannst du die Umschalt-Taste beim Ladebildschirm gedrückt halten zum anzeigen der Nachricht nur diesen Login."
L["AnotherAddOnsHijackedFunc"] = "Warnung: Ein anderes Addon hat einige wesentliche Funktionen entführt. Siehe folgende Liste:"
L["BgTransparency"] = "Hintergrundtransparenz"
L["Black player dot"] = "Schwarzer Spielerpunkt"
L["Blizzards player arrow"] = "Blizzard Spielerpfeil"
L["Blizzards player arrow (smaller)"] = "Blizzard Spielerpfeil (kleiner)"
L["CardinalPoints"] = "Himmelsrichtungen"
L["CardinalPointsColorDesc"] = "Ändere die Farbe der Himmelsrichtungen (%s)"
L["CardinalPointsColorResetDesc"] = "Die Farbe der Himmelsrichtungen (%s) zurücksetzen"
L["CardinalPointsGroup1"] = "N, W, S, O"
L["CardinalPointsGroup2"] = "NW, NO, SW, SO"
L["CardinalPointsShow"] = "Zeige Himmelsrichtungen"
L["CardinalPointsShowDesc"] = "Zeige die Himmelsrichtungen auf dem HUD"
L["ChangeRadius"] = "Distanz zum Zentrum"
L["ChangeRadiusDesc"] = "Ändere die Distanze zum Zentrum vom HUD"
L["Coords"] = "Koordinaten"
L["CoordsBottom"] = "Koordinaten unten"
L["CoordsBottomDesc"] = "Zeige die Spielerkoordinaten unten"
L["CoordsColorDesc"] = "Ändere die Farbe der Koordinaten"
L["CoordsColorResetDesc"] = "Die Farbe der Koordinaten zurücksetzen"
L["CoordsShow"] = "Zeige Spielerkoordinaten"
L["CoordsShowDesc"] = "Zeige die Spielerkoordinaten auf dem HUD"
L["DataBrokerOptions"] = "zum öffnen der FarmHud Optionen"
L["DataBrokerToggle"] = "um FarmHud ein-/auszublenden"
L["DataBrokerToggleBackground"] = "um den Minimaphintergrund ein-/auszublenden."
L["DebugOptFrames"] = "Unerwünschte Elemente ausgeben"
L["DebugOptFramesDesc"] = "Gibt eine Liste unerwünschter Elemente aus, die an der Minimap verankert sind, wenn FarmHud aktiviert ist."
L["DebugOptInfo"] = "Dieser Bereich enthält Optionen zum Verfolgen von Problemen mit anderen Addons."
L["E"] = "O"
L["ExtraAddOnLoaded"] = "Das Extra-AddOn '%s' ist aktiviert!"
L["ExtraAddOnNotLoaded"] = "Das Extra-AddOn '%s' muss aktiviert sein für diese Option!"
L["GatherCircle"] = "Sammelkreis"
L["GatherCircleColorDesc"] = "Ändere die Farbe des Sammelkreises"
L["GatherCircleDesc"] = "Der Sammelkreis ist eine visuelle Hilfslinie. Sie steht für die Distanz um deine Position, in der alle Punkte von Interesse (Briefkästen, Erze, Kräuter) auf der Minikarte und im FarmHud erscheinen."
L["GatherCircleShow"] = "Zeige Sammelkreis"
L["GatherCircleShowDesc"] = "Zeige den Sammelkreis auf dem HUD"
L["Golden player dot"] = "Goldener Spielerpunkt"
L["HealCircle"] = "Heilkreis"
L["HealcircleColorDesc"] = "Ändere die Farbe des Heilkreises."
L["HealcircleDesc"] = "Der Heilkreis ist eine visuelle Hilfslinie. Sie steht für die Distanz um deine Position, in der andere Spieler geheilt werden können."
L["HealcircleShow"] = "Zeige Heilkreis"
L["HealcircleShowDesc"] = "Zeige den Heilkreis auf dem HUD."
L["Hide player arrow"] = "Spielerpfeil verstecken"
L["HudSize"] = "HUD Größe"
L["HudSizeDesc"] = "Stellt die HUD Größe nach einem Prozentwert der Bildschirmhöhe ein"
L["HudSymbolScale"] = "HUD Symbolskalierung"
L["HudSymbolScaleDesc"] = "Skaliere die Symbole auf dem HUD"
L["KeyBindBackground"] = "FarmHud's Minikartenhintergrund umschalten"
L["KeyBindBackgroundDesc"] = "Setzte eine Tastaturbelegung zum Anzeigen des Minikartenhintergrunds"
L["KeyBindMouse"] = "FarmHud's tooltips umschalten (Kann nicht durch Hud klicken)"
L["KeyBindMouseDesc"] = "Stellt die Tastenzuweisung so ein, dass ein Tooltip erscheint sobald die Maus über einen interessanten Punkt (wie Erz, Kräuter oder Questgeber) bewegt wurde. Oder um auf das HUD zu klicken um einen Ping für deine Gruppe oder deinen Raid zu erzeugen."
L["KeyBindToggle"] = "FarmHud's Anzeige umschalten"
L["KeyBindToggleDesc"] = "Setze eine Tastaturbelegung um FarmHud anzuzeigen"
L["KnownProblematicAddOnDetected"] = "WARNUNG: Du benutzt ein AddOn, das eine reibungslose zusammenarbeit mit FarmHud erschwert. Mögliche Problemumgehung: Du kannst versuchen störende Elemente zu verstecken. Deaktiviere \\\"Zeige Elemente\\\" in den FarmHud Optionen."
L["MinimapIcon"] = "Minikartensymbol"
L["MinimapIconDesc"] = "Zeige das Minikartensymbol"
L["MouseOn"] = "MAUS AN"
L["MouseOver"] = "Mausdrüber Optionen"
L["MouseOverInfoColorDesc"] = "Passt die Textfarbe von 'MAUS AN' auf dem HUD an."
L["MouseOverOnHold"] = "Mausdrüber beim Halten einer Zusatztaste"
L["MouseOverOnHoldDesc"] = "Dies ist eine Option zum aktvieren des Mausdrüber-Modus solange du eine Zusatztaste wie Alt gedrückt hälst"
L["N"] = "N"
L["NE"] = "NO"
L["NW"] = "NW"
L["OnScreen"] = "OnScreen Schaltflächen"
L["OnScreenAlphaDesc"] = "Ändere die Transparenz der OnScreen Schaltflächen"
L["OnScreenBottom"] = "OnScreen Schaltflächen unten"
L["OnScreenBottomDesc"] = "Zeige die OnScreen Schaltflächen unterhalb des Zentrums vom HUD an"
L["OnScreenShow"] = "Zeige OnScreen Schaltflächen"
L["OnScreenShowDesc"] = "Zeige OnScreen Schaltflächen (\"Maus an\"-Modus, Hud-Schließen-Schaltflächen und mehr)"
L["PlaceholderDesc"] = "Der Platzhalter ist ein Element um sichtbare Element deiner Minikarte am Platz zu halten solange FarmHud aktiv ist."
L["PlayerDot"] = "Spielerpfeil oder Punkt"
L["PlayerDotDesc"] = "Verändere das Aussehen deines Spielerpunkts/-pfeils im geöffneten FarmHud"
L["PleaseReportThisMessage"] = "Bitte melde diese Nachricht bei Curseforge unter Probleme als Screenshots oder Text."
L["QuestArrow"] = "Questpfeil"
L["QuestArrowDesc"] = "Zeigt den Questpfeil auf geöffnetem HUD"
L["QuestArrowHide"] = "Questpfeil bei geöffnetem HUD verstecken"
L["QuestArrowInfoMsg"] = "Zeige Infomeldung"
L["QuestArrowInfoMsgDesc"] = "Zeige Infomeldungen im Allgemeinen Chatfenster an."
L["QuestArrowInfoMsgDisabled"] = "Questverfolgung deaktiviert"
L["QuestArrowInfoMsgRestored"] = "Questverfolgung aktiviert"
L["RangeCircles"] = "Reichweitenkreise"
L["ResetColor"] = "Farbe zurücksetzen"
L["Rotation"] = "Drehung"
L["RotationDesc"] = "Forciert die Antivierung der Minikartenrotation im HUD Modus"
L["S"] = "S"
L["SE"] = "SO"
L["ShowPlaceholder"] = "Zeige Elemente"
L["ShowPlaceholderBg"] = "Zeige Hintergrund"
L["ShowPlaceholderBgDesc"] = "Zeige einen schwarzen Hintergrund anstelle der Minikarte solange FarmHud aktiv ist."
L["ShowPlaceholderDesc"] = "Die Elemente deiner Minikarte bleiben sichtbar auch wenn FarmHud aktiv ist."
L["SupportBlizzard"] = "Blizzard hat ein paar Änderungen gemacht, die es Nutzslos machen noch optionale Unterstützungen für einzelne AddOns und Bibliotheken anzubieten."
L["SupportHereBeDragon"] = "TomTom und HandyNotes werden durch die Bibliothek HereBeDragon unterstützt, aber HandyNotes hat ein Problem beim Umschalten des HUD's. Alle Symbole um deine Position verschwinden beim ein/-ausblenden von FarmHud. Aber durch ein wenig herumlaufen/-fliegen sollten sie bald wieder angezeigt werden."
L["SupportOptions"] = "Unterstützungsoptionen"
L["SW"] = "SW"
L["TextScale"] = "Textskalierung"
L["TextScaleDesc"] = "Textskalierung auf dem HUD für Himmelsrichtungen, \"MAUS AN\" und Koordinaten"
L["Time"] = "Server/Lokale Zeit"
L["TimeBottom"] = "Zeit unten"
L["TimeBottomDesc"] = "Zeigt die Zeit unten an"
L["TimeColorDesc"] = "Ändere die Farbe der Zeit"
L["TimeColorResetDesc"] = "Die Farbe der Zeit zurücksetzen"
L["TimeLocal"] = "Lokale Zeit"
L["TimeLocalDesc"] = "Zeige die lokale Zeit an."
L["TimeServer"] = "Serverzeit"
L["TimeServerDesc"] = "Zeige die Serverzeit an."
L["TimeShow"] = "Zeige die Zeit"
L["TimeShowDesc"] = "Zeige Serverzeit oder lokale Zeit im HUD Modus"
L["TrackingOptions"] = "Aufspür-Optionen"
L["TrackingOptionsDesc"] = "Zeigt Aufspür-Symbole auf geöffnetem FarmHud.|n|n\"Wie bei Minikarte\" bedeutet, deine Einstellungen/Änderungen über den Aufspür-Button an der Minikarte, wird genutzt auf geöffnetem FarmHud."
L["TrackingOptionsLikeMinimap"] = "Wie bei Minikarte"
L["TrailPath"] = "Wanderweg"
L["TrailPathColorsDesc"] = "Ändere die Farbe der Wanderwegsymbole."
L["TrailPathCount"] = "Punktanzahl"
L["TrailPathCountDesc"] = "Passe die maximale Anzahl von Fußabdrücken auf der Minimap/FarmHud an."
L["TrailPathIcon"] = "Symbol"
L["TrailPathIconDesc"] = "Wähle ein Symbol für deine Fußabdrücke."
L["TrailPathScale"] = "Symbolskalierung"
L["TrailPathScaleDesc"] = "Ändere die Größe deiner Fußabdrücke."
L["TrailPathShow"] = "Zeige Wanderweg"
L["TrailPathTimeout"] = "Verblassen (Sek.)"
L["TrailPathTimeoutDesc"] = "Passe die Zeit an, nach der deine Fußabdrücke von der Minimap/FarmHud entfernt werden."
L["W"] = "W"
L["White player dot"] = "Weißer Spielerpunkt"

elseif LOCALE_esES then
L["AddOnLoaded"] = "AddOn Cargado..."

elseif LOCALE_esMX then
L["AddOnLoaded"] = "Accesorio cargado..."
L["AnotherAddOnsHijackedFunc"] = "Advertencia: Otro accesorio esta usando algunas funciones importantes. Consulte la siguiente lista."
L["BgTransparency"] = "Transparencia del fondo"
L["Black player dot"] = "Jugador, punto negro"
L["Blizzards player arrow"] = "Indicador de jugador de Blizzard"
L["Blizzards player arrow (smaller)"] = "Indicador de jugador de Blizzard pequeño"
L["CardinalPoints"] = "Puntos cardinales"
L["CardinalPointsColorDesc"] = "Ajusta el color de los Puntos cardinales (%s)"
L["CardinalPointsColorResetDesc"] = "Restaura el color de los Puntos cardinales (%s)"
L["CardinalPointsGroup1"] = "N, O, S, E"
L["CardinalPointsGroup2"] = "NO, NE, SO, SE"
L["CardinalPointsShow"] = "Muestra los puntos cardinales"
L["CardinalPointsShowDesc"] = "Muestra los puntos cardinales en el HUD"
L["ChangeRadius"] = "Distancia desde el centro"
L["ChangeRadiusDesc"] = "Cambia la distancia desde el centro del HUD"
L["Coords"] = "Coordenadas"
L["CoordsBottom"] = "Coordenadas en la parte inferior"
L["CoordsBottomDesc"] = "Muestra las coordenadas del jugador en la parte inferior"
L["CoordsColorDesc"] = "Ajusta el color de las coordenadas"
L["CoordsColorResetDesc"] = "Restaura el color de las coordenadas"
L["CoordsShow"] = "Muestra las coordenadas"
L["CoordsShowDesc"] = "Muestra las coordenadas del jugador en el HUD"
L["DataBrokerOptions"] = "para mostrar las opciones de FarmHud"
L["DataBrokerToggle"] = "para alternar Farmhub"
L["DebugOptFrames"] = "Lista de elementos no deseados"
L["DebugOptFramesDesc"] = "Imprime una lista de elementos anclados al minimapa no deseados cuando FarmHud este activo."
L["DebugOptInfo"] = "Este apartado contiene opciones para ayudar a rastrear problemas con otros accesorios."
L["E"] = "E"
L["ExtraAddOnLoaded"] = "El accesorio adicional '%s' esta activado!"
L["ExtraAddOnNotLoaded"] = "El accesorio adicional '%s' debe estar activado para usar esta opción!"
L["GatherCircle"] = "Circulo de recolección"
L["GatherCircleColorDesc"] = "Ajusta el color del circulo de recolección"
L["GatherCircleDesc"] = "El circulo de recolección es una línea de ayuda visual. Representa la distancia alrededor de tu posición, en ella aparecerán todos los puntos de interés (correo, minerales, hierbas) tanto en el minimapa como en FarmHud"
L["GatherCircleShow"] = "Muestra el circulo de recolección"
L["GatherCircleShowDesc"] = "Muestra el circulo de recolección en el HUD"
L["Golden player dot"] = "Jugador, punto dorado"
L["HealCircle"] = "Circulo de sanación"
L["HealcircleColorDesc"] = "Cambia el color del circulo de sanación"
L["HealcircleDesc"] = "El circulo de sanación es una ayuda visual. Representa la distancia desde tu posición en la cual puedes sanar a otros jugadores"
L["HealcircleShow"] = "Muestra el circulo de sanación"
L["HealcircleShowDesc"] = "Muestra el circulo de sanación en el HUD"
L["Hide player arrow"] = "Oculta el indicador del jugador"
L["HudSize"] = "Tamaño del HUD"
L["HudSizeDesc"] = "Establece el tamaño del HUD a un porcentaje de la altura de pantalla."
L["HudSymbolScale"] = "Escala de símbolos en HUD"
L["HudSymbolScaleDesc"] = "Escala de los símbolos en el HUD"
L["KeyBindBackground"] = "Alterna el fondo del minimapa de FarmHud"
L["KeyBindBackgroundDesc"] = "Establece una tecla rápida para mostrar el fondo del minimapa"
L["KeyBindMouse"] = "Alterna ayuda emergente de FarmHud (No se puede hacer clic atreves de Hud)"
L["KeyBindMouseDesc"] = "Establece una tecla rápida para permitir ayudar emergentes sobre el ratón para los puntos de interés (como minerales, hierbas o misiones). O para hacer clic en el HUD y enviar un ping (sonido) a tu grupo o banda."
L["KeyBindToggle"] = "Alterna la visualización de FarmHud"
L["KeyBindToggleDesc"] = "Establece una tecla rápida para mostrar FarmHud."
L["KnownProblematicAddOnDetected"] = "ADVERTENCIA: Estas usando un accesorio que dificulta la cooperación con FarmHud. Posible solución: Deberías intentar ocultar los elementos problemáticos. Desactiva \\\"Muestra Elementos\\\" en las opciones de FarmHud."
L["MinimapIcon"] = "Icono del minimapa"
L["MinimapIconDesc"] = "Muestra el icono en el minimapa"
L["MouseOn"] = "MOUSE ACTIVO"
L["MouseOver"] = "Opciones de sobre el cursor"
L["MouseOverInfoColorDesc"] = "Ajusta el color para el texto 'MOUSE ACTIVO' en el HUD"
L["MouseOverOnHold"] = "Sobre el cursor al presionar la tecla modificadora."
L["MouseOverOnHoldDesc"] = "Esta opción habilita el modo: sobre el cursor, mientras tienes pulsada una tecla modificadora como Alt"
L["N"] = "N"
L["NE"] = "NE"
L["NW"] = "NO"
L["OnScreen"] = "Botones EnPantalla"
L["OnScreenAlphaDesc"] = "Ajusta la transparencia de los botones EnPantalla"
L["OnScreenBottom"] = "Botones EnPantalla en la parte inferior"
L["OnScreenBottomDesc"] = "Muestra los botones EnPantalla en la parte inferior desde el centro del HUD"
L["OnScreenShow"] = "Muestra los botones EnPantalla"
L["OnScreenShowDesc"] = "Muestra los botones EnPantalla (\"mouse activo\"-modo, botón de cerrar el hud y mas)"
L["PlaceholderDesc"] = "El marcador de posición es un elemento para mantener visibles los elementos de tu minimapa en su lugar mientras Farmhud este activo."
L["PlayerDot"] = "Jugador, flecha o punto"
L["PlayerDotDesc"] = "Cambio el estilo del jugador flecha/punto cuando FarmHud este abierto."
L["PleaseReportThisMessage"] = "Por favor envía este mensaje a curseforge en el aparto de conflictos usando una captura de pantalla o texto."
L["QuestArrow"] = "Flecha de misión"
L["QuestArrowDesc"] = "Muestra la flecha de misión cuando el HUD este abierto"
L["QuestArrowHide"] = "Oculta la flecha de misión cuando el HUD este abierto"
L["QuestArrowInfoMsg"] = "Muestra información del mensaje"
L["QuestArrowInfoMsgDesc"] = "Muestra información del mensaje en la ventana del chat general"
L["QuestArrowInfoMsgDisabled"] = "Rastreo de misiones desactivado"
L["QuestArrowInfoMsgRestored"] = "Rastreo de misiones activado"
L["RangeCircles"] = "Círculos referenciales"
L["ResetColor"] = "Restaura el color"
L["Rotation"] = "Rotación"
L["RotationDesc"] = "Habilita de manera forzada la rotación del minimapa en el modo HUD"
L["S"] = "S"
L["SE"] = "SE"
L["ShowPlaceholder"] = "Muestra elementos"
L["ShowPlaceholderBg"] = "Muestra el fondo"
L["ShowPlaceholderBgDesc"] = "Muestra un fondo negro en lugar del minimapa cuando FarmHud esta activo."
L["ShowPlaceholderDesc"] = "Los elementos del minimapa permanecen visibles incluso cuando FarmHud esta activo."
L["SupportBlizzard"] = "Blizzard ha realizado algunos cambios que hacen inútil ofrecer soporte adicional de accesorios individuales o librerías"
L["SupportHereBeDragon"] = "Tomtom y HandyNotes estan soportados a través de la librería HereBeDragons pero HandyNotes tiene un problema con alterna FarmHud. Todos los iconos alrededor de tu posición desaparecerán al alternar FarmHud. Basta con moverse un poco o volar alrededor para que se muetren nuevamente."
L["SupportOptions"] = "Opciones de soporte"
L["SW"] = "SO"
L["TextScale"] = "Escala del texto"
L["TextScaleDesc"] = "La escala del texto en HUD para los puntos cardinales, sobre el cursor y coordenadas."
L["Time"] = "Hora Servidor/Local"
L["TimeBottom"] = "La hora en la parte inferior"
L["TimeBottomDesc"] = "Muestra la hora en la parte inferior"
L["TimeColorDesc"] = "Ajusta el color para la hora"
L["TimeColorResetDesc"] = "Restaura el color para la hora"
L["TimeLocal"] = "Hora local"
L["TimeLocalDesc"] = "Muestra la hora local"
L["TimeServer"] = "Hora del servidor"
L["TimeServerDesc"] = "Muestra la hora del servidor, si no la hora local."
L["TimeShow"] = "Muestra la hora"
L["TimeShowDesc"] = "Muestra la hora del servidor o la hora local en el HUD"
L["TrackingOptions"] = "Opciones de rastreo"
L["TrackingOptionsDesc"] = "Alterna los iconos de rastreo cuando FarmHud este abierto.|n|n\"Como el minimap\" esto significa que tus ajustes/cambios sobre el botón del minimapa serán usados cuando FarmHud este abierto."
L["TrackingOptionsLikeMinimap"] = "Como el minimapa"
L["W"] = "O"
L["White player dot"] = "Jugador, punto blanco"

elseif LOCALE_frFR then
L["AddOnLoaded"] = "AddOn chargé..."
L["AddOnLoadedDesc"] = "Afficher le message 'AddOn chargé...' lors de la connexion"
L["AnotherAddOnsHijackedFunc"] = "Attention : Un autre addon a détourné certaines fonctions essentielles. Voir la liste suivante :"
L["BgTransparency"] = "Transparence de fond"
L["Black player dot"] = "Point de joueur noir"
L["Blizzards player arrow"] = "Flèche du joueur Blizzard"
L["Blizzards player arrow (smaller)"] = "Flèche du joueur Blizzard (plus petite)"
L["CardinalPoints"] = "Points cardinaux"
L["CardinalPointsColorDesc"] = "Régler la couleur des points cardinaux (%s)"
L["CardinalPointsColorResetDesc"] = "Réinitialiser la couleur des points cardinaux (%s)"
L["CardinalPointsGroup1"] = "N, O, S, E"
L["CardinalPointsGroup2"] = "NO, NE, SO, SE"
L["CardinalPointsShow"] = "Afficher les points cardinaux"
L["CardinalPointsShowDesc"] = "Afficher les points cardinaux sur le HUD"
L["ChangeRadius"] = "Distance depuis le centre"
L["ChangeRadiusDesc"] = "Modifier la distance depuis le centre par rapport au HUD"
L["Coords"] = "Coordonnées"
L["CoordsBottom"] = "Coordonnées en bas"
L["CoordsBottomDesc"] = "Afficher les coordonnées du joueur en bas"
L["CoordsColorDesc"] = "Modifier la couleur des coordonnées"
L["CoordsColorResetDesc"] = "Réinitialiser la couleur des coordonnées"
L["CoordsShow"] = "Afficher les coordonnées"
L["CoordsShowDesc"] = "Afficher les coordonnées sur le HUD"
L["DataBrokerOptions"] = "pour ouvrir les options FarmHud"
L["DataBrokerToggle"] = "pour activer FarmHud"
L["DebugOptInfo"] = "Cette section contient des options pour aider à suivre les problèmes avec d’autres addons."
L["E"] = "E"
L["N"] = "N"
L["NE"] = "NE"
L["NW"] = "NO"
L["S"] = "S"
L["SE"] = "SE"
L["SW"] = "SO"
L["W"] = "O"
L["White player dot"] = "Point de joueur blanc"

elseif LOCALE_itIT then
L["AddOnLoaded"] = "AddOn caricato..."
L["BgTransparency"] = "Trasparenza dello sfondo"
L["CardinalPoints"] = "Punti cardinali"
L["CardinalPointsColorDesc"] = "Regola i colori dei punti cardinali (%s)"
L["CardinalPointsColorResetDesc"] = "Ripristina i colori dei punti cardinali"
L["CardinalPointsGroup1"] = "N, O, S, E"
L["CardinalPointsGroup2"] = "NO, NE, SO, SE"
L["CardinalPointsShow"] = "Mostra i punti cardinali"
L["CardinalPointsShowDesc"] = "Visualizza i punti cardinali su HUD"
L["ChangeRadius"] = "Distanza dal centro"
L["ChangeRadiusDesc"] = "Cambia la distanza dal centro dall' HUD"
L["Coords"] = "Coordinate"
L["CoordsBottom"] = "Coordinate sul fondo"
L["CoordsBottomDesc"] = "Visualizza le coordinate del giocatore sul fondo"
L["CoordsColorDesc"] = "Regola il colore delle coordinate"
L["CoordsColorResetDesc"] = "Ripristina il colore delle coordinate"
L["CoordsShow"] = "Mostra le coordinate"
L["CoordsShowDesc"] = "Mostra le coordinate sull'HUD"
L["DataBrokerOptions"] = "per aprire le opzioni di FarmHud"
L["DataBrokerToggle"] = "per attivare / disattivare FarmHud"
L["E"] = "E"
L["ExtraAddOnLoaded"] = "L'AddOn aggiuntivo '%s' è abilitato!"
L["ExtraAddOnNotLoaded"] = "L'AddOn aggiuntivo '%s' deve essere abilitato per questa opzione!"
L["GatherCircle"] = "Cerchio di raccolta"
L["GatherCircleColorDesc"] = "Regola il colore del cerchio di raccolta"
L["GatherCircleDesc"] = "Il cerchio di raccolta è una linea di aiuto visivo, che consiste nel mostrare la distanza attorno alla tua posizione di tutti i punti di interesse (cassetta della posta, minerali, erbe) che appariranno sulla minimappa e su FarmHud"
L["GatherCircleShow"] = "Mostra cerchio di raccolta"
L["GatherCircleShowDesc"] = "Mostra il cerchio di raccolta sull'HUD"
L["HudSize"] = "Dimensioni dell'HUD"
L["HudSizeDesc"] = "Imposta la dimenzione dell'HUD su una percentuale dell'altezza dello schermo"
L["HudSymbolScale"] = "simbolo di regolazione dell'HUD"
L["HudSymbolScaleDesc"] = "Regolazione dei simboli sull HUD"
L["KeyBindBackground"] = "Attiva / disattiva lo sfondo della minimappa di FarmHud"
L["KeyBindBackgroundDesc"] = "Imposta la combinazione dei tasti per mostrare lo sfondo della minimappa"
L["KeyBindMouse"] = "Attiva / disattiva i suggerimenti di FarmHud (impossibile fare clic su Hud)"
L["KeyBindMouseDesc"] = "Imposta la combinazione di tasti in modo da consentire la visualizzazione delle descrizioni dei punti di interesse (come minerali, erbe o quest) al passaggio del mouse. O per fare clic sull'hud per inviare un ping al tuo gruppo o raid."
L["KeyBindToggle"] = "Attiva / disattiva il display di FarmHud"
L["KeyBindToggleDesc"] = "Imposta la combinazione di tasti per mostrare FarmHud"
L["MinimapIcon"] = "Icona della Minimappa"
L["MinimapIconDesc"] = "Mostra l'icona della minimappa"
L["MouseOn"] = "MOUSE  ON"
L["MouseOver"] = "Opzioni mouse-over"
L["MouseOverInfoColorDesc"] = "Regolare il colore per il testo 'MOUSE ON' sull'HUD"
L["MouseOverOnHold"] = "Mouse-over tenendo premuto un tasto modificatore"
L["MouseOverOnHoldDesc"] = "Questa è un'opzione per abilitare la modalità mouse-over quando tieni premuto un tasto modificatore come Alt"
L["N"] = "N "
L["NE"] = "NE"
L["NW"] = "NO"
L["OnScreen"] = "Pulsante OnScreen"
L["OnScreenAlphaDesc"] = "Imposta la trasparenza del pulsante OnScreen"
L["OnScreenBottom"] = "Pulsante OnScreen sulla parte inferiore"
L["OnScreenBottomDesc"] = "Visualizza il pulsante OnScreen  sulla parte inferiore dell'HUD"
L["OnScreenShow"] = "Mostra il pulsante OnScreen"
L["OnScreenShowDesc"] = "Mostra il pulsante OnScreen (modalità \"mouse on\", pulsante di chiusura dell'HUD ed altri)"
L["PlaceholderDesc"] = "Il segnaposto è un elemento per mantenere in posizione tutti gli elementi visibili della minimappa mentre Farmhud è attivo."
L["PlayerDot"] = "Freccia o punto giocatore"
L["PlayerDotDesc"] = "Cambia lo stile della tua freccia / del punto giocatore quando FarmHud è attivo"
L["QuestArrow"] = "freccia della missione"
L["QuestArrowDesc"] = "Visualizza la freccia della missione quando l'HUD è attiva"
L["QuestArrowInfoMsg"] = "Mostra il messaggio delle informazioni"
L["QuestArrowInfoMsgDesc"] = "Visualizza il messaggio delle informazioni nella finestra della chat generale"
L["QuestArrowInfoMsgDisabled"] = "Puntatore delle missioni disabilitato"
L["QuestArrowInfoMsgRestored"] = "Puntatore delle missioni riabilitato"
L["ResetColor"] = "reimposta colori"
L["Rotation"] = "Rotazione"
L["RotationDesc"] = "Forza l'attivazione della rotazione della minimappa nella modalità HUD"
L["S"] = "S"
L["SE"] = "SE"
L["ShowPlaceholder"] = "Mostra elementi"
L["ShowPlaceholderBg"] = "Mostra lo sfondo"
L["ShowPlaceholderBgDesc"] = "Visualizza uno sfondo nero invece che la minimappa quando FarmHud è attivo"
L["ShowPlaceholderDesc"] = "Gli elementi sulla tua minimappa rimangono visibili anche quando FarmHud è attivo."
L["SupportBlizzard"] = "La Blizzard ha apportato alcuni cambiamenti che hanno reso inutile offrire supporto addizionale per singoli AddOn o librerie"
L["SupportHereBeDragon"] = "TomTom e HandyNotes sono supportati attraverso la libreria HereBeDregon ma HandyNotes ha problemi con l'attivazione  / disattivazione dell'HUD. Tutte le icone attorno alla tua posizione spariranno attivando / disattivando FarmHud, ma dopo aver camminato / volato un po' in giro dovrebbero riapparire."
L["SupportOptions"] = "Opzioni di Supporto"
L["SW"] = "SO"
L["TextScale"] = "Ridimensiona testo"
L["TextScaleDesc"] = "Ridimensiona il testo per i punti cardinali, mouse-on e coordinate sull'HUD"
L["Time"] = "Server/Tempo Locale"
L["TimeBottom"] = "Tempo in basso"
L["TimeBottomDesc"] = "Visualizza il tempo in basso"
L["TimeColorDesc"] = "Regola il colore del tempo"
L["TimeColorResetDesc"] = "Reimposta il colore del tempo"
L["TimeServer"] = "Tempo del server "
L["TimeServerDesc"] = "Visualizza il tempo del server anzichè quello locale"
L["TimeShow"] = "Visualizza tempo"
L["TimeShowDesc"] = "Visualizza il tempo locale o del server in modalità HUD"
L["TrackingOptions"] = "Opzioni di puntamento"
L["TrackingOptionsDesc"] = "Attiva / disattiva l'icona di puntamento quando FarmHud è aperto.|n|n\"Come minimappa\" intende le tue impostazioni o i tuoi cambiamenti sul bottone di puntamento della minimappa  che verranno utilizzati aprendo FarmHud"
L["TrackingOptionsLikeMinimap"] = "Come minimappa"
L["W"] = "O"

elseif LOCALE_koKR then
L["AnotherAddOnsHijackedFunc"] = "경고: 다른 애드온이 몇 가지 필수 기능을 장악했습니다. 다음 목록을 참조하세요:"
L["BgTransparency"] = "배경 투명도"
L["Black player dot"] = "검은색 플레이어 점"
L["Blizzards player arrow"] = "블리자드 플레이어 화살표"
L["Blizzards player arrow (smaller)"] = "블리자드 플레이어 화살표 (작은)"
L["CardinalPoints"] = "기본 방위"
L["CardinalPointsColorDesc"] = "기본 방위(%s)의 색상을 조정합니다."
L["CardinalPointsColorResetDesc"] = "기본 방위(%s)의 색상을 초기화합니다."
L["CardinalPointsGroup1"] = "북, 서, 남, 동"
L["CardinalPointsGroup2"] = "북서, 북동, 남서, 남동"
L["CardinalPointsShow"] = "기본 방위 표시"
L["CardinalPointsShowDesc"] = "HUD에 기본 방위를 표시합니다."
L["ChangeRadius"] = "반지름"
L["ChangeRadiusDesc"] = "HUD의 반지름을 바꿉니다."
L["Coords"] = "좌표"
L["CoordsBottom"] = "하단에 좌표"
L["CoordsBottomDesc"] = "하단에 플레이어 좌표를 표시합니다."
L["CoordsColorDesc"] = "좌표의 색상을 조정합니다."
L["CoordsColorResetDesc"] = "좌표의 색상을 초기화합니다."
L["CoordsShow"] = "좌표 표시"
L["CoordsShowDesc"] = "HUD에 플레이어 좌표를 표시합니다."
L["DataBrokerOptions"] = "- FarmHud 옵션 열기"
L["DataBrokerToggle"] = "- FarmHud 켜고 끄기"
L["DebugOptFrames"] = "원치 않는 요소 출력"
L["DebugOptFramesDesc"] = "FarmHud가 켜진 경우 미니맵에 고정된 원치 않는 요소 목록을 출력합니다."
L["DebugOptInfo"] = "여기는 다른 애드온의 문제를 추적하는 데 도움이 되는 옵션을 포함합니다."
L["E"] = "동"
L["ExtraAddOnLoaded"] = "추가 애드온 '%s'|1이;가; 활성화되었습니다!"
L["ExtraAddOnNotLoaded"] = "이 옵션을 위해 추가 애드온 '%s'|1을;를; 활성화해야 합니다!"
L["GatherCircle"] = "채집 원"
L["GatherCircleColorDesc"] = "채집 원의 색상을 조정합니다."
L["GatherCircleDesc"] = "채집 원은 눈에 보이는 도움선입니다. 미니맵과 FarmHud에 나타나는 모든 관심 지점(우편함, 광석, 약초)에서 당신 위치 주변의 거리를 나타냅니다."
L["GatherCircleShow"] = "채집 원 표시"
L["GatherCircleShowDesc"] = "HUD에 채집 원을 표시합니다."
L["Golden player dot"] = "금색 플레이어 점"
L["HealCircle"] = "치유 범위 원"
L["HealcircleColorDesc"] = "치유 범위 원의 색상을 조정합니다."
L["HealcircleDesc"] = "치유 범위 원은 눈에 보이는 도움선입니다. 다른 플레이어를 치유할 수 있는 위치까지의 거리를 나타냅니다."
L["HealcircleShow"] = "치유 범위 원 표시"
L["HealcircleShowDesc"] = "HUD에 치유 범위 원을 표시합니다."
L["Hide player arrow"] = "플레이어 화살표 숨기기"
L["HudSize"] = "HUD 크기"
L["HudSizeDesc"] = "HUD 크기를 화면 높이의 백분율로 설정합니다."
L["HudSymbolScale"] = "HUD 기호 크기 비율"
L["HudSymbolScaleDesc"] = "HUD 위 기호의 크기 비율입니다."
L["KeyBindBackground"] = "FarmHud의 미니맵 배경 켜고 끄기"
L["KeyBindBackgroundDesc"] = "미니맵 배경을 표시하는 단축키를 설정합니다."
L["KeyBindMouse"] = "FarmHud의 툴팁을 켜고 끄기 (HUD를 통과해 클릭 불가)"
L["KeyBindMouseDesc"] = "(광석, 약초 또는 퀘스트 제공자 같은) 관심 지점 노드의 툴팁을 마우스 오버할 수 있거나 파티나 공격대에 핑을 보내기 위해 HUD를 클릭하기 위한 단축키를 설정합니다."
L["KeyBindToggle"] = "FarmHud 표시 켜고 끄기"
L["KeyBindToggleDesc"] = "FarmHud를 표시하는 단축키를 설정합니다."
L["KnownProblematicAddOnDetected"] = "경고: FarmHud와의 원활한 협력을 어렵게 하는 애드온을 사용하고 있습니다. 가능한 해결책: 방해 요소를 숨기려 할 수 있습니다. FarmHud 옵션에서 \\\"요소 표시\\\"를 끄세요."
L["MinimapIcon"] = "미니맵 아이콘"
L["MinimapIconDesc"] = "미니맵 아이콘을 표시합니다."
L["MouseOn"] = "마우스 온"
L["MouseOver"] = "마우스 오버 옵션"
L["MouseOverInfoColorDesc"] = "HUD의 '마우스 온' 글자 색상을 조정합니다."
L["MouseOverOnHold"] = "누름 시 마우스 오버 보조 키"
L["MouseOverOnHoldDesc"] = "이는 Alt와 같은 보조 키를 누르고 있는 동안 마우스 오버 모드를 켜는 옵션입니다."
L["N"] = "북"
L["NE"] = "북동"
L["NW"] = "북서"
L["OnScreen"] = "화면 위 버튼"
L["OnScreenAlphaDesc"] = "화면 위 버튼의 투명도를 조정합니다."
L["OnScreenBottom"] = "하단에 화면 위 버튼"
L["OnScreenBottomDesc"] = "HUD 하단에 화면 위 버튼을 표시합니다."
L["OnScreenShow"] = "화면 위 버튼 표시"
L["OnScreenShowDesc"] = "화면 위 버튼(\"마우스 온\" 모드, HUD 닫기 버튼 등)을 표시합니다."
L["PlaceholderDesc"] = "Placeholder는 Farmhud가 활성화되어 있는 동안 미니맵에 보이는 모든 요소를 제자리에 고정시키는 요소입니다."
L["PlayerDot"] = "플레이어 화살표 또는 점"
L["PlayerDotDesc"] = "열린 FarmHud에서 플레이어 점/화살표 모양을 바꿉니다."
L["PleaseReportThisMessage"] = "스크린샷 또는 글로 CurseForge Issues에 이 메시지를 보고해 주세요."
L["QuestArrow"] = "퀘스트 화살표"
L["QuestArrowDesc"] = "열린 HUD에 퀘스트 화살표를 표시합니다."
L["QuestArrowHide"] = "열린 HUD에서 퀘스트 화살표 숨기기"
L["QuestArrowInfoMsg"] = "정보 메시지 표시"
L["QuestArrowInfoMsgDesc"] = "일반 대화창에 정보 메시지를 표시합니다."
L["RangeCircles"] = "범위 원"
L["ResetColor"] = "색상 초기화"
L["Rotation"] = "회전"
L["RotationDesc"] = "HUD 모드에서 미니맵 회전을 강제로 실행합니다."
L["S"] = "남"
L["SE"] = "남동"
L["ShowPlaceholder"] = "요소 표시"
L["ShowPlaceholderBg"] = "배경 표시"
L["ShowPlaceholderBgDesc"] = "FarmHud가 활성화되어 있는 동안 미니맵 대신 검은색 배경을 표시합니다."
L["ShowPlaceholderDesc"] = "미니맵 요소가 FarmHud가 활성화되어 있어도 계속 표시됩니다."
L["SupportBlizzard"] = "Blizzard가 단일 애드온 또는 라이브러리에 선택적인 지원을 제공하는 게 쓸모없게 약간 변경했습니다."
L["SupportHereBeDragon"] = "TomTom과 HandyNotes는 HereBeDragon 라이브러리를 통해 지원되지만 HandyNotes는 Hud 켜고 끄기에 문제가 있습니다. 위치 주변 모든 아이콘은 FarmHud를 켜면 사라집니다. 그러나 약간의 주변 걷기/비행을 통해 다시 표시될 겁니다."
L["SupportOptions"] = "지원 옵션"
L["SW"] = "남서"
L["TextScale"] = "텍스트 크기 비율"
L["TextScaleDesc"] = "HUD 상 기본 방위, 마우스 온 및 좌표 텍스트의 크기 비율입니다."
L["Time"] = "서버/시스템 시간"
L["TimeBottom"] = "하단에 시간"
L["TimeBottomDesc"] = "하단에 시간을 표시합니다."
L["TimeColorDesc"] = "시간의 색상을 조정합니다."
L["TimeColorResetDesc"] = "시간의 색상을 초기화합니다."
L["TimeLocal"] = "시스템 시간"
L["TimeLocalDesc"] = "시스템 시간을 표시합니다."
L["TimeServer"] = "서버 시간"
L["TimeServerDesc"] = "서버 시간 그렇지 않으면 시스템 시간을 표시합니다."
L["TimeShow"] = "시간 표시"
L["TimeShowDesc"] = "HUD 모드에서 서버 또는 시스템 시간을 표시합니다."
L["TrackingOptions"] = "추적 옵션"
L["TrackingOptionsDesc"] = "열린 FarmHud에서 추적 아이콘을 켜고 끕니다.|n|n\"미니맵처럼\"은 미니맵 추적 버튼에 대한 설정/변경 사항이 열린 FarmHud에서 사용됨을 뜻합니다."
L["TrackingOptionsLikeMinimap"] = "미니맵처럼"
L["W"] = "서"
L["White player dot"] = "흰색 플레이어 점"

elseif LOCALE_ptBR or LOCALE_ptPT then

elseif LOCALE_ruRU then

elseif LOCALE_zhCN then
L["AddOnLoaded"] = "插件已加载......"
L["BgTransparency"] = "背景透明度"
L["CardinalPoints"] = "方位"
L["CardinalPointsColorDesc"] = "调整方位的颜色(%s)"
L["CardinalPointsColorResetDesc"] = "重置方位的颜色(%s)"
L["CardinalPointsShow"] = "显示方位"
L["CardinalPointsShowDesc"] = "在HUD中显示方位"
L["E"] = "东"
L["HudSize"] = "HUD尺寸"
L["N"] = "北"
L["NE"] = "东北"
L["NW"] = "西北"
L["S"] = "南"
L["SE"] = "东南"
L["SW"] = "西南"
L["W"] = "西"

elseif LOCALE_zhTW then
L["CoordsBottom"] = "底部座標"
L["DataBrokerToggle"] = "打開農人雷達"
L["E"] = "東"
L["KeyBindMouse"] = "開啟FarmHud的提示 (無法點選hud後面的東西)"
L["KeyBindToggle"] = "開啟FarmHud的顯示"
L["KeyBindToggleDesc"] = "射的快捷建來顯示FarmHud"
L["MinimapIcon"] = "小地圖圖示"
L["MouseOn"] = "滑鼠開啟"
L["N"] = "北"
L["NE"] = "東北"
L["NW"] = "西北"
L["S"] = "南"
L["SE"] = "東南"
L["SupportOptions"] = "支援選項"
L["SW"] = "西南"
L["W"] = "西"

end

BINDING_HEADER_FARMHUD = addon;
BINDING_NAME_TOGGLEFARMHUD = L.KeyBindToggle;
BINDING_NAME_TOGGLEFARMHUDMOUSE	= L.KeyBindMouse;
BINDING_NAME_TOGGLEFARMHUDBACKGROUND = L.KeyBindBackground;
