import os
import random
import string
import sys
import time
import uuid
from PyQt5.QtCore import Qt, QUrl
from PyQt5.QtGui import QIcon
from PyQt5 import uic
from PyQt5.QtWebEngineWidgets import QWebEngineView
from PyQt5.QtWidgets import QApplication, QMessageBox, QPushButton, QMainWindow, QAbstractItemView, QMenu
import requests
from PyQt5.QtWidgets import QTableWidgetItem
import threading

from bs4 import BeautifulSoup
import login
from host import HOST, LOCALHOST
import index


class Index():
    def __init__(self):
        # 从文件中加载UI定义
        self.ui = uic.loadUi("resource/index.ui")
        self.wei = ''
        # pushButton    SearchKeys
        self.ui.runautowork.clicked.connect(self.AutoUpdateWork)
        self.ui.runcai.clicked.connect(self.RunCaiJi)
        self.ui.runcai_2.clicked.connect(self.Daoru)
        self.ui.runwei.clicked.connect(self.RunWei)
        self.ui.addwei.clicked.connect(self.AddWei)
        self.ui.settitle.clicked.connect(self.SetTitle)
        self.ui.daochu.clicked.connect(self.DaoChuKeys)
        self.ui.bandserver.clicked.connect(self.bandserver)
        self.ui.searchkeys.clicked.connect(self.SearchKeys)
        self.ui.editpwd.clicked.connect(self.EditMyPwd)
        self.ui.adddaifabu.clicked.connect(self.AddDai)
        self.ui.updateautowork.clicked.connect(self.UpdateAutoWorks)
        self.ui.allweb_2.hide()
        # tab点击事件
        self.ui.tabWidget.currentChanged.connect(self.shuo)  #
        self.ui.yuncai.setContextMenuPolicy(Qt.CustomContextMenu)  ######允许右键产生子菜单
        self.ui.yuncai.customContextMenuRequested.connect(self.generateMenu)  ####右键菜单
        # 设置表格禁止编辑
        # self.ui.allweb_2.setEditTriggers(QAbstractItemView.NoEditTriggers)
        self.ui.yuncai.setEditTriggers(QAbstractItemView.NoEditTriggers)
        self.ui.tableWidget.setEditTriggers(QAbstractItemView.NoEditTriggers)
        self.ui.allweb_4.setEditTriggers(QAbstractItemView.NoEditTriggers)
        # 自动发布点击事件
        self.ui.comboBox.currentIndexChanged.connect(
            lambda: self.WrittingNotOfOther(self.ui.comboBox.currentText()))  # 点击下拉列表，触发对应事件

        self.ui.gengxin.clicked.connect(self.UpdateData)
        # 获取建站数量
        f = open('conf.conf', 'r')
        uid = f.read()
        self.uid = uid
        url = HOST + 'getuserwebnum/?uid=' + str(self.uid)
        res = requests.get(url=url)
        resObj = res.json()
        # 获取我创建的所有网站
        url2 = LOCALHOST + 'index/?uid=' + uid
        webdata = requests.get(url=url2).json()
        if resObj['status'] == 'OK':
            if int(resObj['nums']) > 0:
                # 已经有网站了
                self.ui.showfont.hide()
                self.ui.allweb.setRowCount(len(webdata['data']))
                self.ui.allweb.verticalHeader().setVisible(False)  # 隐藏自带序列
                # 插入数据
                num = 0
                xu = 1
                # 设置表格禁止编辑
                self.ui.allweb.setEditTriggers(QAbstractItemView.NoEditTriggers)
                self.ui.webman.setEditTriggers(QAbstractItemView.NoEditTriggers)
                for i in webdata['data']:
                    ju = QTableWidgetItem(str(xu).strip())
                    ju.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                    self.ui.allweb.setItem(num, 0, ju)

                    ju = QTableWidgetItem(str(i[0]).strip())
                    ju.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                    self.ui.allweb.setItem(num, 1, ju)
                    ju1 = QTableWidgetItem(str(i[1]).strip())
                    ju1.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                    self.ui.allweb.setItem(num, 2, ju1)
                    ju2 = QTableWidgetItem(str(i[2]).strip())
                    ju2.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                    self.ui.allweb.setItem(num, 3, ju2)
                    ju3 = QTableWidgetItem(str(i[3]).strip())
                    ju3.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                    self.ui.allweb.setItem(num, 4, ju3)
                    ju4 = QTableWidgetItem(str(i[4]).strip())
                    ju4.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                    self.ui.allweb.setItem(num, 5, ju4)
                    ju5 = QTableWidgetItem(str(i[5]).strip())
                    ju5.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                    self.ui.allweb.setItem(num, 6, ju5)
                    ju6 = QTableWidgetItem(str(i[6]).strip())
                    ju6.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                    self.ui.allweb.setItem(num, 7, ju6)
                    num = num + 1
                    xu = xu + 1
                row_count = self.ui.allweb.rowCount()
                self.ui.allweb.insertRow(row_count)
                self.ui.allweb.removeRow(row_count)
            else:
                self.ui.showfont.hide()
            self.ui.webman.verticalHeader().setVisible(False)  # 隐藏自带序列
            self.ui.webman.setRowCount(len(webdata['data']))
            # 插入数据
            num = 0
            xu = 1
            for i in webdata['data']:
                ju = QTableWidgetItem(str(xu).strip())
                ju.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                self.ui.webman.setItem(num, 0, ju)
                ju = QTableWidgetItem(str(i[0]).strip())
                ju.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                self.ui.webman.setItem(num, 1, ju)
                ju1 = QTableWidgetItem(str(i[1]).strip())
                ju1.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                self.ui.webman.setItem(num, 2, ju1)
                ju2 = QTableWidgetItem(str(i[2]).strip())
                ju2.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                self.ui.webman.setItem(num, 3, ju2)
                ju3 = QTableWidgetItem(str(i[3]).strip())
                ju3.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                self.ui.webman.setItem(num, 4, ju3)
                ju4 = QTableWidgetItem(str(i[4]).strip())
                ju4.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                self.ui.webman.setItem(num, 5, ju4)
                ju5 = QTableWidgetItem(str(i[5]).strip())
                ju5.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                self.ui.webman.setItem(num, 6, ju5)
                ju6 = QTableWidgetItem(str(i[6]).strip())
                ju6.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                self.ui.webman.setItem(num, 7, ju6)

                ju7 = QTableWidgetItem(str(i[7]).strip())
                ju7.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                self.ui.webman.setItem(num, 8, ju7)
                ju8 = QTableWidgetItem(str(i[8]).strip())
                ju8.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                self.ui.webman.setItem(num, 9, ju8)
                xu = xu + 1
                searchBtn = QPushButton("编辑")  # 新建一个按钮
                searchBtn.setDown(True)
                searchBtn.setStyleSheet("QPushButton{margin:3px};")
                searchBtn.clicked.connect(self.EditWeb)  # 绑定按钮点击事件
                self.ui.webman.setCellWidget(num, 10, searchBtn)  # 添加按钮到列表（0，2）

                searchBtn = QPushButton("更换模板")  # 新建一个按钮
                searchBtn.setDown(True)
                searchBtn.setStyleSheet("QPushButton{margin:3px};")
                searchBtn.clicked.connect(self.InstallTem)  # 绑定按钮点击事件
                self.ui.webman.setCellWidget(num, 11, searchBtn)  # 添加按钮到列表（0，2）
                num = num + 1
            row_count = self.ui.webman.rowCount()
            self.ui.webman.insertRow(row_count)
            self.ui.webman.removeRow(row_count)

        else:
            QMessageBox.information(self.ui, '提示', '系统错误')
        for i in webdata['data']:
            self.ui.comboBox.addItem(str(i[0]).strip())
        # self.ui.frame_6.hide()
        authurl = HOST + 'myallauth/'
        authres = requests.get(authurl).json()['data']
        # 我的账号数据获取

        # 用户中心查看权限
        url = HOST + 'myauth/?uid=' + str(self.uid)
        res = requests.get(url=url)
        resObj = res.json()
        self.ui.tableWidget.setRowCount(len(authres))
        # 插入数据
        num = 0
        for i in authres:
            ju = QTableWidgetItem(str(i[0]).strip())
            ju.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.tableWidget.setItem(num, 0, ju)
            ju1 = QTableWidgetItem(str(i[1]).strip())
            ju1.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.tableWidget.setItem(num, 1, ju1)
            ju2 = QTableWidgetItem(str(i[2]).strip())
            ju2.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.tableWidget.setItem(num, 2, ju2)
            ju3 = QTableWidgetItem(str(i[3]).strip())
            ju3.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.tableWidget.setItem(num, 3, ju3)
            ju4 = QTableWidgetItem(str(i[4]).strip())
            ju4.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.tableWidget.setItem(num, 4, ju4)
            ju5 = QTableWidgetItem(str(i[5]).strip())
            ju5.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.tableWidget.setItem(num, 5, ju5)
            ju6 = QTableWidgetItem(str(i[6]).strip())
            ju6.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.tableWidget.setItem(num, 6, ju6)
            ju7 = QTableWidgetItem(str(i[7]).strip())
            ju7.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.tableWidget.setItem(num, 7, ju7)
            ju7 = QTableWidgetItem(str(i[7]).strip())
            ju7.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.tableWidget.setItem(num, 7, ju7)
            ju8 = QTableWidgetItem(str(i[8]).strip())
            ju8.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.tableWidget.setItem(num, 8, ju8)
            ju9 = QTableWidgetItem(str(i[9]).strip())
            ju9.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.tableWidget.setItem(num, 9, ju9)
            ju10 = QTableWidgetItem(str(i[10]).strip())
            ju10.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.tableWidget.setItem(num, 10, ju10)
            ju11 = QTableWidgetItem(str(i[11]).strip())
            ju11.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.tableWidget.setItem(num, 11, ju11)
            num = num + 1
        row_count = self.ui.tableWidget.rowCount()
        self.ui.tableWidget.insertRow(row_count)
        self.ui.tableWidget.removeRow(row_count)

        getshengurl = HOST + 'getmys/?uid=' + uid
        shengres = requests.get(getshengurl).json()['data']
        if resObj['auth'] == '0':
            msg = '您的版本为免费版,剩余建站数量：' + str(shengres[0]) + '剩余长尾词查询数量:' + str(shengres[1]) + '剩余伪原创数量:' + str(
                shengres[2]) + '剩余关键词精准采集数量:' + str(shengres[3]) + '剩余自动发布数量:' + str(shengres[4])

            self.ui.textBrowser_2.append(msg)
        if resObj['auth'] == '1':
            msg = '您的版本为个人版,剩余建站数量：' + str(shengres[0]) + '剩余长尾词查询数量:' + str(shengres[1]) + '剩余伪原创数量:' + str(
                shengres[2]) + '剩余关键词精准采集数量:' + str(shengres[3]) + '剩余自动发布数量:' + str(shengres[4])

            self.ui.textBrowser_2.append(msg)
        if resObj['auth'] == '2':
            msg = '您的版本为专业版,剩余建站数量：' + str(shengres[0]) + '剩余长尾词查询数量:' + str(shengres[1]) + '剩余伪原创数量:' + str(
                shengres[2]) + '剩余关键词精准采集数量:' + str(shengres[3]) + '剩余自动发布数量:' + str(shengres[4])

            self.ui.textBrowser_2.append(msg)
        if resObj['auth'] == '3':
            msg = '您的版本为企业版,剩余建站数量：' + str(shengres[0]) + '剩余长尾词查询数量:' + str(shengres[1]) + '剩余伪原创数量:' + str(
                shengres[2]) + '剩余关键词精准采集数量:' + str(shengres[3]) + '剩余自动发布数量:' + str(shengres[4])

            self.ui.textBrowser_2.append(msg)
        if resObj['auth'] == '4':
            msg = '您的版本为定制版,剩余建站数量：' + str(shengres[0]) + '剩余长尾词查询数量:' + str(shengres[1]) + '剩余伪原创数量:' + str(
                shengres[2]) + '剩余关键词精准采集数量:' + str(shengres[3]) + '剩余自动发布数量:' + str(shengres[4])

            self.ui.textBrowser_2.append(msg)
        workurl = LOCALHOST + 'getmywork/'
        workres = requests.get(workurl).json()['data']
        self.ui.allweb_4.setRowCount(len(workres))
        num = 0
        for w in workres:
            ju = QTableWidgetItem(str(w[0]).strip())
            ju.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.allweb_4.setItem(num, 0, ju)
            ju1 = QTableWidgetItem(str(w[1]).strip())
            ju1.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.allweb_4.setItem(num, 1, ju1)
            ju2 = QTableWidgetItem(str(w[2]).strip())
            ju2.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.allweb_4.setItem(num, 2, ju2)
            ju3 = QTableWidgetItem(str(w[3]).strip())
            ju3.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.allweb_4.setItem(num, 3, ju3)
            ju4 = QTableWidgetItem(str(w[4]).strip())
            ju4.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.allweb_4.setItem(num, 4, ju4)
            ju5 = QTableWidgetItem(str(w[5]).strip())
            ju5.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.allweb_4.setItem(num, 5, ju5)

            searchBtn = QPushButton("停止")  # 新建一个按钮
            searchBtn.setDown(True)
            searchBtn.setStyleSheet("QPushButton{margin:3px};")
            searchBtn.clicked.connect(self.StopWork)  # 绑定按钮点击事件
            # 添加修改模板按钮
            self.ui.allweb_4.setCellWidget(num, 6, searchBtn)  # 添加按钮到列表（0，2）
            searchBtn1 = QPushButton("删除")  # 新建一个按钮
            searchBtn1.setDown(True)
            searchBtn1.setStyleSheet("QPushButton{margin:3px};")
            searchBtn1.clicked.connect(self.DelWork)  # 绑定按钮点击事件
            # 添加修改模板按钮
            self.ui.allweb_4.setCellWidget(num, 7, searchBtn1)  # 添加按钮到列表（0，2）
            num = num + 1
        row_count = self.ui.allweb_4.rowCount()
        self.ui.allweb_4.insertRow(row_count)
        self.ui.allweb_4.removeRow(row_count)

    def UpdateAutoWorks(self):
        workurl = LOCALHOST + 'getmywork/'
        workres = requests.get(workurl).json()['data']
        self.ui.allweb_4.setRowCount(len(workres))
        num = 0
        for w in workres:
            ju = QTableWidgetItem(str(w[0]).strip())
            ju.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.allweb_4.setItem(num, 0, ju)
            ju1 = QTableWidgetItem(str(w[1]).strip())
            ju1.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.allweb_4.setItem(num, 1, ju1)
            ju2 = QTableWidgetItem(str(w[2]).strip())
            ju2.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.allweb_4.setItem(num, 2, ju2)
            ju3 = QTableWidgetItem(str(w[3]).strip())
            ju3.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.allweb_4.setItem(num, 3, ju3)
            ju4 = QTableWidgetItem(str(w[4]).strip())
            ju4.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.allweb_4.setItem(num, 4, ju4)
            ju5 = QTableWidgetItem(str(w[5]).strip())
            ju5.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.allweb_4.setItem(num, 5, ju5)

            searchBtn = QPushButton("停止")  # 新建一个按钮
            searchBtn.setDown(True)
            searchBtn.setStyleSheet("QPushButton{margin:3px};")
            searchBtn.clicked.connect(self.StopWork)  # 绑定按钮点击事件
            # 添加修改模板按钮
            self.ui.allweb_4.setCellWidget(num, 6, searchBtn)  # 添加按钮到列表（0，2）
            searchBtn1 = QPushButton("删除")  # 新建一个按钮
            searchBtn1.setDown(True)
            searchBtn1.setStyleSheet("QPushButton{margin:3px};")
            searchBtn1.clicked.connect(self.DelWork)  # 绑定按钮点击事件
            # 添加修改模板按钮
            self.ui.allweb_4.setCellWidget(num, 7, searchBtn1)  # 添加按钮到列表（0，2）
            num = num + 1
        row_count = self.ui.allweb_4.rowCount()
        self.ui.allweb_4.insertRow(row_count)
        self.ui.allweb_4.removeRow(row_count)

    def DelWork(self):
        hang = int(self.ui.allweb_4.currentIndex().row()) + 1
        stupurl = LOCALHOST + 'delwork/?wid=' + str(hang)
        sres = requests.get(url=stupurl).json()
        if sres['status'] == 'OK':
            QMessageBox.information(self.ui, '提示', '任务删除成功')
            workurl = LOCALHOST + 'getmywork/'
            workres = requests.get(workurl).json()['data']
            self.ui.allweb_4.setRowCount(len(workres))
            num = 0
            for w in workres:
                ju = QTableWidgetItem(str(w[0]).strip())
                ju.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                self.ui.allweb_4.setItem(num, 0, ju)
                ju1 = QTableWidgetItem(str(w[1]).strip())
                ju1.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                self.ui.allweb_4.setItem(num, 1, ju1)
                ju2 = QTableWidgetItem(str(w[2]).strip())
                ju2.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                self.ui.allweb_4.setItem(num, 2, ju2)
                ju3 = QTableWidgetItem(str(w[3]).strip())
                ju3.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                self.ui.allweb_4.setItem(num, 3, ju3)
                ju4 = QTableWidgetItem(str(w[4]).strip())
                ju4.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                self.ui.allweb_4.setItem(num, 4, ju4)
                ju5 = QTableWidgetItem(str(w[5]).strip())
                ju5.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                self.ui.allweb_4.setItem(num, 5, ju5)

                searchBtn = QPushButton("停止")  # 新建一个按钮
                searchBtn.setDown(True)
                searchBtn.setStyleSheet("QPushButton{margin:3px};")
                searchBtn.clicked.connect(self.StopWork)  # 绑定按钮点击事件
                # 添加修改模板按钮
                self.ui.allweb_4.setCellWidget(num, 6, searchBtn)  # 添加按钮到列表（0，2）
                num = num + 1
            row_count = self.ui.allweb_4.rowCount()
            self.ui.allweb_4.insertRow(row_count)
            self.ui.allweb_4.removeRow(row_count)
            return

    # 添加到待发布
    def AddDai(self):
        f = open('keys.txt', 'r')
        uid = f.read().split(':')[1]
        url = LOCALHOST + 'adddai/?title=' + str(uid)
        res = requests.get(url=url).json()['status']
        tid = open('keys.txt', 'r', encoding='utf-8').read().split(':')[1]
        if res == 'ok':
            url = LOCALHOST + 'adddai/'
            data = {
                'title': uid,
                'con': self.weilist,
                'tid': tid
            }
            res = requests.post(url=url, data=data)
            QMessageBox.information(self.ui, '提示', '已添加到发布库')
        else:
            QMessageBox.information(self.ui, '提示', '请先设置标题')
            return

    # 自动发布任务

    def isfree(self):
        f = open('conf.conf', 'r')
        uid = f.read()
        url = HOST + 'isfree/?uid=' + str(uid)
        res = requests.get(url).json()
        if res['data'] == 'yes':
            QMessageBox.information(self.ui, '提示', '抱歉，您是免费用户，请升级会员！')
            return 'yes'
        else:
            return 'no'

    # 判断是否生成标题
    def istitle(self):
        pass

    def Daoru(self):
        res = self.isfree()
        if res == 'yes':
            pass
        else:
            QMessageBox.information(self.ui, '提示', '导入成功')

    def StopWork(self):
        hang = int(self.ui.allweb_4.currentIndex().row()) + 1
        stupurl = LOCALHOST + 'stopwork/?wid=' + str(hang)
        sres = requests.get(url=stupurl).json()
        if sres['status'] == 'OK':
            QMessageBox.information(self.ui, '提示', '任务停止成功')
            workurl = LOCALHOST + 'getmywork/'
            workres = requests.get(workurl).json()['data']
            self.ui.allweb_4.setRowCount(len(workres))
            num = 0
            for w in workres:
                ju = QTableWidgetItem(str(w[0]).strip())
                ju.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                self.ui.allweb_4.setItem(num, 0, ju)
                ju1 = QTableWidgetItem(str(w[1]).strip())
                ju1.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                self.ui.allweb_4.setItem(num, 1, ju1)
                ju2 = QTableWidgetItem(str(w[2]).strip())
                ju2.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                self.ui.allweb_4.setItem(num, 2, ju2)
                ju3 = QTableWidgetItem(str(w[3]).strip())
                ju3.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                self.ui.allweb_4.setItem(num, 3, ju3)
                ju4 = QTableWidgetItem(str(w[4]).strip())
                ju4.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                self.ui.allweb_4.setItem(num, 4, ju4)
                ju5 = QTableWidgetItem(str(w[5]).strip())
                ju5.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                self.ui.allweb_4.setItem(num, 5, ju5)

                searchBtn = QPushButton("停止")  # 新建一个按钮
                searchBtn.setDown(True)
                searchBtn.setStyleSheet("QPushButton{margin:3px};")
                searchBtn.clicked.connect(self.StopWork)  # 绑定按钮点击事件
                # 添加修改模板按钮
                self.ui.allweb_4.setCellWidget(num, 6, searchBtn)  # 添加按钮到列表（0，2）
                num = num + 1
            row_count = self.ui.allweb_4.rowCount()
            self.ui.allweb_4.insertRow(row_count)
            self.ui.allweb_4.removeRow(row_count)
            return

    def UpdateData(self):
        f = open('conf.conf', 'r')
        uid = f.read()
        self.uid = uid
        url = HOST + 'getuserwebnum/?uid=' + str(self.uid)
        res = requests.get(url=url)
        resObj = res.json()
        # 获取我创建的所有网站
        url2 = LOCALHOST + 'index/?uid='+uid
        webdata = requests.get(url=url2).json()
        if resObj['status'] == 'OK':
            if int(resObj['nums']) > 0:
                # 已经有网站了
                self.ui.showfont.hide()
                self.ui.allweb.setRowCount(len(webdata['data']))
                # 插入数据
                num = 0
                for i in webdata['data']:
                    ju = QTableWidgetItem(str(i[0]).strip())
                    ju.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                    self.ui.allweb.setItem(num, 0, ju)
                    ju1 = QTableWidgetItem(str(i[1]).strip())
                    ju1.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                    self.ui.allweb.setItem(num, 1, ju1)
                    ju2 = QTableWidgetItem(str(i[2]).strip())
                    ju2.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                    self.ui.allweb.setItem(num, 2, ju2)
                    ju3 = QTableWidgetItem(str(i[3]).strip())
                    ju3.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                    self.ui.allweb.setItem(num, 3, ju3)
                    ju4 = QTableWidgetItem(str(i[4]).strip())
                    ju4.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                    self.ui.allweb.setItem(num, 4, ju4)
                    ju5 = QTableWidgetItem(str(i[5]).strip())
                    ju5.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                    self.ui.allweb.setItem(num, 5, ju5)
                    ju6 = QTableWidgetItem(str(i[6]).strip())
                    ju6.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                    self.ui.allweb.setItem(num, 6, ju6)
                    num = num + 1
                row_count = self.ui.allweb.rowCount()
                self.ui.allweb.insertRow(row_count)
                self.ui.allweb.removeRow(row_count)
                self.ui.webman.setRowCount(0)
                self.ui.webman.clearContents()
                self.ui.webman.setRowCount(len(webdata['data']))
                # 插入数据
                num = 0
                for i in webdata['data']:
                    ju = QTableWidgetItem(str(i[0]).strip())
                    ju.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                    self.ui.webman.setItem(num, 0, ju)
                    ju1 = QTableWidgetItem(str(i[1]).strip())
                    ju1.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                    self.ui.webman.setItem(num, 1, ju1)
                    ju2 = QTableWidgetItem(str(i[2]).strip())
                    ju2.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                    self.ui.webman.setItem(num, 2, ju2)
                    ju3 = QTableWidgetItem(str(i[3]).strip())
                    ju3.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                    self.ui.webman.setItem(num, 3, ju3)
                    ju4 = QTableWidgetItem(str(i[4]).strip())
                    ju4.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                    self.ui.webman.setItem(num, 4, ju4)
                    ju5 = QTableWidgetItem(str(i[5]).strip())
                    ju5.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                    self.ui.webman.setItem(num, 5, ju5)
                    ju6 = QTableWidgetItem(str(i[6]).strip())
                    ju6.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                    self.ui.webman.setItem(num, 6, ju6)

                    ju7 = QTableWidgetItem(str(i[7]).strip())
                    ju7.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                    self.ui.webman.setItem(num, 7, ju7)
                    ju8 = QTableWidgetItem(str(i[8]).strip())
                    ju8.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                    self.ui.webman.setItem(num, 8, ju8)

                    searchBtn = QPushButton("编辑")  # 新建一个按钮
                    searchBtn.setDown(True)
                    searchBtn.setStyleSheet("QPushButton{margin:3px};")
                    searchBtn.clicked.connect(self.EditWeb)  # 绑定按钮点击事件
                    # 添加修改模板按钮

                    self.ui.webman.setCellWidget(num, 9, searchBtn)  # 添加按钮到列表（0，2）
                    num = num + 1
                row_count = self.ui.webman.rowCount()
                self.ui.webman.insertRow(row_count)
                self.ui.webman.removeRow(row_count)
            else:
                self.ui.showfont.hide()

    def change_table(self):
        shu = int(self.ui.spinBox.value())
        try:
            cai = int(self.caishu)
        except:
            cai = 0
        if shu > cai:
            QMessageBox.information(self.ui, '提示', '文章数量不足')
            self.ui.spinBox.setValue(cai)

    def EditMyPwd(self):
        yuan = self.ui.lineEdit.text()
        new = self.ui.lineEdit_2.text()
        new1 = self.ui.lineEdit_3.text()
        if new != new1:
            QMessageBox.information(self.ui, '提示', '两次密码输入不一致')
        url = HOST + 'editmypwd/?uid=' + str(self.uid) + '&yuan=' + yuan + '&new=' + new1
        res = requests.get(url=url)
        resObj = res.json()
        if resObj['status'] == 'OK':
            QMessageBox.information(self.ui, '提示', '密码修改成功,请重新登录')
            sys.exit(app.exec_())

        else:
            QMessageBox.information(self.ui, '提示', '原密码错误,请重试')

    def WrittingNotOfOther(self, data):
        # 查询网站下所有栏目
        url = LOCALHOST + 'SearchLanmu/?wenname=' + str(data)
        res = requests.get(url=url).json()
        if res['status'] == 'OK':
            self.ui.comboBox_2.clear()
            llist = str(res['data']).split(',')
            for i in llist:
                self.ui.comboBox_2.addItem(str(i).strip())
        else:
            QMessageBox.information(self.ui, '提示', '未查询到该网站')
            return

    def AutoUpdateWork(self):
        try:
            fan = self.fan
            fabun = self.fabun
        except:
            QMessageBox.information(self.ui, '提示', '请添加内容后再发布')
            return
        res = self.isfree()
        if res == 'yes':
            pass
        else:
            # try:
            faweb = self.ui.comboBox.currentText()
            lan = self.ui.comboBox_2.currentText()
            tian = self.ui.comboBox_3.currentText()
            # 返回 PySide2.QtCore.QDate 对象
            fashijian = self.ui.timeEdit.dateTime()
            # 可以转化为 指定格式的字符串
            dateStr = fashijian.toString('hh:mm:ss')
            tid = open('keys.txt', 'r', encoding='utf-8').read().split(':')[1]
            url = LOCALHOST + 'autoup/'
            data = {
                'fweb': faweb,
                'ftime': dateStr,
                'tian': tian,
                'flan': lan,
                'nums': fabun,
                'tid': tid
            }
            res = requests.post(url=url, data=data).json()
            if res['status'] == 'OK':
                QMessageBox.information(self.ui, '提示', '任务添加成功')
                return


    # 添加到伪原创
    def AddWei(self):
        res = self.isfree()
        if res == 'yes':
            pass
        else:
            textcon = self.ui.textcon.toPlainText()
            self.wei = textcon
            QMessageBox.information(self.ui, '提示', '添加成功')
            return

    # 开始云采集
    def RunCaiJi(self):
        res = self.isfree()
        if res == 'yes':
            pass
        else:
            istitle = os.path.exists('titles.txt')
            if istitle:
                pass
            else:
                QMessageBox.information(self.ui, '提示', '请先设置关键词')
                return
            try:
                cainum = self.ui.cainum.text()
                # self.ui.progressBar.setRange(0, int(cainum))
                # 总共要采集的数量
                self.caishu = int(cainum)

                keys = open('keys.txt', 'r', encoding='utf-8').read().split(':')[0]
                tid = open('keys.txt', 'r', encoding='utf-8').read().split(':')[1]
                caikey = self.ui.caikey.text()
                if caikey:
                    keys = caikey
                self.wan = 'run'
                fan = str(uuid.uuid1())[:7]
                # 根据self.fan判断是否采集
                self.fan = fan
                QMessageBox.information(self.ui, '提示', '云文章处理进度较慢，请耐心等待')
                # 异步
                threading.Thread(target=self.get_url1_work, args=(keys, int(cainum), tid,)).start()

                threading.Thread(target=self.checkworks, args=(keys,)).start()

            except:
                errorurl = HOST + 'geterror/?type=云采集文章出现错误，原因：源站更新，采集规则未更新'
                requests.get(url=errorurl)

    def get_url1_work(self, keyword, num, tid):
        # while True:

        self.shu = int(num)
        nums = 0
        self.jindu = 0
        selfshu = self.shu
        fan = self.fan
        for i in range(1, 1000):
            if selfshu == 0:
                self.shu = selfshu
                self.wan = 'yes'
                return
            url1 = 'http://www.zguonew.com/search?keyword=' + keyword + '&page=' + str(i)
            head = {
                'Referer': 'http://www.zguonew.com/search?keyword=%E6%96%87%E7%AB%A0&page=82',
                'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/93.0.4577.63 Safari/537.36'
            }
            res = requests.get(url=url1, headers=head).content.decode('utf-8')
            soup = BeautifulSoup(res, 'html.parser')
            redata = soup.find_all('a')

            for i in redata:
                if selfshu == 0:
                    self.shu = selfshu
                    self.wan = 'yes'
                    return
                else:
                    try:
                        if str(i.get_text()).find('.html') != -1:

                            url = 'http://www.zguonew.com' + str(i.get_text())
                            conres = requests.get(url=url, headers=head).content.decode('utf-8')
                            consoup = BeautifulSoup(conres, 'html.parser')
                            yuantitle = consoup.find('h1', class_='tit')
                            content = consoup.find('div', class_='detail-content')
                            # 检测是否重复
                            checkchongurl = LOCALHOST + 'checktitlechong/'

                            yuanbiao = yuantitle.get_text()
                            data = {
                                'title': yuanbiao,
                                'yuan': 'www.zguonew.com',
                            }
                            res = requests.post(url=checkchongurl, data=data).json()
                            # 如果不重复则存入数据库
                            if res['chong'] == 'no':
                                # 获取文章每个段落
                                c = content.find_all('p')
                                duan = ''
                                for i in c:
                                    img = i.find('img')
                                    duancon = str(i.get_text()).replace(' ', '').replace('\n', '').replace(' ', '')

                                    duan = duan + duancon
                                    if img == -1:
                                        # if str(i.get_text()).replace(' ', '').replace('\n', '').replace(' ', ''):
                                        duancon = str(i.get_text()).replace(' ', '').replace('\n', '').replace(' ', '')
                                        if str(duancon).find('http') != -1 or str(duancon).find(
                                                'https') != -1 or str(duancon).find('Http') != -1:
                                            pass
                                        else:
                                            # duan = duan + '#replace#' + duancon
                                            duan = duan + duancon
                                    else:
                                        img = str(img)
                                        qian = img.find('src="')
                                        hou = img.find('" st')
                                        imgurl = img[qian:hou].replace('src="', '').replace(
                                            '" title="1628045422609742.png"/',
                                            '').replace('\n', '').replace(' ',
                                                                          '')

                                        duan = duan + imgurl
                                # 数据入库
                                savedataurl = LOCALHOST + 'savecai/'

                                data = {
                                    'yuantitle': yuantitle,
                                    'yuan': 'www.zguonew.com',
                                    'tid': tid,
                                    'keys': keyword,
                                    'con': duan,
                                    'fan': fan
                                }

                                requests.post(url=savedataurl, data=data)
                                # self.ui.progressBar.setValue(self.jindu)
                                # 剩余需要采集的数量
                                self.wan = 'no'
                                selfshu = int(selfshu) - 1

                                nums = nums + 1
                            # 先查询是否重复
                            # 将爬取的数据存入数据库
                    except:
                        print('程序报错')

        if self.wan == 'yes':
            # QMessageBox.information(self.ui, '提示', '采集完成')
            return
        else:
            self.wan = 'url1'
            self.shu = selfshu
            return

    def get_url2_work(self, keyword, num):
        url2 = 'https://www.baidu.com/s?rtt=1&bsst=1&cl=2&tn=news&ie=utf-8&word=%E4%BA%BA%E6%B0%91&x_bfe_rqs=03E80&x_bfe_tjscore=0.100000&tngroupname=organic_news&newVideo=12&goods_entry_switch=1&rsv_dl=news_b_pn&pn=10'
        head = {
            'Referer': 'https://www.baidu.com/s?ie=utf-8&medium=0&rtt=1&bsst=1&rsv_dl=news_t_sk&cl=2&wd=%E4%BA%BA%E6%B0%91&tn=news&rsv_bp=1&oq=&rsv_btype=t&f=8',
            'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/93.0.4577.63 Safari/537.36',
            'sec-ch-ua': '"Google Chrome";v="93", " Not;A Brand";v="99", "Chromium";v="93"',
            'Host': 'www.baidu.com'
        }
        res = requests.get(url=url2, headers=head).content.decode('utf-8')
        soup = BeautifulSoup(res, 'html.parser')
        numsp = int(soup.find('span', class_='nums c-color-gray2').replace('找到相关资讯', '').replace('篇', ''))
        # 翻页
        nums = 0
        for p in range(0, numsp, 10):
            res = requests.get(url=url2, headers=head).content.decode('utf-8')
            soup = BeautifulSoup(res, 'html.parser')
            resdata = soup.find_all('a', class_='news-title-font_1xS-F')
            for i in resdata:
                dataurl = str(i['href'])
                if dataurl.find('baijiahao.baidu.com') != -1:
                    if nums == num:
                        self.wan = 'yes'
                        return
                    else:
                        rescon = requests.get(url=dataurl, headers=head).content.decode('utf-8')
                        consoup = BeautifulSoup(rescon, 'html.parser')
                        restitle = consoup.find('div', class_='index-module_articleTitle_28fPT ')
                        rescon = consoup.find('div', class_='index-module_articleWrap_2Zphx ')
                        # 将爬取的数据存入数据库
                        nums = nums + 1
                        self.shu = int(self.shu) - 1
                        self.wan = 'no'
        if self.wan == 'no':
            self.wan = 'url2'
            return
        else:
            return

    def get_url3_work(self, keyword, num):
        pass

    def generateMenu(self, pos):
        # rint( pos)
        row_num = -1
        for i in self.ui.yuncai.selectionModel().selection().indexes():
            row_num = i.row()

        menu = QMenu()
        item1 = menu.addAction(u"查看")
        item2 = menu.addAction(u"删除")
        action = menu.exec_(self.ui.yuncai.mapToGlobal(pos))
        if action == item1:
            self.EditCon(con=self.ui.yuncai.item(row_num, 1).text())
        if action == item2:
            self.DelCon(row_num)
        else:
            return

    def EditCon(self, con):
        with open("c.txt", "w") as f:
            f.write(str(con))  # 自带文件关闭功能，不需要再写f.close()
        stats.anzh = EditC()
        stats.anzh.ui.show()

    def DelCon(self, row_num):
        con = self.ui.yuncai.item(row_num, 1).text()
        # 查找原文修改
        url = LOCALHOST + 'editcon/'
        data = {
            'yuan': con,
            'type': 'del'
        }
        requests.post(url=url, data=data)
        QMessageBox.information(self.ui, '系统提示', '删除成功')

    # 使用异步检测第一个是否采集完成 采集完成后采集的数量是否达到用户输入的  如果不够再分发采集
    def checkworks(self, keyword):
        while True:
            if self.wan == 'yes':
                # 采集完成后将采集到的数据展示到列表
                getcai = LOCALHOST + 'geisavefan/?fan=' + self.fan
                res = requests.get(url=getcai).json()
                num = 0
                self.fabun = len(res['data'])
                self.ui.yuncai.setRowCount(len(res['data']))


                for i in res['data']:
                    b = QTableWidgetItem(str(i[0]))
                    b.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                    self.ui.yuncai.setItem(num, 0, b)
                    ju = QTableWidgetItem(str(i[1]))
                    ju.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
                    self.ui.yuncai.setItem(num, 1, ju)

                    num = num + 1
                row_count = self.ui.yuncai.rowCount()
                self.ui.yuncai.insertRow(row_count)
                self.ui.yuncai.removeRow(row_count)
                # self.ui.yuncai.removeRow(row_count)
                # 采集完成后在
                # jiannum = HOST + 'jiannum/?type=cai&num=' + str(len(res['data']))
                # requests.get(url=jiannum)
                return
                # QMessageBox.information(self.ui, '提示', '采集完成')
            if self.wan == 'url1':
                # URL1采集完成 但是数量不够
                if self.shu != 0:
                    # 继续分发下一个采集
                    self.get_url2_work(keyword=keyword, num=self.shu)
                    pass
            if self.wan == 'url2':
                if self.shu > 0:
                    self.get_url3_work(keyword=keyword, num=self.shu)

    # 开始伪原创
    def RunWei(self):
        res = self.isfree()
        if res == 'yes':
            pass
        else:
            try:
                con = self.wei
                if con:
                    api1 = 'http://fanyi.youdao.com/translate?&doctype=json&type=AUTO&i=' + con.replace('。', ',')
                    res = requests.get(url=api1).json()['translateResult']
                    for w in res:
                        wen = w[0]['tgt']
                        weiurl = 'http://fanyi.youdao.com/translate?&doctype=json&type=AUTO&i=' + wen
                        weiyuanres = requests.get(url=weiurl).json()['translateResult']
                        weilist = ''
                        for wei in weiyuanres:
                            self.ui.textBrowser.append(wei[0]['tgt'])
                            weilist = weilist + str(wei[0]['tgt'])
                        self.weilist = weilist
                    jiannum = HOST + 'jiannum/?type=wei&num=' + str(1)
                    requests.get(url=jiannum).json()
                else:
                    QMessageBox.information(self.ui, '提示', '请先手动输入文章再进行伪原创')
            except:
                # 返回错误
                errorurl = HOST + 'geterror/?type=伪原创出错,原因：可能是翻译接口出现问题'
                requests.get(url=errorurl)

    def shuo(self, add):
        if add == 4:
            stats.settitle = Shuoming()
            stats.settitle.show()

    def EditWeb(self):
        hang = int(self.ui.webman.currentIndex().row()) + 1
        filename = 'hang.conf'
        with open(filename, 'w') as file_object:
            file_object.write(str(hang))
            file_object.close()
        stats.info = EditMyWeb()
        stats.info.ui.show()

    # 标题设置
    def SetTitle(self):
        res = self.isfree()
        if res == 'yes':
            pass
        else:
            try:
                titles = self.keylist
            except:
                titles = []
        try:
            os.remove('titles.txt')
        except:
            pass
        for i in titles:
            with open("titles.txt", "a", encoding='utf-8') as f:
                f.write(str(i) + "\n")  # 自带文件关闭功能，不需要再写f.close()
        stats.settitle = SetTitle()
        stats.settitle.ui.show()

    def bandserver(self):
        f = open('conf.conf', 'r')
        uid = f.read()
        url = url = HOST + 'checkversion/?uid=' + str(uid)
        res = requests.get(url=url).json()
        if res['status'] == 'NO':
            QMessageBox.information(self.ui, '系统提示', str(res['msg']))
            return
        stats.band = BandServer()
        stats.band.ui.show()

    # 搜索关键词
    def SearchKeys(self):
        keys = self.ui.keys.text()
        num = self.ui.comboBox_4.currentText()
        if num == '200词':
            num = 200
        if num == '500词':
            num = 500
        if num == '2000词':
            num = 2000
        tid = str(uuid.uuid1())[:5]
        with open("keys.txt", "w", encoding='utf-8') as f:
            f.write(str(keys) + ':' + tid)  # 自带文件关闭功能，不需要再写f.close()

        QMessageBox.information(self.ui, '提示', '关键词查询速度较慢，请耐心等待')
        c = threading.Thread(target=self.search_thwork, args=(keys, num))
        # c.daemon = True
        c.start()

    # 导出
    def DaoChuKeys(self):
        res = self.isfree()
        if res == 'yes':
            pass
        else:
            try:
                keylist = self.keylist
                key = self.key
                for i in keylist:
                    with open(key + ".txt", "a", encoding='utf-8') as f:
                        f.write(str(i) + "\n")  # 自带文件关闭功能，不需要再写f.close()
                QMessageBox.information(self.ui, '提示', '保存成功')
                return
            except:
                QMessageBox.information(self.ui, '提示', '请先搜索长尾词')
                return

    # 搜索关键词异步
    def search_thwork(self, keys, num):
        # try:
        keylist = []
        self.key = keys
        # progressBar_2
        for i in range(0, int(num), 10):
            q = i + 10
            # self.ui.progressBar_2.setValue(q)
            url = 'https://zhidao.baidu.com/search?word=' + str(keys) + '&ie=gbk&site=-1&sites=0&date=0&pn=' + str(
                i)
            head = {
                "Accept": "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3",
                "Accept-Encoding": "gzip, deflate, br",
                "Accept-Language": "zh-CN,zh;q=0.9,en;q=0.8",
                "Connection": "keep-alive",
                "Host": "zhidao.baidu.com",
                "Upgrade-Insecure-Requests": "1",
                'cookie': 'PSTM=1630902467; BAIDUID=33EC40EEA09E57A77D33C70CEEF96922:FG=1; BIDUPSID=16CAE97753A88D65D362BD6DFD53359F; __yjs_duid=1_4b424a02fe749a80cb1d532395f274751631006724605; BDORZ=B490B5EBF6F3CD402E515D22BCDA1598; BDUSS=lRBVW1Mb1o4Y2ZVRH4weG9aS1g0N1RGYzNwTHItbFZqNzM0dFNMMH5ZakVMMlJoRVFBQUFBJCQAAAAAAAAAAAEAAAA2JyXRYWRtaW4zawAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMSiPGHEojxhW; BDUSS_BFESS=lRBVW1Mb1o4Y2ZVRH4weG9aS1g0N1RGYzNwTHItbFZqNzM0dFNMMH5ZakVMMlJoRVFBQUFBJCQAAAAAAAAAAAEAAAA2JyXRYWRtaW4zawAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMSiPGHEojxhW; BAIDU_WISE_UID=wapp_1631945362518_255; delPer=0; PSINO=6; BDRCVFR[C0p6oIjvx-c]=I67x6TjHwwYf0; BCLID=12907963656724777170; BDSFRCVID=pwIOJexroG0kGlbHOOGDh71JFgKK0gOTDYLEe0lBE5z2gfIVgM0sEG0Ptsi5GL8-oxZhogKK0mOTHv-F_2uxOjjg8UtVJeC6EG0Ptf8g0M5; H_BDCLCKID_SF=tRk8_It2tIvbfP0khbu_-P4Dep3fBxRZ56bHWh0M2h3SHlnOXUJUM5bLy4jMBMPj52OnKUT13RK2DhoHjJCKbPKP3xJuJnJ43bRTLPOVJl3db56v2h6shP-UyN3LWh37btjlMKoaMp78jR093JO4y4Ldj4oxJpOJ5JbMopCafJOKHICCDj8beM5; BCLID_BFESS=12907963656724777170; BDSFRCVID_BFESS=pwIOJexroG0kGlbHOOGDh71JFgKK0gOTDYLEe0lBE5z2gfIVgM0sEG0Ptsi5GL8-oxZhogKK0mOTHv-F_2uxOjjg8UtVJeC6EG0Ptf8g0M5; H_BDCLCKID_SF_BFESS=tRk8_It2tIvbfP0khbu_-P4Dep3fBxRZ56bHWh0M2h3SHlnOXUJUM5bLy4jMBMPj52OnKUT13RK2DhoHjJCKbPKP3xJuJnJ43bRTLPOVJl3db56v2h6shP-UyN3LWh37btjlMKoaMp78jR093JO4y4Ldj4oxJpOJ5JbMopCafJOKHICCDj8beM5; BAIDUID_BFESS=D6230E9BA70F572D0B515656C807E4D5:FG=1; H_PS_PSSID=34646_34443_34538_34067_31254_34553_34004_34524_34585_34107_26350_34424_34474_34688; ZD_ENTRY=baidu; Hm_lvt_6859ce5aaf00fb00387e6434e4fcc925=1631540776,1631763138,1631893991,1631954866; shitong_key_id=2; Hm_lpvt_6859ce5aaf00fb00387e6434e4fcc925=1631954870; shitong_data=40447fba5ea2533355e57962bee24300fbdcfe2a6e0e6b4ffe01c37fad07edec9b6b3f636366b29d086315ec5b0cacc3aba6854287ecb83d41f3cd77fa940d3be45bb771444df99dc2e103d68480a39accc3c2dc07b593160489537855ec3f6ef17adb0bf1c8ba639f1a307f07f51a19a0d69e11aed92d0123b6adb3b4a4548237b58fd39f8eb3b187cf1894767733fc; shitong_sign=f3b905ee; BA_HECTOR=2g05a1a1ag2h840gbp1gkbaq10r; ab_sr=1.0.1_MjA2MGM0OTE5MDVjYjlhNWZhZTMyYzRkZmVmZjU2YjA5MWI5ZjBjMmJiMWJmOTllY2FkNDIxZjZkOTRlZDM0ODViMzQzODJlNTE0ZDI1NWRiNWI2MjQyZmY3MmQ3ZmE1YzNjMWMzOGRhMmY2ODA1NWFmMzZmOWNlNjE0MTNlOWUwMTA0NGZkOTdkYTU5MzY2MGU5NjhlNzRhNzA3MjI0ZQ==',
                'Referer': 'https://zhidao.baidu.com/search?word=%C3%DE%B1%BB&ie=gbk&site=-1&sites=0&date=0&pn=20',
                'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:57.0) Gecko/20100101 Firefox/57.0'

            }
            try:
                res = requests.get(url=url, headers=head).content.decode('gbk')
            except:
                res = requests.get(url=url, headers=head).content.decode('gbk')
            soup = BeautifulSoup(res, 'html.parser')

            redata = soup.find_all('a', class_='ti')
            for i in redata:
                keylist.append(str(i.get_text()))
            time.sleep(0.5)
        self.keylist = keylist
        self.ui.allweb_2.show()
        self.ui.allweb_2.setColumnWidth(0, 90)
        self.ui.allweb_2.setColumnWidth(1, 532)
        self.ui.allweb_2.verticalHeader().setVisible(False)  # 隐藏自带序列
        self.ui.allweb_2.setRowCount(len(keylist))
        # 插入数据
        num = 0
        for i in keylist:
            ju0 = QTableWidgetItem(str(int(num) + 1))
            ju0.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.allweb_2.setItem(num, 0, ju0)
            ju = QTableWidgetItem(str(i))
            ju.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.ui.allweb_2.setItem(num, 1, ju)
            num = num + 1
        row_count = self.ui.allweb_2.rowCount()
        self.ui.allweb_2.insertRow(row_count)
        jiannum = HOST + 'jiannum/?type=guan&num=' + str(num) + '&uid=' + str(self.uid)
        requests.get(url=jiannum).json()

    def InstallTem(self):
        stats.anzh = anzhuang()
        stats.anzh.show()
    # http://82.157.35.235/installtem/


class Shuoming(QMainWindow):
    def __init__(self):
        # 从文件中加载UI定义
        super(Shuoming, self).__init__()
        self.initUI()

    def initUI(self):
        # 将窗口设置为动图大小
        self.resize(1000, 800)
        self.browser = QWebEngineView()
        url = HOST + 'getshuo/'
        self.browser.load(QUrl(url))
        self.setCentralWidget(self.browser)
        # 添加窗口标题
        self.setWindowTitle("飞鱼自助建站系统使用说明")
        self.btn_1 = QPushButton("Btn_1")
        self.btn_2 = QPushButton("Btn_2")


class EditC():
    def __init__(self):
        self.ui = uic.loadUi("resource/EditCon.ui")
        data = ''
        # self.ui.pushButton.clicked.connect(self.Put)
        with open("c.txt", "r") as f:  # 打开文件
            data = data + f.read()  # 读取文件
        self.ui.textEdit.setText('<font size="7">' + str(data) + '</font>')

    def Put(self):
        data = ''
        with open("c.txt", "r") as f:  # 打开文件
            data = data + f.read()  # 读取文件
        newcon = self.ui.textEdit.toPlainText()
        # 查找原文修改
        url = LOCALHOST + 'editcon/'
        data = {
            'yuan': data,
            'new': newcon
        }
        requests.post(url=url, data=data)
        QMessageBox.information(self.ui, '系统提示', '修改成功')
        self.ui.close()


class anzhuang(QMainWindow):
    def __init__(self):
        # 从文件中加载UI定义
        super(anzhuang, self).__init__()
        self.initUI()

    def initUI(self):
        # 将窗口设置为动图大小
        self.resize(1000, 800)
        self.browser = QWebEngineView()
        f = open('conf.conf', 'r')
        uid = f.read()
        url = LOCALHOST + 'installtem/?uid=' + str(uid)
        self.browser.load(QUrl(url))
        self.setCentralWidget(self.browser)
        # 添加窗口标题
        self.setWindowTitle("飞鱼CMS模板安装")
        self.btn_1 = QPushButton("Btn_1")
        self.btn_2 = QPushButton("Btn_2")


class EditMyWeb():
    def __init__(self):
        # 从文件中加载UI定义
        # addeditwebinfo
        self.ui = uic.loadUi("resource/EditMyWeb.ui")
        self.ui.addeditwebinfo.clicked.connect(self.getEditInfo)
        hang = open('hang.conf', 'r')
        hang = hang.read()
        url = LOCALHOST + 'getwebinfo/?hang=' + str(hang)
        res = requests.get(url).json()
        res = res['data']
        self.ui.name.setText(res[0])
        self.ui.lanmu.setText(res[1])
        self.ui.title.setText(res[2])
        self.ui.keywords.setText(res[3])
        self.ui.miaoshu.setText(res[4])
        self.ui.yuming.setText(res[5])
        self.ui.adminuser.setText(res[6])
        self.ui.adminpwd.setText(res[7])
        self.wid = res[8]

    def getEditInfo(self):
        name = self.ui.name.text()
        yuming = self.ui.yuming.text()
        lanmu = self.ui.lanmu.text()
        title = self.ui.title.text()
        keywords = self.ui.keywords.text()
        miaoshu = self.ui.miaoshu.toPlainText()
        adminuser = self.ui.adminuser.text()
        adminpwd = self.ui.adminpwd.text()
        wid = self.wid
        url = LOCALHOST + 'getwebinfo/'
        data = {
            'wid': wid,
            'webname': name,
            'lanmuname': lanmu,
            'title': title,
            'keywords': keywords,
            'description': miaoshu,
            'url': yuming,
            'adminuser': adminuser,
            'adminpwd': adminpwd
        }
        res = requests.post(url=url, data=data).json()
        if res['status'] == 'OK':
            QMessageBox.information(self.ui, '系统提示', '编辑成功,请点击更新数据')
            self.ui.close()
        else:
            QMessageBox.information(self.ui, '系统提示', '编辑失败')


class SetTitle():
    def __init__(self):

        # 从文件中加载UI定义
        self.ui = uic.loadUi("resource/SetTitle.ui")
        # settitle    SearchKeys
        self.ui.cleinput.clicked.connect(self.CelInput)
        self.ui.runtitle.clicked.connect(self.RunTitle)
        try:
            for line in open("titles.txt", encoding='utf-8'):
                self.ui.keywords.append(str(line).replace('\n', ''))
        except:
            pass

    # 清空
    def CelInput(self):
        self.ui.qian.clear()
        self.ui.keywords.clear()
        self.ui.hou.clear()
        self.ui.keylists.clear()

    # 生成标题
    def RunTitle(self):
        qian = str(self.ui.qian.toPlainText()).split('\n')
        hou = str(self.ui.hou.toPlainText()).split('\n')
        keys = str(self.ui.keywords.toPlainText()).split('\n')
        num = self.ui.num.text()
        if num:
            pass
        else:
            QMessageBox.information(self.ui, '提示', '请输入生成标题的个数')
        nums = 1
        url = LOCALHOST + 'saavetitle/'
        f = open('keys.txt', 'r', encoding='utf-8')
        ti = f.read().split(':')
        QMessageBox.information(self.ui, '提示', '生成标题时间较久，生成完，会提示。完成后，此页面可关闭。')
        # 生成标题时间较久，生成完，会提示。完成后，此页面可关闭。
        for q in qian:
            for i in keys:
                for h in hou:
                    if nums == int(num):
                        self.ui.keylists.append(str(q + i + h))
                        data = {
                            'tid': ti[1],
                            'keys': ti[0],
                            'title': str(q + i + h)
                        }
                        requests.post(url=url, data=data)
                        self.title = 1
                        QMessageBox.information(self.ui, '提示', '标题生成完成')
                        return
                    else:
                        self.ui.keylists.append(str(q + i + h))
                        data = {
                            'tid': ti[1],
                            'keys': ti[0],
                            'title': str(q + i + h)
                        }
                        requests.post(url=url, data=data)
                    nums = nums + 1
        # 关键字

        # 将所有生成的标题存入数据库


class BandServer():
    def __init__(self):
        # 从文件中加载UI定义
        self.ui = uic.loadUi("newweb.ui")
        self.ui.InstallWeb.clicked.connect(self.addWebInfo)

    def read_file(self, file):
        with open(file, encoding='UTF-8') as f:
            read_all = f.read()
            f.close()

        return read_all

    # 写内容到文件
    def rewrite_file(self, file, data):
        with open(file, 'w', encoding='UTF-8') as f:
            f.write(data)
            f.close()

    def addWebInfo(self):
        QMessageBox.information(self.ui, '系统提示', '正在创建网站,创建过程需要90秒左右,期间请不要点击软件否则可能导致创建失败！')
        name = self.ui.name.text()
        yuming = self.ui.yuming.text()
        lanmu = self.ui.lanmu.text()
        title = self.ui.title.text()
        keywords = self.ui.keywords.text()
        miaoshu = self.ui.miaoshu.toPlainText()
        adminuser = self.ui.adminuser.text()
        adminpwd = self.ui.adminpwd.text()
        ip = self.ui.name_2.text()
        content = self.read_file('host.py')
        content = content.replace('http://82.157.35.235/', str('http://' + ip + '/'))
        self.rewrite_file('host.py', content)
        url = LOCALHOST + 'installapp/'
        f = open('conf.conf', 'r')
        wid = ''
        uid = f.read()
        # 发生给总服务器
        addnumsurl = HOST + 'addwebnums/?uid=' + str(uid) + '&ip=' + str(ip)
        addres = requests.get(url=addnumsurl).json()
        if addres['status'] == 'OK':
            pass
        else:
            QMessageBox.information(self.ui, '系统提示', '系统正在更新，请耐心等待或咨询客服')
            return
        # 发生数据到服务端
        list = ['app', 'static', 'editapp', 'addset', 'settings', 'alter']
        wid = ''.join(random.choice(string.ascii_uppercase) for _ in range(5))
        for l in list:
            data = {
                'uid': uid,
                'wid': str(wid),
                'type': str(l),
                'webname': name,
                'lanmuname': lanmu,
                'title': title,
                'keywords': keywords,
                'description': miaoshu,
                'url': yuming,
                'adminuser': adminuser,
                'adminpwd': adminpwd
            }

            requests.post(url=url, data=data)
            if l == 'app':
                time.sleep(30)
            else:
                time.sleep(20)
            if l == 'alter':
                self.ui.close()
                QMessageBox.information(self.ui, '系统提示', '添加成功,请点击更新数据')


class Login:

    def __init__(self):
        # 从文件中加载UI定义
        self.ui = uic.loadUi("login.ui")
        try:
            os.remove('titles.txt')
        except:
            pass
        fileis = os.path.exists("user.conf")
        if fileis:
            with open("user.conf", "r") as f:
                data = f.readline()
            self.ui.phone.setText(data.split(':')[0])
            self.ui.password.setText(data.split(':')[1])
            self.ui.jizhupwd.setChecked(True)
        else:
            self.ui.jizhupwd.setChecked(False)
        self.ui.loginButton.clicked.connect(self.handleCalc)
        self.ui.resButton.clicked.connect(self.reg)

    def handleCalc(self):
        phone = self.ui.phone.text()
        password = self.ui.password.text()
        userlogin = requests.session()
        ischeck = self.ui.jizhupwd.isChecked()
        # 记住密码
        if ischeck:
            uinfo = str(phone) + ':' + str(password)
            with open("user.conf", "w") as f:
                f.write(uinfo)  # 自带文件关闭功能，不需要再写f.close()
        else:
            fileis = os.path.exists("user.conf")
            if fileis:
                os.remove('user.conf')
        url = HOST + 'userlogin/'
        data = {
            'phone': phone,
            'pwd': password
        }
        if phone and password:
            res = userlogin.post(url=url, data=data)
            resObj = res.json()
            if resObj['msg'] == 'OK':
                filename = 'conf.conf'
                with open(filename, 'w') as file_object:
                    file_object.write(str(resObj['uid']))
                    file_object.close()
                self.ui.close()
                stats.index = Index()
                stats.index.ui.show()

            else:
                QMessageBox.information(self.ui, '登录提示', '登录失败')
        else:
            QMessageBox.information(self.ui, '提示信息', '请输入用户名和密码登录')

    def reg(self):
        stats.res = Res()
        stats.res.ui.show()


class Res:
    def __init__(self):
        # 从文件中加载UI定义
        self.ui = uic.loadUi("reg.ui")
        # shuomingButton
        self.ui.shuomingButton.clicked.connect(self.Alert)
        self.ui.resButton.clicked.connect(self.RetResData)
        self.ui.loginButton.clicked.connect(self.loginButton)
        self.ui.xieyi.toggled.connect(self.choose)

    def choose(self):
        isc = self.ui.xieyi.isChecked()
        if isc is True:
            self.ui.resButton.setEnabled(True)
        else:
            self.ui.resButton.setEnabled(False)

    def Alert(self):
        stats.al = RegAlert()
        stats.al.show()

    def RetResData(self):
        phone = self.ui.phone.text()
        password = self.ui.password.text()
        qqcard = self.ui.qqcard.text()
        if len(phone) != 11:
            QMessageBox.information(self.ui, '提示信息', '请输入正确手机号码')
            return
        if phone and password and qqcard:
            userlogin = requests.session()
            url = HOST + 'userreg/'
            data = {
                'phone': phone,
                'pwd': password,
                'qqcard': qqcard
            }
            res = userlogin.post(url=url, data=data)
            resObj = res.json()
            if resObj['msg'] == 'OK':
                QMessageBox.information(self.ui, '提示信息', '注册成功')
            else:
                QMessageBox.information(self.ui, '提示信息', str(resObj['msg']))
        else:
            QMessageBox.information(self.ui, '提示信息', '请输入完整注册信息')

    def loginButton(self):
        self.ui.close()


# 注册协议弹窗
class RegAlert(QMainWindow):
    def __init__(self):
        # 从文件中加载UI定义
        super(RegAlert, self).__init__()
        self.initUI()

    def initUI(self):
        # 将窗口设置为动图大小
        self.resize(1000, 800)
        self.browser = QWebEngineView()
        url = HOST + 'getxieyi/'
        self.browser.load(QUrl(url))
        self.setCentralWidget(self.browser)
        # 添加窗口标题
        self.setWindowTitle("飞鱼自助建站系统注册协议")
        self.btn_1 = QPushButton("Btn_1")
        self.btn_2 = QPushButton("Btn_2")

if __name__ == '__main__':
    app = QApplication(sys.argv)
    app.setWindowIcon(QIcon('icon.jpg'))
    stats = Login()
    # stats = Index()
    stats.ui.show()
    # stats.show()
    sys.exit(app.exec_())
