CREATE TABLE `t_localfiles` (
	`id` INT(11) NOT NULL AUTO_INCREMENT,
	`filename` VARCHAR(256) NOT NULL DEFAULT '' COMMENT '文件名' COLLATE 'utf8_bin',
	`filepath` VARCHAR(512) NOT NULL DEFAULT '' COMMENT '文件路径' COLLATE 'utf8_bin',
	`filesize` BIGINT(20) NOT NULL DEFAULT '0' COMMENT '文件大小',
	`md5` VARCHAR(512) NOT NULL DEFAULT '' COMMENT '文件md5校验值' COLLATE 'utf8_bin',
	`ismd5checked` TINYINT(4) NOT NULL DEFAULT '0' COMMENT '是否检查过文件md5校验',
	`isbdchecked` TINYINT(4) NOT NULL DEFAULT '0' COMMENT '是否检查过百度云上是否存在',
	`isbdexists` TINYINT(4) NOT NULL DEFAULT '0' COMMENT '百度云上是否存在',
	`createtime` DATETIME NULL DEFAULT NULL,
	`updatetime` DATETIME NULL DEFAULT NULL,
	`isdeleted` TINYINT(4) NOT NULL DEFAULT '0',
	`isconverted` TINYINT(4) NOT NULL DEFAULT '0',
	PRIMARY KEY (`id`, `ismd5checked`, `isbdchecked`, `isbdexists`, `isdeleted`, `isconverted`) USING BTREE
)
COMMENT='本地使用everything搜索出来的符合规则的文件信息\r\n'
COLLATE='utf8_bin'
ENGINE=InnoDB
AUTO_INCREMENT=2424
;

SELECT * FROM t_localfiles WHERE `md5` IN (
	SELECT `md5` FROM (
		SELECT `md5`,COUNT(1) AS tcount FROM t_localfiles WHERE  INSTR(filename, '.gz') GROUP BY `md5` 
	) results WHERE tcount > 1 AND `md5` != ''
) ;