using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;
using System.Data;

//ȫռ
using Lucene.Net.Index;
using Lucene.Net.Documents;
using Lucene.Net.Analysis.Standard;
using Lucene.Net.Search;
using Lucene.Net.QueryParsers;
using Lucene.Net.Analysis;
using Lucene.Net.Analysis.PanGu;

namespace ATL.Search
{
    public class IndexQuery
    {
        //·
        private string _path;

        public string Path
        {
            get { return _path; }
            set { _path = value; }
        }

        

        //ִ
        string GetKerWords(string kw,PanGuTokenizer token)
        {

            StringBuilder result = new StringBuilder();

            ICollection<PanGu.WordInfo> words = token.SegmentToWordInfos(kw);

            foreach (PanGu.WordInfo word in words)
            {
                if (word == null)
                {
                    continue;
                }

                result.AppendFormat("{0}^{1}.0 ", word.Word, (int)Math.Pow(3, word.Rank));
            }

            return result.ToString().Trim();
        }
        //DataTable
        public int Search(string kw)
        {
            string keywords = kw;

            IndexSearcher search = new IndexSearcher(Path);
            //ִ
            kw = GetKerWords(kw, new PanGuTokenizer());
            //Query
            QueryParser titleQueryParser = new QueryParser("title",new PanGuAnalyzer(true));
            Query TitleQuery = titleQueryParser.Parse(kw);

            QueryParser contentQueryParser = new QueryParser("content", new PanGuAnalyzer(true));
            Query ContentQuery = contentQueryParser.Parse(kw);

            //QueryParser KwQueryParser = new QueryParser("kw",new PanGuAnalyzer(true));
            //Query KwQuery = KwQueryParser.Parse(kw);

            //Ӳѯ
            BooleanQuery bq = new BooleanQuery();
            bq.Add(TitleQuery, BooleanClause.Occur.SHOULD);
            bq.Add(ContentQuery, BooleanClause.Occur.MUST);
            //bq.Add(KwQuery, BooleanClause.Occur.MUST);
            
            //ѯܽ

            Hits hits = search.Search(bq);

            //DataTable
            DataTable dt = new DataTable();
            DataColumn dc = new DataColumn();
            dc.ColumnName = "id";
            dt.Columns.Add(dc);
            DataColumn dc1 = new DataColumn();
            dc1.ColumnName = "title";
            dt.Columns.Add(dc1);
            DataColumn dc2 = new DataColumn();
            dc2.ColumnName = "content";
            dt.Columns.Add(dc2);
            DataColumn dc3 = new DataColumn();
            dc3.ColumnName = "url";
            dt.Columns.Add(dc3);
            DataColumn dc4 = new DataColumn();
            dc4.ColumnName = "time";
            dt.Columns.Add(dc4);

            //ѭѽӵDT

            //for (int i = 0; i < hits.Length(); i++)
            //{
            //    //
            //    DataRow row = dt.NewRow();
            //    row["id"] = hits.Doc(i).Get("id");
            //    row["title"] = hits.Doc(i).Get("title");
            //    row["content"] = hits.Doc(i).Get("content");
            //    row["url"] = hits.Doc(i).Get("url");
            //    String time = hits.Doc(i).Get("time");
            //    row["time"] = DateTime.ParseExact(time, "yyyyMMdd", null);

            //    //ؼָ
            //    PanGu.HighLight.SimpleHTMLFormatter simpleHTMLFormatter =
            //            new PanGu.HighLight.SimpleHTMLFormatter("<font color=\"red\">", "</font>");

            //    PanGu.HighLight.Highlighter highlighter = new PanGu.HighLight.Highlighter(simpleHTMLFormatter,new PanGu.Segment());

            //    highlighter.FragmentSize = 50;

            //    string content = highlighter.GetBestFragment(keywords, row["content"].ToString());
            //    string title = highlighter.GetBestFragment(keywords, row["title"].ToString());
            //    if (string.IsNullOrEmpty(title))
            //    {
            //        title = row["title"].ToString();
            //    }
            //    if (string.IsNullOrEmpty(content))
            //    {
            //        content = row["content"].ToString();
            //    }
            //    row["title"] = title;
            //    row["content"] = content;

            //    //
            //    dt.Rows.Add(row);
            //}

            return hits.Length();
          
        }
    }
}
