﻿using System;
using System.Collections.Generic;
using System.Collections;
using System.Text;
using System.Data.Common;
using System.Data;
using Fm.DataAccess;
namespace Fm.Bussiness
{
    /// <summary>
    /// Fm_Admin_Login 的摘要说明
    /// </summary>
    public class Fm_Admin_Login
    {
        public Fm_Admin_Login()
        {
            //
            // TODO: 在此处添加构造函数逻辑
            //
        }
        /// <summary>
        /// 删除登陆日志的方法
        /// </summary>
        /// <param name="lo_id"></param>
        public bool Login_Ip_del(Fm.EntityClass.Login login)
        {
            DbCommand db = DataAccess.DataAccess.db.GetStoredProcCommand("Query_Fm_login_Delete");
            DataAccess.DataAccess.db.AddInParameter(db, "@lo_id",DbType.Int32,login.lo_id);
            return DataAccess.DataAccess.GetData.Query<DbCommand>(db);
        }
        /// <summary>
        /// 管理员登陆日志
        /// </summary>
        /// <param name="user"></param>
        /// <param name="user_ip"></param>
        public void Login_Ip(Fm.EntityClass.Login login)
        {
            DbCommand db = DataAccess.DataAccess.db.GetStoredProcCommand("Query_Fm_login_ADD");
            DataAccess.DataAccess.db.AddOutParameter(db, "@lo_id",DbType.Int32,login.lo_id);
            DataAccess.DataAccess.db.AddInParameter(db, "@lo_user",DbType.String,login.lo_user);
            DataAccess.DataAccess.db.AddInParameter(db, "@lo_ip",DbType.String,login.lo_ip);
            DataAccess.DataAccess.db.AddInParameter(db, "@lo_time",DbType.Time,login.lo_time);
            DataAccess.DataAccess.GetData.Query<DbCommand>(db);
        }
        /// <summary>
        /// 查询主菜单的方法
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public IList Admin_Menu(string where)
        {
            DbCommand db = DataAccess.DataAccess.db.GetStoredProcCommand("Fm_Admin_Menu");
            DataAccess.DataAccess.db.AddInParameter(db, "@where", DbType.String, where);
            return DataAccess.DataAccess.GetData.Select<DbCommand>(db);
        }
        /// <summary>
        /// 根据u_id来查询该用户所属的角色
        /// </summary>
        /// <param name="u_id"></param>
        /// <returns></returns>
        public IList Admin_UR(int u_id)
        {
            DbCommand db = DataAccess.DataAccess.db.GetStoredProcCommand("Fm_Admin_UR");
            DataAccess.DataAccess.db.AddInParameter(db, "@u_id", DbType.Int16, u_id);
            return DataAccess.DataAccess.GetData.Select<DbCommand>(db);
        }
        /// <summary>
        /// 用户登陆验证
        /// </summary>
        /// <param name="username"></param>
        /// <param name="userpass"></param>
        /// <returns></returns>
        public IList Admin_Login(string username, string userpass)
        {
            DbCommand db = DataAccess.DataAccess.db.GetStoredProcCommand("Fm_Admin_Login");
            DataAccess.DataAccess.db.AddInParameter(db, "@username", DbType.String, username);
            DataAccess.DataAccess.db.AddInParameter(db, "@userpass", DbType.String, userpass);
            return DataAccess.DataAccess.GetData.Select<DbCommand>(db);
        }
    }
}
