using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Data;

namespace Fm.Bussiness
{
    public  class Xml_work
    {
        //캯
        public Xml_work()
        { }   
       
        public XmlDataDocument Create_doc(string xml_path)
        {
            //ʵXML
            XmlDataDocument doc = new XmlDataDocument();
            //XML ļ
            doc.Load(xml_path);
            return doc;
        }
        /// <summary>
        /// XMLļDataTableеķ
        /// </summary>
        /// <param name="xml_path"></param>
        /// <param name="rootNode"></param>
        /// <returns></returns>
        public DataTable Table_Create(string xml_path, string rootNode)
        {

            //ʵXML
            XmlDataDocument doc = Create_doc(xml_path);
            //DataTable ͵ıDT 洢ȡXML
            DataTable dt = new DataTable();
            //ȡڵ
            XmlNode root = doc.SelectSingleNode(rootNode);
            //ѭDT
            foreach (XmlNode node in root.ChildNodes)
            {
                if (node.Name != "#comment")
                {
                    dt.Columns.Add(node.Attributes["name"].Value, typeof(string));
                }
            }
            return dt;
        }
        /// <summary>
        /// XMLȡ
        /// </summary>
        /// <param name="xml_path">XMLļַ</param>
        /// <param name="rootNode">ڵ</param>
        /// <returns></returns>
        public DataTable Xml_Reader(string xml_path,string rootNode)
        {
            //ʵXML
            XmlDataDocument doc = Create_doc(xml_path);
            //DataTable ͵ıDT 洢ȡXML
            DataTable dt = new DataTable();
            //ȡڵ
            XmlNode root = doc.SelectSingleNode(rootNode);
            //
            DataRow row = dt.NewRow();
            //ѭDT
            foreach(XmlNode node in root.ChildNodes)
            {
                if (node.Name != "#comment")
                {
                    dt.Columns.Add(node.Attributes["name"].Value, typeof(string));
                    row[node.Attributes["name"].Value] =node.Attributes["value"].Value;
                }
            }
            dt.Rows.Add(row);
            return dt;
        }
        /// <summary>
        /// XMLݸ²
        /// </summary>
        /// <param name="xml_path">XML·</param>
        /// <param name="rootNode">XMLڵ</param>
        /// <param name="dt">ݸTable</param>
        public void Xml_Update(string xml_path, string rootNode,DataTable dt)
        {
            //ʵXML
            XmlDataDocument doc = Create_doc(xml_path);
            //ȡڵ
            XmlNode root = doc.SelectSingleNode(rootNode);
            //ѭ
            foreach (XmlNode node in root.ChildNodes)
            {
                if (node.Name != "#comment")
                {
                    node.Attributes["value"].Value = dt.Rows[0][node.Attributes["name"].Value].ToString();
                }
            }
            //Ѷ
            doc.Save(xml_path);
        }
    }
}
