using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Text.RegularExpressions;

namespace Fm.Tags
{
    public class Search
    {
        //ؼ
        private string keywords;

        public string Keywords
        {
            get { return keywords; }
            set { keywords = value; }
        }
        //ҳ
        private int pid;

        public int Pid
        {
            get { return pid; }
            set { pid = value; }
        }
        //ȡؼ
        private string GetWhere()
        {
            StringBuilder str = new StringBuilder();
            str.Append("(title like '%");
            str.Append(Keywords);
            str.Append("%'");
            str.Append(" or ");
            str.Append(" keyword like '%");
            str.Append(Keywords);
            str.Append("%')");

            return str.ToString();
        }
        //ȡ¼
        public int GetTotal()
        {
            Fm.Bussiness.Formpage page = new Fm.Bussiness.Formpage();
            //ѯ¼
            DataView total = page.PageRow("Fm_model_search_view", "docid", 10, 1, GetWhere()) as DataView;
            return  int.Parse(total[0]["total"].ToString());
        }
        //ҳ
        public string Page()
        {

            int rownum = GetTotal();
            /*ҳStart*************************/
          
            //int pagesize = 10;

            int rowcount = 0;
            //жҳ
            if (rownum % 10 == 0)
            {
                rowcount = rownum / 10;
            }
            else
            {
                rowcount = rownum / 10 + 1;
            }
            if (rowcount == 0)
            {
                rowcount = 1;
            }
            StringBuilder str = new StringBuilder();


            //ѭɷҳ
            for (int i = 1; i <= rowcount; i++)
            {
                StringBuilder s = new StringBuilder();
                if (pid > 9)
                {
                    if (i < (pid - 4) && i > 1)
                    {
                        continue;
                    }

                }
                if (i > (pid + 4) && i < rowcount)
                {
                    break;
                }
                //滻
                if (pid == i)
                {
                    s.Append(i);
                    s.Append("&nbsp;");
                }
                else 
                {
                    s.Append("<a href='/search/search.aspx?page=");
                    s.Append(i);
                    s.Append("&");
                    s.Append("kw=");
                    s.Append(Keywords);
                    s.Append("'");
                    s.Append(">[");
                    s.Append(i);
                    s.Append("]</a>&nbsp;");
                }
                str.Append(s);
            }
            return str.ToString();
        }
        public DataTable PageBind()
        {
            Fm.Bussiness.Formpage page=new Fm.Bussiness.Formpage();
            DataView dv = page.PageView_Bywhere("Fm_model_search_view", "docid", 10, Pid, GetWhere()) as DataView;

            //ʵDataTable
            DataTable dt = new DataTable();
            dt.Columns.Add(new DataColumn("title",typeof(string)));
            dt.Columns.Add(new DataColumn("intro",typeof(string)));
            dt.Columns.Add(new DataColumn("url",typeof(string)));
            dt.Columns.Add(new DataColumn("time",typeof(string)));
            dt.Columns.Add(new DataColumn("total",typeof(int)));

            foreach (DataRow row in dv.Table.Rows)
            {
                //ַ
                string url = "";
                if (row["html"].ToString().ToLower() == "true")
                {
                    url =  row["path"].ToString();
                }
                else
                {
                    url = "/article.aspx?docid=" + row["docid"].ToString();
                }
                string title = row["title"].ToString();
               
                //
                DataRow NewRow = dt.NewRow();
                NewRow["title"] = title.Replace(Keywords, "<font color='red'>" + Keywords + "</font>");
                
                NewRow["intro"] = row["intro"].ToString();
                //NewRow["intro"] = NewRow["intro"].ToString().Replace(Keywords, "<font color='red'>" + Keywords + "</font>");

                NewRow["url"] = url;
                NewRow["time"] = DateTime.Parse(row["writertime"].ToString()).ToShortDateString();

                //ͳ
                Regex r = new Regex(@"("+Keywords+")", RegexOptions.Compiled | RegexOptions.IgnoreCase);
                NewRow["total"] = r.Matches(title).Count;

                //
                dt.Rows.Add(NewRow);
            }
            dt.DefaultView.Sort = "total desc";

            return dt;
        }
    }
}
