﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Fm.Bussiness;

public partial class Admin_art_class_edit : BasePage
{
  

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {    
            //用来存储栏目信息
            DataTable dt = new DataTable();
            public_select ps = new public_select();//实例化公共查询类
            //创建DT类的列
            DataColumn dc = new DataColumn();
            dc.ColumnName = "cl_name";
            dt.Columns.Add(dc);
            DataColumn dc1 = new DataColumn();
            dc1.ColumnName = "cl_parent";
            dt.Columns.Add(dc1);
            if (Request.QueryString["cl_id"] != null)
            {

                int cl_id=int.Parse(Request.QueryString["cl_id"].ToString());
                DataView dv1 = ps.Getps("Fm_column","*","cl_id="+cl_id+"");

                //栏目ID
                Lab_id.Text = cl_id.ToString();
                //保存原来的栏目PARENT
                ViewState["parent"] = dv1[0]["cl_parent"].ToString();
                //绑定栏目数据
                ListBind(dt);
                //给栏目下拉列表控件绑定数据源
                Drop_parent.DataSource = dt;
                Drop_parent.DataTextField = "cl_name";
                Drop_parent.DataValueField = "cl_parent";
                Drop_parent.DataBind();
                //绑定修改栏目的信息
                //基本信息绑定
                cl_name.Text = dv1[0]["cl_name"].ToString();

                //是否允许投稿
                foreach (ListItem tg in Radio_tg.Items)
                {
                    if (tg.Value == dv1[0]["cl_tg"].ToString().ToLower())
                    {
                        tg.Selected = true;
                    }
                }
                //是否前台显示
                foreach (ListItem xs in Radio_xs.Items)
                {
                    if (xs.Value == dv1[0]["cl_xs"].ToString().ToLower())
                    {
                        xs.Selected = true;
                    }
                }
                cl_path.Text = dv1[0]["cl_path"].ToString();

                //目录相对位置
                foreach (ListItem location in Radio_location.Items)
                {
                    if (location.Value == dv1[0]["cl_location"].ToString().ToLower())
                    {
                        location.Selected = true;
                    }
                }
              
                //栏目属性
                foreach (ListItem att in Radio_attribute.Items)
                {
                    if (att.Value == dv1[0]["cl_attribute"].ToString())
                    {
                        att.Selected = true;
                    }
                }
                //列表选项
                foreach (ListItem options in Radio_options.Items)
                {
                    if (options.Value == dv1[0]["cl_options"].ToString())
                    {
                        options.Selected = true;
                    }
                }
               
                //栏目循环显示
                ListItem item=new ListItem();
                item.Text = "无上级栏目";
                item.Value = "00";
                Drop_parent.Items.Insert(0, item);
              
                foreach (ListItem pr in Drop_parent.Items)
                {
                    if (dv1[0]["cl_parent"].ToString().Substring(0,dv1[0]["cl_parent"].ToString().Length-2) == pr.Value&&dv1[0]["cl_parent"].ToString().Length!=2)
                    {
                        pr.Selected = true;
                    }
                }

                //高级栏目属性
                txt_temp_index.Text = dv1[0]["cl_temp_index"].ToString();
                txt_temp_list.Text = dv1[0]["cl_temp_list"].ToString();
                txt_temp_cont.Text = dv1[0]["cl_temp_cont"].ToString();

                def.Text = dv1[0]["cl_default"].ToString();
                txt_content.Text = dv1[0]["cl_content"].ToString();
                txt_list.Text = dv1[0]["cl_list"].ToString();

                cl_url.Text = dv1[0]["cl_url"].ToString();

           

                cl_px.Text = dv1[0]["cl_px"].ToString();

                cl_keyword.Text = dv1[0]["cl_keyword"].ToString();
                cl_intro.Text = dv1[0]["cl_intro"].ToString();

                parentpath.Text = ps.Getps("Fm_webset", "html", "")[0]["html"].ToString();
 
            }
        }
    }
    //绑定一级栏目
    void ListBind(DataTable dt)
    {
        public_select ps = new public_select();
        //查询出栏目信息
        DataView dv = ps.Getps("Fm_column", "cl_name,cl_parent,cl_id", "cl_id<>0 order by cl_px asc");
        foreach (DataRow dr in dv.Table.Rows)
        {
            if (dr["cl_id"].ToString() != Request.QueryString["cl_id"].ToString())
            {
                if (dr["cl_parent"].ToString().Length == 2)
                {
                
                    //把数据存入新行中
                    DataRow row = dt.NewRow();
                    row["cl_name"] = dr["cl_name"].ToString();
                    row["cl_parent"] = dr["cl_parent"].ToString();
                    dt.Rows.Add(row);
                    //调用子栏目绑定方法
                    SubListBind(dr["cl_parent"].ToString(),dt,dv);
                }
            }
        }
    }
    //绑定子栏目
    void SubListBind(string parent,DataTable dt,DataView dv)
    {
        foreach (DataRow dr in dv.Table.Rows)
        {
            if (dr["cl_id"].ToString() != Request.QueryString["cl_id"].ToString())
            {
                if (dr["cl_parent"].ToString().Length == parent.Length + 2 && dr["cl_parent"].ToString().Substring(0, parent.Length) == parent)
                {
                    //栏目区分符
                    string nbsp = "";
                    for (int i = 1; i <= dr["cl_parent"].ToString().Length / 2; i++)
                    {
                        nbsp += Server.HtmlDecode("&nbsp;").ToString();
                    }
                    //把子栏目数据存入新行中
                    DataRow row = dt.NewRow();
                    row["cl_name"] = nbsp + "├" + dr["cl_name"].ToString();
                    row["cl_parent"] = dr["cl_parent"].ToString();
                    dt.Rows.Add(row);
                    //递归调用
                    SubListBind(dr["cl_parent"].ToString(),dt,dv);
                }

            }
        }
    }
    //保存修改的数据
    protected void ImageButton1_Click(object sender, ImageClickEventArgs e)
    {
       
        //获取值
        int cl_id = 0;
        if (Request.QueryString["cl_id"] != null)
        {
            cl_id = int.Parse(Request.QueryString["cl_id"].ToString());
        }
        public_select ps = new public_select();//实例化公共查询类

        DataView dv1 = ps.Getps("Fm_column", "*", "cl_id=" + cl_id + "");//查询栏目信息

        Fm.EntityClass.Column col = new Fm.EntityClass.Column();
        col.cl_id = cl_id;
        col.cl_name = cl_name.Text;
        //col.cl_model = int.Parse(Drop_model.SelectedValue);
        col.cl_tg = bool.Parse(Radio_tg.SelectedValue);
        col.cl_xs = bool.Parse(Radio_xs.SelectedValue);
        if (Radio_location.SelectedValue == "true")
        {
            if (cl_path.Text.Substring(0, 5).Contains("html/"))
            {
                col.cl_path = cl_path.Text;
            }
            else
            {
                col.cl_path = parentpath.Text + cl_path.Text;
            }
        }
        else
        {
            col.cl_path = cl_path.Text;
        }
        col.cl_location = bool.Parse(Radio_location.SelectedValue);
        col.cl_attribute = int.Parse(Radio_attribute.SelectedValue);
        col.cl_options = int.Parse(Radio_options.SelectedValue);

        col.cl_temp_index = txt_temp_index.Text;
        col.cl_temp_list = txt_temp_list.Text;
        col.cl_temp_cont = txt_temp_cont.Text;

        col.cl_list = txt_list.Text;
        col.cl_content = txt_content.Text;
        col.cl_default = def.Text;

        col.cl_url = cl_url.Text;
        col.cl_keyword = cl_keyword.Text;
        col.cl_intro = cl_intro.Text;
        
        col.cl_px = int.Parse(cl_px.Text);
        col.cl_parent = dv1[0]["cl_parent"].ToString();
        /*栏目移动功能代码开始(无效果)*/
        //string parent=dv1[0]["cl_parent"].ToString();
        //上级编号处理
        //if ((parent.Length==2&& Drop_parent.SelectedValue.Length==2)||(parent.Substring(0,parent.Length-2)==Drop_parent.SelectedValue))
        //{
            
        //}
        //else
        //{
        //    //判断选择的是不是一级栏目
        //    if (Drop_parent.SelectedValue == "00")
        //    {
        //        GetParent("");

        //    }
        //    else
        //    {
        //        GetParent(Drop_parent.SelectedValue);

        //    }
        //    col.cl_parent = ViewState["code"].ToString();
        //    //并且更改子栏目上级栏目ID
        //    //SubListUpdate(ViewState["parent"].ToString());

        //}
        /*栏目移动功能代码结束*/
        //先查询出修改前栏目的路径
   
        //执行修改
        sys_column sys = new sys_column();
        if (sys.Column_update(col))
        {
            //在没有选择外部链接的情况下移动栏目路径
            if (Radio_attribute.SelectedValue != "2")
            {
                if (Radio_options.SelectedValue != "2")
                {
                    
                    ATL.IO.IOStream stream = new ATL.IO.IOStream();
                    string path = Server.MapPath("../");
                    //如果原有目录为空,则按新的目录建立不调用移动目录的方法
                    System.IO.DirectoryInfo folder = new System.IO.DirectoryInfo(path+dv1[0]["cl_path"].ToString());
                    if (folder.Exists)
                    {
                        stream.FolderMoveTo(path + dv1[0]["cl_path"].ToString(), path + col.cl_path);
                    }
                    else
                    {
                        stream.CreateFolder(path+col.cl_path);
                    }
                }
            }
        

            Response.Redirect("Erro.aspx?eid=该栏目信息修改成功!&url=art_column_list.aspx",false);

        }
    }
/*************************************************栏目修改相关方法(启用栏目修改功能需要修改这些)***************************************************/
    //子栏目上级编号的更改
    void SubListUpdate(string parent)
    {
        public_select ps = new public_select();//实例化公共查询类
        DataView dw = ps.Getps("Fm_column","cl_id,cl_parent","cl_parent like '"+parent+"%'");
        Fm.EntityClass.Column col = new Fm.EntityClass.Column();
        
        foreach (DataRow dr in dw.Table.Rows)
        {
            if (dr["cl_parent"].ToString() != parent)
            { 
                //获取新的子栏目Parent
                GetParent(ViewState["code"].ToString()); 
                col.cl_id=int.Parse(dr["cl_id"].ToString());
                col.cl_parent=ViewState["code"].ToString();
                //Response.Write("  "+ViewState["code"].ToString()+"  ");
               
                Response.Write(ViewState["code"].ToString());
                //修改子栏目上级编号
                sys_column sys = new sys_column();
                //sys.Column_Parent_Update(col);
            }
        }
    }
    //判断是否已有的方法
    void GetParent(string parent)
    {

        public_select ps = new public_select();//实例化公共查询类
        ViewState["code"] = "";
        //调用生成方法
        string random = GetRandom();
        string sqlstr = "";
        //查询表中已有的一级栏目区分编号，用来判断新产生的编号是否已经存在
        if (parent == "")
        {
            sqlstr = "cl_parent='" + random + "'";
        }
        else
        {
            sqlstr = "cl_parent='" + parent + random + "'";
        }
        DataView dw = ps.Getps("Fm_column","cl_parent",sqlstr);
        if (dw.Count > 0)
        {
            GetParent(parent);
        }
        else
        {
            ViewState["code"] = parent + random;
        }

    }
    //生成区分编号的方法
    string GetRandom()
    {
        string str = new Random().Next(1, 99).ToString();
        if (str.Length == 1)
        {
            str = "0" + str;

        }
        return str;
    }
}
