/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.launcher;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.ArrayList;

public class Launcher {
    private static final int IOBUFFERSIZE = 4096;

    public static void main(String[] args) {
        try {
            String arch = "x86";
            String osName = System.getProperty("os.name").toLowerCase();
            String os = "unknown";
            if (-1 != System.getProperty("os.arch").indexOf("64")) {
                arch = "x86_64";
            }
            if (-1 != osName.indexOf("linux")) {
                os = "gtk-linux";
            } else if (-1 != osName.indexOf("windows")) {
                os = "win32-win32";
            } else if (-1 != osName.indexOf("mac")) {
                os = "cocoa-macosx";
            }
            CodeSource cs = Launcher.class.getProtectionDomain().getCodeSource();
            String installlocation = cs.getLocation().toURI().toString().replaceAll("launcher\\.jar$", "");
            System.out.println("launching FullSync... OS=" + os + "; ARCH=" + arch + "; INSTALLLOCATION=" + installlocation);
            ArrayList<URL> jars = new ArrayList<URL>();
            jars.add(new URL(installlocation + "lib/fullsync.jar"));
            jars.add(new URL(installlocation + "lib/swt-" + os + "-" + arch + ".jar"));
            String dependencies = Launcher.getResourceAsString("net/sourceforge/fullsync/launcher/dependencies.txt");
            for (String s : dependencies.split("\r?\n")) {
                jars.add(new URL(installlocation + "lib/" + s.trim()));
            }
            URLClassLoader cl = new URLClassLoader(jars.toArray(new URL[jars.size()]), Launcher.class.getClassLoader());
            Class<?> cls = cl.loadClass("net.sourceforge.fullsync.cli.Main");
            Method main = cls.getDeclaredMethod("main", String[].class);
            Thread.currentThread().setContextClassLoader(cl);
            main.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResourceAsString(String name) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
        if (null != is) {
            try {
                char[] buffer = new char[4096];
                StringBuilder out = new StringBuilder();
                try {
                    int read;
                    InputStreamReader in = new InputStreamReader(is, "UTF-8");
                    do {
                        if ((read = ((Reader)in).read(buffer, 0, buffer.length)) <= 0) continue;
                        out.append(buffer, 0, read);
                    } while (read >= 0);
                    String string = out.toString().trim();
                    return string;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        is.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }
}

