/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;

public class FileObjectDataSource
implements DataSource {
    private final FileObject fo;

    public FileObjectDataSource(FileObject fo) {
        this.fo = fo;
    }

    public InputStream getInputStream() throws IOException {
        return this.fo.getContent().getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.fo.getContent().getOutputStream();
    }

    public String getContentType() {
        try {
            return this.fo.getContent().getContentInfo().getContentType();
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.fo.getName().getBaseName();
    }
}

