/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync;

import java.io.Serializable;
import net.sourceforge.fullsync.BufferUpdate;
import net.sourceforge.fullsync.Location;

public class Action
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final int Nothing = 0;
    public static final int Add = 1;
    public static final int Update = 2;
    public static final int Delete = 3;
    public static final int NotDecidableError = 10;
    public static final int UnexpectedChangeError = 11;
    public static final int DirHereFileThereError = 12;
    public static final String[] names = new String[]{"Nothing", "Add", "Update", "Delete"};
    public static final String[] errorNames = new String[]{"NotDecidableError", "UnexpectedChangeError", "DirHereFileThereError"};
    private int type;
    private int location;
    private int bufferUpdate;
    private boolean beforeRecursion;
    private String explanation;

    public Action(int type, int location, int bufferUpdate, String explanation) {
        this(type, location, bufferUpdate, explanation, true);
    }

    public Action(int type, int location, int bufferUpdate, String explanation, boolean beforeRecursion) {
        this.type = type;
        this.location = location;
        this.bufferUpdate = bufferUpdate;
        this.beforeRecursion = beforeRecursion;
        this.explanation = explanation;
    }

    public int getType() {
        return this.type;
    }

    public int getLocation() {
        return this.location;
    }

    public int getBufferUpdate() {
        return this.bufferUpdate;
    }

    public boolean isBeforeRecursion() {
        return this.beforeRecursion;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public boolean isError() {
        return this.type >= 10;
    }

    public static String toString(int type) {
        if (type >= 10) {
            return errorNames[type - 10];
        }
        return names[type];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[" + Action.toString(this.getType()) + "(" + Location.toString(this.getLocation()) + ") BU: ");
        sb.append(BufferUpdate.toString(this.getBufferUpdate()) + "; Rec: ");
        sb.append(this.isBeforeRecursion());
        sb.append(" - " + this.explanation + "]");
        return sb.toString();
    }

    public boolean equalsExceptExplanation(Action action) {
        return this.getType() == action.getType() && this.getLocation() == action.getLocation() && this.getBufferUpdate() == action.getBufferUpdate() && this.isBeforeRecursion() == action.isBeforeRecursion();
    }
}

