/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import net.sourceforge.fullsync.Crypt;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConnectionDescription
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final String PARAMETER_USERNAME = "username";
    public static final String PARAMETER_PASSWORD = "password";
    public static final String PARAMETER_INTERACTIVE = "interactive";
    private URI uri = null;
    private Hashtable<String, String> parameters = new Hashtable();
    private Hashtable<String, String> secretParameters = new Hashtable();

    public Element serialize(String name, Document doc) {
        Element p;
        Element elem = doc.createElement(name);
        elem.setAttribute("uri", this.uri.toString());
        for (String key : this.parameters.keySet()) {
            if (PARAMETER_USERNAME.equals(key)) {
                elem.setAttribute(PARAMETER_USERNAME, this.parameters.get(key));
                continue;
            }
            if ("bufferStrategy".equals(key)) {
                elem.setAttribute("buffer", this.parameters.get(key));
                continue;
            }
            p = doc.createElement("Param");
            p.setAttribute("name", key);
            p.setAttribute("value", this.parameters.get(key));
            elem.appendChild(p);
        }
        for (String key : this.secretParameters.keySet()) {
            if (PARAMETER_PASSWORD.equals(key)) {
                elem.setAttribute(PARAMETER_PASSWORD, this.secretParameters.get(key));
                continue;
            }
            p = doc.createElement("SecretParam");
            p.setAttribute("name", key);
            p.setAttribute("value", this.secretParameters.get(key));
            elem.appendChild(p);
        }
        return elem;
    }

    public static ConnectionDescription unserialize(Element element) {
        ConnectionDescription desc = new ConnectionDescription(null);
        try {
            desc.setUri(new URI(element.getAttribute("uri")));
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
        desc.parameters.put("bufferStrategy", element.getAttribute("buffer"));
        desc.parameters.put(PARAMETER_USERNAME, element.getAttribute(PARAMETER_USERNAME));
        desc.secretParameters.put(PARAMETER_PASSWORD, element.getAttribute(PARAMETER_PASSWORD));
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Element e;
            Node n = list.item(i);
            if (n.getNodeType() == 1 && "Param".equals(n.getNodeName())) {
                e = (Element)n;
                desc.parameters.put(e.getAttribute("name"), e.getAttribute("value"));
            }
            if (n.getNodeType() != 1 || !"SecretParam".equals(n.getNodeName())) continue;
            e = (Element)n;
            desc.secretParameters.put(e.getAttribute("name"), e.getAttribute("value"));
        }
        return desc;
    }

    public ConnectionDescription(URI uri) {
        this.uri = uri;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public void clearParameter(String name) {
        this.parameters.remove(name);
    }

    public String getSecretParameter(String name) {
        return Crypt.decrypt(this.secretParameters.get(name));
    }

    public final void setSecretParameter(String name, String value) {
        this.secretParameters.put(name, Crypt.encrypt(value));
    }

    public String toString() {
        return this.uri.toString();
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getDisplayPath() {
        if ("file".equals(this.uri.getScheme())) {
            File f = new File(this.uri);
            try {
                return f.getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.uri.toString();
    }
}

