/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync;

import net.sourceforge.fullsync.NestedException;

public class DataParseException
extends NestedException {
    private static final long serialVersionUID = 2L;
    String sourceName = "unknown";
    long linenumber = -1L;

    public DataParseException(String text) {
        super(text);
    }

    public DataParseException(String text, long linenumber) {
        this(text);
        this.setLinenumber(linenumber);
    }

    public DataParseException(String text, long linenumber, String sourcename) {
        this(text, linenumber);
        this.setSourceName(sourcename);
    }

    public DataParseException(Throwable cause) {
        super(cause);
    }

    public DataParseException(Throwable cause, long linenumber) {
        this(cause);
        this.setLinenumber(linenumber);
    }

    public DataParseException(String text, Throwable cause) {
        super(text, cause);
    }

    public DataParseException(String text, Throwable cause, int lineno, String source) {
        this(text, cause);
        this.setLinenumber(lineno);
        this.setSourceName(source);
    }

    @Override
    public String getMessage() {
        return this.sourceName + "[" + this.linenumber + "]: " + super.getMessage();
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public long getLinenumber() {
        return this.linenumber;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public void setLinenumber(long linenumber) {
        this.linenumber = linenumber;
    }
}

