/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync;

public abstract class ExceptionHandler {
    private static ExceptionHandler singleton = new ExceptionHandler(){

        @Override
        protected void doReportException(String message, Throwable exception) {
            exception.printStackTrace();
        }
    };

    public static ExceptionHandler registerExceptionHandler(ExceptionHandler handler) {
        ExceptionHandler temp = singleton;
        singleton = handler;
        return temp;
    }

    public static void reportException(Throwable exception) {
        if (singleton != null) {
            singleton.doReportException("An exception occured:\n" + exception.getMessage(), exception);
        }
    }

    public static void reportException(String message, Throwable exception) {
        if (singleton != null) {
            singleton.doReportException(message, exception);
        }
    }

    protected abstract void doReportException(String var1, Throwable var2);
}

