/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import net.sourceforge.fullsync.ConnectionDescription;
import net.sourceforge.fullsync.FileSystemException;
import net.sourceforge.fullsync.fs.FileSystem;
import net.sourceforge.fullsync.fs.Site;
import net.sourceforge.fullsync.fs.buffering.BufferingProvider;
import net.sourceforge.fullsync.fs.buffering.syncfiles.SyncFilesBufferingProvider;
import net.sourceforge.fullsync.fs.filesystems.FTPFileSystem;
import net.sourceforge.fullsync.fs.filesystems.LocalFileSystem;
import net.sourceforge.fullsync.fs.filesystems.SFTPFileSystem;
import net.sourceforge.fullsync.fs.filesystems.SmbFileSystem;

public class FileSystemManager {
    private Hashtable<String, FileSystem> schemes = new Hashtable();
    private Hashtable<String, SyncFilesBufferingProvider> buffering;

    public FileSystemManager() {
        this.schemes.put("file", new LocalFileSystem());
        this.schemes.put("ftp", new FTPFileSystem());
        this.schemes.put("sftp", new SFTPFileSystem());
        this.schemes.put("smb", new SmbFileSystem());
        this.buffering = new Hashtable();
        this.buffering.put("syncfiles", new SyncFilesBufferingProvider());
    }

    public final Site createConnection(ConnectionDescription desc) throws FileSystemException, IOException, URISyntaxException {
        FileSystem fs = null;
        URI url = desc.getUri();
        String scheme = url.getScheme();
        if (scheme != null) {
            fs = this.schemes.get(scheme);
        }
        if (fs == null) {
            File f = new File(url.toString());
            if (f.exists()) {
                fs = this.schemes.get("file");
                url = f.toURI();
                desc.setUri(url);
            } else {
                throw new URISyntaxException(url.toString(), "Not a valid uri or unknown scheme");
            }
        }
        Site s = fs.createConnection(desc);
        return s;
    }

    public Site resolveBuffering(Site dir, String bufferStrategy) throws FileSystemException, IOException {
        BufferingProvider p = this.buffering.get(bufferStrategy);
        if (p == null) {
            throw new FileSystemException("BufferStrategy '" + bufferStrategy + "' not found");
        }
        return p.createBufferedSite(dir);
    }
}

