/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import net.sourceforge.fullsync.ConnectionDescription;
import net.sourceforge.fullsync.ProfileChangeListener;
import net.sourceforge.fullsync.RuleSetDescriptor;
import net.sourceforge.fullsync.impl.SimplyfiedRuleSetDescriptor;
import net.sourceforge.fullsync.schedule.Schedule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Profile
implements Serializable,
Comparable<Profile> {
    private static final long serialVersionUID = 3L;
    private String name;
    private String description;
    private String synchronizationType;
    private ConnectionDescription source;
    private ConnectionDescription destination;
    private RuleSetDescriptor ruleSet;
    private Date lastUpdate;
    private Schedule schedule;
    private boolean enabled;
    private int lastErrorLevel;
    private String lastErrorString;
    private transient boolean eventsAllowed;
    private transient ArrayList<ProfileChangeListener> listeners;

    static Profile unserialize(Element element) {
        Profile p = new Profile(element.getAttribute("name"), ConnectionDescription.unserialize((Element)element.getElementsByTagName("Source").item(0)), ConnectionDescription.unserialize((Element)element.getElementsByTagName("Destination").item(0)), RuleSetDescriptor.unserialize((Element)element.getElementsByTagName("RuleSetDescriptor").item(0)));
        if (null == p.getRuleSet()) {
            p.setLastError(-1, "Error: the Filters of this Profile are broken");
            p.setRuleSet(new SimplyfiedRuleSetDescriptor(true, null, false, null));
        }
        p.setDescription(element.getAttribute("description"));
        p.setSynchronizationType(element.getAttribute("type"));
        if (element.hasAttribute("enabled")) {
            p.setEnabled(Boolean.valueOf(element.getAttribute("enabled")));
        }
        if (element.hasAttribute("lastErrorLevel")) {
            p.setLastError(Integer.parseInt(element.getAttribute("lastErrorLevel")), element.getAttribute("lastErrorString"));
        }
        try {
            Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            c.setTimeInMillis(Integer.parseInt(element.getAttribute("lastUpdate")));
            p.setLastUpdate(c.getTime());
        }
        catch (NumberFormatException e) {
            p.setLastUpdate(null);
        }
        p.setSchedule(Schedule.unserialize((Element)element.getElementsByTagName("Schedule").item(0)));
        return p;
    }

    public Profile(String name, ConnectionDescription source, ConnectionDescription destination, RuleSetDescriptor ruleSet) {
        this.name = name;
        this.description = "";
        this.source = source;
        this.destination = destination;
        this.ruleSet = ruleSet;
        this.lastUpdate = new Date();
        this.listeners = new ArrayList();
        this.enabled = true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.notifyProfileChangeListeners();
    }

    public String getSynchronizationType() {
        return this.synchronizationType;
    }

    public void setSynchronizationType(String synchronizationType) {
        this.synchronizationType = synchronizationType;
        this.notifyProfileChangeListeners();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.notifyProfileChangeListeners();
    }

    public ConnectionDescription getDestination() {
        return this.destination;
    }

    public void setDestination(ConnectionDescription destination) {
        this.destination = destination;
        this.notifyProfileChangeListeners();
    }

    public ConnectionDescription getSource() {
        return this.source;
    }

    public void setSource(ConnectionDescription source) {
        this.source = source;
        this.notifyProfileChangeListeners();
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
        this.notifyProfileChangeListeners();
    }

    public String getLastUpdateText() {
        if (this.lastUpdate == null) {
            return "never";
        }
        return DateFormat.getDateTimeInstance().format(this.lastUpdate);
    }

    public String getNextUpdateText() {
        if (this.schedule == null) {
            return "not scheduled";
        }
        if (!this.enabled) {
            return "not enabled";
        }
        return DateFormat.getDateTimeInstance().format(new Date(this.schedule.getNextOccurrence(new Date().getTime())));
    }

    public RuleSetDescriptor getRuleSet() {
        return this.ruleSet;
    }

    public void setRuleSet(RuleSetDescriptor ruleSet) {
        this.ruleSet = ruleSet;
        this.notifyProfileChangeListeners();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.notifyProfileChangeListeners();
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
        this.notifyProfileChangeListeners();
    }

    public void setLastError(int lastErrorLevel, String lastErrorString) {
        this.lastErrorLevel = lastErrorLevel;
        this.lastErrorString = lastErrorString;
        this.notifyProfileChangeListeners();
    }

    public int getLastErrorLevel() {
        return this.lastErrorLevel;
    }

    public String getLastErrorString() {
        return this.lastErrorString;
    }

    public void addProfileChangeListener(ProfileChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeProfileChangeListener(ProfileChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyProfileChangeListeners() {
        if (this.eventsAllowed) {
            for (ProfileChangeListener listener : this.listeners) {
                listener.profileChanged(this);
            }
        }
    }

    public void beginUpdate() {
        this.eventsAllowed = false;
    }

    public void endUpdate() {
        this.eventsAllowed = true;
        this.notifyProfileChangeListeners();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.name);
        out.writeObject(this.description);
        out.writeObject(this.synchronizationType);
        out.writeObject(this.source);
        out.writeObject(this.destination);
        out.writeObject(this.ruleSet);
        out.writeObject(this.lastUpdate);
        out.writeObject(this.schedule);
        out.writeBoolean(this.enabled);
        out.writeInt(this.lastErrorLevel);
        out.writeObject(this.lastErrorString);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.name = (String)in.readObject();
        this.description = (String)in.readObject();
        this.synchronizationType = (String)in.readObject();
        this.source = (ConnectionDescription)in.readObject();
        this.destination = (ConnectionDescription)in.readObject();
        this.ruleSet = (RuleSetDescriptor)in.readObject();
        this.lastUpdate = (Date)in.readObject();
        this.schedule = (Schedule)in.readObject();
        this.enabled = in.readBoolean();
        this.lastErrorLevel = in.readInt();
        this.lastErrorString = (String)in.readObject();
        this.listeners = new ArrayList();
    }

    public Element serialize(Document doc) {
        Element elem = doc.createElement("Profile");
        elem.setAttribute("name", this.name);
        elem.setAttribute("description", this.description);
        elem.setAttribute("type", this.synchronizationType);
        elem.setAttribute("enabled", String.valueOf(this.enabled));
        elem.setAttribute("lastErrorLevel", String.valueOf(this.lastErrorLevel));
        elem.setAttribute("lastErrorString", this.lastErrorString);
        if (null != this.lastUpdate) {
            elem.setAttribute("lastUpdate", Long.valueOf(this.lastUpdate.getTime()).toString());
        }
        elem.appendChild(RuleSetDescriptor.serialize(this.ruleSet, doc));
        if (null != this.schedule) {
            elem.appendChild(Schedule.serialize(this.schedule, doc));
        }
        if (null != this.source) {
            elem.appendChild(this.source.serialize("Source", doc));
        }
        if (null != this.destination) {
            elem.appendChild(this.destination.serialize("Destination", doc));
        }
        return elem;
    }

    @Override
    public int compareTo(Profile o) {
        return ("" + this.name).compareTo(o.getName());
    }
}

