/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.Profile;
import net.sourceforge.fullsync.ProfileChangeListener;
import net.sourceforge.fullsync.ProfileListChangeListener;
import net.sourceforge.fullsync.ProfileSchedulerListener;
import net.sourceforge.fullsync.Util;
import net.sourceforge.fullsync.remote.RemoteManager;
import net.sourceforge.fullsync.schedule.Schedule;
import net.sourceforge.fullsync.schedule.ScheduleTask;
import net.sourceforge.fullsync.schedule.ScheduleTaskSource;
import net.sourceforge.fullsync.schedule.Scheduler;
import net.sourceforge.fullsync.schedule.SchedulerChangeListener;
import net.sourceforge.fullsync.schedule.SchedulerImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ProfileManager
implements ProfileChangeListener,
ScheduleTaskSource,
SchedulerChangeListener {
    private String configFile;
    private Vector<Profile> profiles = new Vector();
    private Vector<ProfileListChangeListener> changeListeners = new Vector();
    private Vector<ProfileSchedulerListener> scheduleListeners = new Vector();
    private boolean remoteConnected = false;
    private Vector<SchedulerChangeListener> schedulerChangeListeners = new Vector();
    private Scheduler scheduler = new SchedulerImpl(this);
    private RemoteManager remoteManager;
    private ProfileListChangeListener remoteListener;

    protected ProfileManager() {
        this.scheduler.addSchedulerChangeListener(this);
    }

    public ProfileManager(String configFile) throws SAXException, IOException, ParserConfigurationException, FactoryConfigurationError {
        this();
        this.configFile = configFile;
        this.loadProfiles(configFile);
        Collections.sort(this.profiles);
    }

    public void setRemoteConnection(RemoteManager remoteManager) throws MalformedURLException, RemoteException, NotBoundException {
        this.remoteManager = remoteManager;
        this.remoteListener = new ProfileListChangeListener(){

            @Override
            public void profileListChanged() {
                ProfileManager.this.updateRemoteProfiles();
            }

            @Override
            public void profileChanged(Profile p) {
                ProfileManager.this.updateRemoteProfiles();
            }
        };
        remoteManager.addProfileListChangeListener(this.remoteListener);
        remoteManager.addSchedulerChangeListener(this);
        this.updateRemoteProfiles();
        this.fireSchedulerChangedEvent();
    }

    private void updateRemoteProfiles() {
        Profile[] remoteprofiles;
        this.profiles = new Vector();
        for (Profile remoteprofile : remoteprofiles = this.remoteManager.getProfiles()) {
            this.profiles.add(remoteprofile);
            remoteprofile.addProfileChangeListener(this);
        }
        this.fireProfilesChangeEvent();
    }

    public void disconnectRemote() {
        if (this.remoteManager != null) {
            try {
                this.remoteManager.removeProfileListChangeListener(this.remoteListener);
                this.remoteManager.removeSchedulerChangeListener(this);
            }
            catch (RemoteException e) {
                ExceptionHandler.reportException(e);
            }
            this.remoteManager = null;
            this.profiles = new Vector();
            try {
                this.loadProfiles(this.configFile);
            }
            catch (Exception e) {
                ExceptionHandler.reportException(e);
            }
            this.remoteConnected = false;
            this.fireProfilesChangeEvent();
        }
    }

    public final boolean isConnected() {
        return this.remoteManager != null;
    }

    public final boolean isConnectedToRemoteInstance() {
        return this.remoteConnected;
    }

    public boolean loadProfiles(String profilesFileName) throws SAXException, IOException, ParserConfigurationException, FactoryConfigurationError {
        File file = new File(profilesFileName);
        if (file.exists() && file.length() > 0L) {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(file);
            NodeList list = doc.getDocumentElement().getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                if (n.getNodeType() != 1) continue;
                try {
                    Profile p = Profile.unserialize((Element)n);
                    String name = p.getName();
                    int j = 1;
                    while (null != this.getProfile(name)) {
                        name = p.getName() + " (" + j++ + ")";
                    }
                    p.setName(name);
                    this.doAddProfile(p, false);
                    continue;
                }
                catch (Throwable t) {
                    ExceptionHandler.reportException("Failed to load a Profile, ignoring and continuing with the rest", t);
                }
            }
            this.fireProfilesChangeEvent();
            return true;
        }
        return false;
    }

    private void doAddProfile(Profile profile, boolean fireChangedEvent) {
        this.profiles.add(profile);
        profile.addProfileChangeListener(this);
        if (fireChangedEvent) {
            this.fireProfilesChangeEvent();
        }
    }

    public void addProfile(Profile profile) {
        this.doAddProfile(profile, true);
    }

    public void removeProfile(Profile profile) {
        profile.removeProfileChangeListener(this);
        this.profiles.remove(profile);
        this.fireProfilesChangeEvent();
    }

    public Vector<Profile> getProfiles() {
        return this.profiles;
    }

    public Profile getProfile(String name) {
        for (Profile p : this.profiles) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public void startScheduler() {
        if (this.remoteManager != null) {
            this.remoteManager.startTimer();
        } else {
            this.scheduler.start();
        }
    }

    public void stopScheduler() {
        if (this.remoteManager != null) {
            this.remoteManager.stopTimer();
        } else {
            this.scheduler.stop();
        }
    }

    public boolean isSchedulerEnabled() {
        if (this.remoteManager != null) {
            return this.remoteManager.isSchedulerEnabled();
        }
        return this.scheduler.isEnabled();
    }

    @Override
    public ScheduleTask getNextScheduleTask() {
        long now = System.currentTimeMillis();
        long nextTime = Long.MAX_VALUE;
        Profile nextProfile = null;
        for (Profile p : this.profiles) {
            long o;
            Schedule s = p.getSchedule();
            if (!p.isEnabled() || s == null || nextTime <= (o = s.getNextOccurrence(now))) continue;
            nextTime = o;
            nextProfile = p;
        }
        if (nextProfile != null) {
            return new ProfileManagerSchedulerTask(nextProfile, nextTime);
        }
        return null;
    }

    public void addProfilesChangeListener(ProfileListChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeProfilesChangeListener(ProfileListChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    protected void fireProfilesChangeEvent() {
        for (ProfileListChangeListener changeListener : this.changeListeners) {
            changeListener.profileListChanged();
        }
    }

    @Override
    public void profileChanged(Profile profile) {
        this.scheduler.refresh();
        for (ProfileListChangeListener changeListener : this.changeListeners) {
            changeListener.profileChanged(profile);
        }
    }

    public void addSchedulerListener(ProfileSchedulerListener listener) {
        this.scheduleListeners.add(listener);
    }

    public void removeSchedulerListener(ProfileSchedulerListener listener) {
        this.scheduleListeners.remove(listener);
    }

    protected void fireProfileSchedulerEvent(Profile profile) {
        for (ProfileSchedulerListener schedulerListener : this.scheduleListeners) {
            schedulerListener.profileExecutionScheduled(profile);
        }
    }

    @Override
    public void schedulerStatusChanged(boolean status) {
        this.fireSchedulerChangedEvent();
    }

    public void addSchedulerChangeListener(SchedulerChangeListener listener) {
        this.schedulerChangeListeners.add(listener);
    }

    public void removeSchedulerChangeListener(SchedulerChangeListener listener) {
        this.schedulerChangeListeners.remove(listener);
    }

    protected void fireSchedulerChangedEvent() {
        boolean enabled = this.isSchedulerEnabled();
        for (SchedulerChangeListener listener : this.schedulerChangeListeners) {
            listener.schedulerStatusChanged(enabled);
        }
    }

    public void save() {
        if (this.remoteManager != null) {
            try {
                this.remoteManager.removeProfileListChangeListener(this.remoteListener);
                this.remoteManager.save(this.profiles.toArray(new Profile[0]));
                this.remoteManager.addProfileListChangeListener(this.remoteListener);
            }
            catch (RemoteException e) {
                ExceptionHandler.reportException(e);
            }
        } else {
            OutputStreamWriter osw = null;
            try {
                DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = docBuilder.newDocument();
                Element e = doc.createElement("Profiles");
                e.setAttribute("version", "1.1");
                for (Profile p : this.profiles) {
                    e.appendChild(p.serialize(doc));
                }
                doc.appendChild(e);
                TransformerFactory fac = TransformerFactory.newInstance();
                fac.setAttribute("indent-number", 2);
                Transformer tf = fac.newTransformer();
                DOMSource source = new DOMSource(doc);
                osw = new OutputStreamWriter((OutputStream)new FileOutputStream(this.configFile + ".tmp"), "UTF-8");
                StreamResult out = new StreamResult(osw);
                tf.setOutputProperty("method", "xml");
                tf.setOutputProperty("version", "1.0");
                tf.setOutputProperty("indent", "yes");
                tf.setOutputProperty("standalone", "no");
                tf.transform(source, out);
                osw.flush();
                osw.close();
                File newCfgFile = new File(this.configFile + ".tmp");
                if (0L == newCfgFile.length()) {
                    throw new Exception("Storing profiles failed (size = 0)");
                }
                Util.fileRenameToPortableLegacy(this.configFile + ".tmp", this.configFile);
            }
            catch (Exception e) {
                if (null != osw) {
                    try {
                        osw.close();
                        new File(this.configFile + ".tmp").delete();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                ExceptionHandler.reportException(e);
            }
        }
    }

    public void setRemoteConnected(boolean connected) {
        this.remoteConnected = connected;
    }

    class ProfileManagerSchedulerTask
    implements ScheduleTask {
        private Profile profile;
        private long executionTime;

        public ProfileManagerSchedulerTask(Profile profile, long executionTime) {
            this.profile = profile;
            this.executionTime = executionTime;
        }

        @Override
        public void run() {
            Thread worker = new Thread(new Runnable(){

                @Override
                public void run() {
                    ProfileManager.this.fireProfileSchedulerEvent(ProfileManagerSchedulerTask.this.profile);
                }
            });
            worker.start();
            this.profile.getSchedule().setLastOccurrence(System.currentTimeMillis());
            Thread.yield();
        }

        @Override
        public long getExecutionTime() {
            return this.executionTime;
        }

        public String toString() {
            return "Scheduled execution of " + this.profile.getName();
        }
    }
}

