/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync;

import java.io.Serializable;
import java.util.Hashtable;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.RuleSet;
import net.sourceforge.fullsync.impl.SimplyfiedRuleSetDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class RuleSetDescriptor
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final String ELEMENT_NAME = "RuleSetDescriptor";
    private static Hashtable<String, Class<? extends RuleSetDescriptor>> descriptorRegister = new Hashtable(2);

    public abstract RuleSet createRuleSet();

    public abstract String getType();

    public abstract Element serializeDescriptor(Document var1);

    protected abstract void unserializeDescriptor(Element var1);

    public static final RuleSetDescriptor unserialize(Element element) {
        if (element == null) {
            return null;
        }
        String ruleSetType = element.getAttribute("type");
        Class<? extends RuleSetDescriptor> ruleSetDesctiptorClass = descriptorRegister.get(ruleSetType);
        if (ruleSetDesctiptorClass == null) {
            return null;
        }
        RuleSetDescriptor desc = null;
        try {
            desc = ruleSetDesctiptorClass.newInstance();
        }
        catch (InstantiationException e) {
            ExceptionHandler.reportException(e);
            return null;
        }
        catch (IllegalAccessException e) {
            ExceptionHandler.reportException(e);
            return null;
        }
        desc.unserializeDescriptor(element);
        return desc;
    }

    public static final Element serialize(RuleSetDescriptor desc, Document doc) {
        Element elem = doc.createElement(ELEMENT_NAME);
        elem.setAttribute("type", desc.getType());
        Element ruleDescriptorElement = desc.serializeDescriptor(doc);
        elem.appendChild(ruleDescriptorElement);
        return elem;
    }

    static {
        descriptorRegister.put("simple", SimplyfiedRuleSetDescriptor.class);
    }
}

