/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync;

import java.io.IOException;
import java.rmi.RemoteException;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.IoStatistics;
import net.sourceforge.fullsync.Profile;
import net.sourceforge.fullsync.TaskFinishedListener;
import net.sourceforge.fullsync.TaskGenerator;
import net.sourceforge.fullsync.TaskTree;
import net.sourceforge.fullsync.buffer.BlockBuffer;
import net.sourceforge.fullsync.impl.FillBufferTaskExecutor;
import net.sourceforge.fullsync.impl.TaskGeneratorImpl;
import net.sourceforge.fullsync.remote.RemoteManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Synchronizer {
    private TaskGenerator taskGenerator;
    private RemoteManager remoteManager;
    private Logger logger = LoggerFactory.getLogger((String)"FullSync");

    public Synchronizer() {
        this.taskGenerator = new TaskGeneratorImpl();
    }

    public TaskGenerator getTaskGenerator() {
        return this.taskGenerator;
    }

    public synchronized TaskTree executeProfile(Profile profile, boolean interactive) {
        if (this.remoteManager != null) {
            try {
                return this.remoteManager.executeProfile(profile.getName());
            }
            catch (Exception e) {
                ExceptionHandler.reportException(e);
            }
        } else {
            try {
                return this.taskGenerator.execute(profile, interactive);
            }
            catch (Exception e) {
                ExceptionHandler.reportException(e);
            }
        }
        return null;
    }

    public int performActions(TaskTree taskTree) {
        return this.performActions(taskTree, null);
    }

    public int performActions(TaskTree taskTree, TaskFinishedListener listener) {
        if (this.remoteManager != null) {
            this.logger.info("Remote Synchronization started");
            try {
                this.remoteManager.performActions(taskTree, listener);
                this.logger.info("synchronization successful");
                this.logger.info("------------------------------------------------------------");
                return 0;
            }
            catch (RemoteException e) {
                ExceptionHandler.reportException(e);
                this.logger.error("An Exception occured while performing actions", (Throwable)e);
                this.logger.info("synchronization failed");
                this.logger.info("------------------------------------------------------------");
                return 1;
            }
        }
        try {
            this.logger.info("Synchronization started");
            this.logger.info("  source:      " + taskTree.getSource().getConnectionDescription().getDisplayPath());
            this.logger.info("  destination: " + taskTree.getDestination().getConnectionDescription().getDisplayPath());
            BlockBuffer buffer = new BlockBuffer(this.logger);
            FillBufferTaskExecutor queue = new FillBufferTaskExecutor(buffer);
            if (listener != null) {
                queue.addTaskFinishedListener(listener);
            }
            buffer.load();
            queue.enqueue(taskTree);
            queue.flush();
            buffer.unload();
            taskTree.getSource().flush();
            taskTree.getDestination().flush();
            taskTree.getSource().close();
            taskTree.getDestination().close();
            this.logger.info("synchronization successful");
            this.logger.info("------------------------------------------------------------");
            return 0;
        }
        catch (IOException ioe) {
            this.logger.error("An Exception occured while performing actions", (Throwable)ioe);
            this.logger.info("synchronization failed");
            this.logger.info("------------------------------------------------------------");
            return 1;
        }
    }

    public void setRemoteConnection(RemoteManager remoteManager) {
        this.remoteManager = remoteManager;
    }

    public void disconnectRemote() {
        this.remoteManager = null;
    }

    public IoStatistics getIoStatistics(TaskTree taskTree) {
        Logger logger = LoggerFactory.getLogger((String)"FullSync");
        BlockBuffer buffer = new BlockBuffer(logger);
        FillBufferTaskExecutor queue = new FillBufferTaskExecutor(buffer);
        return queue.createStatistics(taskTree);
    }
}

