/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import net.sourceforge.fullsync.Action;
import net.sourceforge.fullsync.State;
import net.sourceforge.fullsync.fs.File;

public class Task
implements Serializable {
    private static final long serialVersionUID = 2L;
    private File source;
    private File destination;
    private State state;
    private Action[] actions;
    private int currentAction;
    private Vector<Task> children;

    public Task(File source, File destination, State state, Action[] actions) {
        this.source = source;
        this.destination = destination;
        this.state = state;
        this.actions = actions;
        this.currentAction = 0;
        this.children = null;
    }

    public File getDestination() {
        return this.destination;
    }

    public void setDestination(File destination) {
        this.destination = destination;
    }

    public File getSource() {
        return this.source;
    }

    public void setSource(File source) {
        this.source = source;
    }

    public Action getCurrentAction() {
        return this.actions[this.currentAction];
    }

    public int getCurrentActionIndex() {
        return this.currentAction;
    }

    public void setCurrentAction(int i) {
        this.currentAction = i;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Action[] getActions() {
        return this.actions;
    }

    public void setActions(Action[] actions) {
        this.actions = actions;
    }

    public void addChild(Task child) {
        if (this.children == null) {
            this.children = new Vector(5);
        }
        this.children.add(child);
    }

    public Vector<Task> getChildren() {
        if (this.children == null) {
            return new Vector<Task>();
        }
        return this.children;
    }

    public String toString() {
        return this.getCurrentAction().toString();
    }

    public int getTaskCount() {
        int count = 1;
        for (Task t : this.getChildren()) {
            count += t.getTaskCount();
        }
        return count;
    }

    public boolean equals(Object o) {
        if (o instanceof Task) {
            Task t = (Task)o;
            if (this.source.getName().equals(t.source.getName())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.source.getPath().hashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.source);
        out.writeObject(this.destination);
        out.writeObject(this.state);
        out.writeObject(this.actions);
        out.writeInt(this.currentAction);
        out.writeObject(this.children);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.source = (File)in.readObject();
        this.destination = (File)in.readObject();
        this.state = (State)in.readObject();
        this.actions = (Action[])in.readObject();
        this.currentAction = in.readInt();
        this.children = (Vector)in.readObject();
    }
}

