/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class Util {
    private static final int IOBUFFERSIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResourceAsString(String name) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
        if (null != is) {
            try {
                char[] buffer = new char[4096];
                StringBuilder out = new StringBuilder();
                try {
                    int read;
                    InputStreamReader in = new InputStreamReader(is, "UTF-8");
                    do {
                        if ((read = ((Reader)in).read(buffer, 0, buffer.length)) <= 0) continue;
                        out.append(buffer, 0, read);
                    } while (read >= 0);
                    String string = out.toString();
                    return string;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        is.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    public static String getFullSyncVersion() {
        return Util.getResourceAsString("net/sourceforge/fullsync/version.txt").trim();
    }

    public static String getTwitterURL() {
        return Util.getResourceAsString("net/sourceforge/fullsync/twitter-url.txt").trim();
    }

    public static String getWebsiteURL() {
        return Util.getResourceAsString("net/sourceforge/fullsync/website-url.txt").trim();
    }

    public static File getInstalllocation() {
        URL codeSource = Util.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            URI path = codeSource.toURI();
            path = path.resolve("../");
            return new File(path);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return new File(".");
        }
    }

    public static String[] loadDirectoryFromClasspath(Class<?> clazz, String path) throws URISyntaxException, UnsupportedEncodingException, IOException {
        URL dirURL = clazz.getProtectionDomain().getCodeSource().getLocation();
        File src = new File(dirURL.toURI());
        if (src.isDirectory() && src.exists()) {
            return new File(new File(dirURL.toURI()), path.replace('/', File.separatorChar)).list();
        }
        if (src.isFile() && src.exists()) {
            JarFile jar = new JarFile(src);
            Enumeration<JarEntry> jarEntries = jar.entries();
            HashSet<String> result = new HashSet<String>();
            String prefix = path;
            if ('/' == prefix.charAt(0)) {
                prefix = prefix.substring(1);
            }
            while (jarEntries.hasMoreElements()) {
                JarEntry entry = jarEntries.nextElement();
                String name = entry.getName();
                if (entry.isDirectory() || !name.startsWith(prefix)) continue;
                name = name.substring(prefix.length());
                result.add(name);
            }
            jar.close();
            return result.toArray(new String[result.size()]);
        }
        return new String[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fileRenameToPortableLegacy(String from, String to) throws Exception {
        File srcFile = new File(from);
        File dstFile = new File(to);
        if (srcFile.renameTo(dstFile)) return;
        File tmpFile = File.createTempFile("fullsync", "tmp", dstFile.getParentFile());
        tmpFile.delete();
        if (!dstFile.renameTo(tmpFile)) throw new Exception("File.renameTo failed (cannot move old file away)");
        if (srcFile.renameTo(dstFile)) {
            tmpFile.delete();
            return;
        } else {
            tmpFile.renameTo(dstFile);
            throw new Exception("File.renameTo failed (cannot rename file)");
        }
    }
}

