/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Vector;
import net.sourceforge.fullsync.buffer.Entry;
import net.sourceforge.fullsync.buffer.EntryDescriptor;
import net.sourceforge.fullsync.buffer.EntryFinishedListener;
import net.sourceforge.fullsync.buffer.ExecutionBuffer;
import org.slf4j.Logger;

public class BlockBuffer
implements ExecutionBuffer {
    Logger logger;
    int maxSize;
    int maxEntries;
    int freeBytes;
    int numberBytes;
    int numberEntries;
    byte[] buffer;
    Entry[] entries;
    int flushes;
    Vector<EntryFinishedListener> finishedListeners;

    public BlockBuffer(Logger logger) {
        this.logger = logger;
        this.maxSize = 0xA00000;
        this.maxEntries = 5000;
        this.numberBytes = 0;
        this.numberEntries = 0;
        this.freeBytes = this.maxSize;
        this.buffer = null;
        this.entries = null;
        this.flushes = 0;
        this.finishedListeners = new Vector();
    }

    @Override
    public void load() {
        if (this.buffer == null) {
            this.buffer = new byte[this.maxSize];
            this.entries = new Entry[this.maxEntries];
        }
    }

    @Override
    public void unload() {
        this.buffer = null;
        this.entries = null;
    }

    @Override
    public void flush() throws IOException {
        for (int i = 0; i < this.numberEntries; ++i) {
            Entry e = this.entries[i];
            EntryDescriptor desc = e.descriptor;
            IOException ioe = null;
            try {
                OutputStream out = desc.getOutputStream();
                if (out != null) {
                    out.write(this.buffer, e.start, e.length);
                }
                if ((e.internalSegment & 4) > 0) {
                    desc.finishWrite();
                    String opDesc = desc.getOperationDescription();
                    if (opDesc != null) {
                        this.logger.info(opDesc);
                    }
                }
            }
            catch (IOException ex) {
                ioe = ex;
                this.logger.error("Exception", (Throwable)ex);
            }
            if ((e.internalSegment & 4) <= 0) continue;
            for (EntryFinishedListener listener : this.finishedListeners) {
                listener.entryFinished(desc, ioe);
            }
        }
        Arrays.fill(this.entries, null);
        this.numberBytes = 0;
        this.numberEntries = 0;
        this.freeBytes = this.maxSize;
        ++this.flushes;
    }

    protected Entry storeBytes(InputStream inStream, long length) throws IOException {
        Entry entry;
        if (length > (long)this.freeBytes) {
            length = this.freeBytes;
        }
        int start = this.numberBytes;
        int read = inStream.read(this.buffer, start, (int)length);
        this.numberBytes += read;
        this.freeBytes -= read;
        this.entries[this.numberEntries] = entry = new Entry(start, read);
        ++this.numberEntries;
        return entry;
    }

    private int store(InputStream inStream, long alreadyRead, long lengthLeft, EntryDescriptor descriptor) throws IOException {
        Entry entry = this.storeBytes(inStream, lengthLeft);
        int s = 2;
        if (alreadyRead == 0L) {
            s |= 1;
        }
        if ((long)entry.length == lengthLeft) {
            s |= 4;
        }
        entry.internalSegment = s;
        entry.descriptor = descriptor;
        return entry.length;
    }

    private void storeEntry(InputStream data, long size, EntryDescriptor descriptor) throws IOException {
        int read;
        long alreadyRead = 0L;
        long lengthLeft = size;
        do {
            if (lengthLeft > (long)this.freeBytes || this.numberEntries == this.maxEntries) {
                this.flush();
            }
            read = this.store(data, alreadyRead, lengthLeft, descriptor);
            alreadyRead += (long)read;
        } while ((lengthLeft -= (long)read) > 0L);
    }

    @Override
    public void storeEntry(EntryDescriptor descriptor) throws IOException {
        if (descriptor.getSize() == 0L) {
            if (this.numberEntries == this.maxEntries) {
                this.flush();
            }
            Entry entry = new Entry(this.numberBytes, 0);
            entry.descriptor = descriptor;
            this.entries[this.numberEntries] = entry;
            ++this.numberEntries;
        } else {
            this.storeEntry(descriptor.getInputStream(), descriptor.getSize(), descriptor);
        }
        descriptor.finishStore();
    }

    @Override
    public void addEntryFinishedListener(EntryFinishedListener listener) {
        this.finishedListeners.add(listener);
    }

    @Override
    public void removeEntryFinishedListener(EntryFinishedListener listener) {
        this.finishedListeners.remove(listener);
    }
}

