/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.changelog;

import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChangeLogEntry
implements Comparable<ChangeLogEntry> {
    private static DateFormat releaseDateParser = new SimpleDateFormat("yyyyMMdd");
    private Node ul;
    private String manual;
    private Date date;
    private String version;

    public ChangeLogEntry(Document doc) throws ParseException {
        this.ul = doc.getFirstChild();
        NamedNodeMap attrs = this.ul.getAttributes();
        this.version = this.attr(attrs, "data-version");
        this.manual = this.attr(attrs, "data-manual");
        String d = this.attr(attrs, "data-date");
        this.date = "00000000".equals(d) ? new Date() : releaseDateParser.parse(d);
    }

    private String attr(NamedNodeMap attrs, String name) {
        Node n = attrs.getNamedItem(name);
        if (null != n) {
            return n.getNodeValue();
        }
        return null;
    }

    public void write(String headerTemplate, String entryTemplate, Writer wr, DateFormat dateFormat) {
        PrintWriter pw = new PrintWriter(wr);
        pw.println(String.format(headerTemplate, this.version, dateFormat.format(this.date)));
        NodeList lis = this.ul.getChildNodes();
        for (int i = 0; i < lis.getLength(); ++i) {
            Node li = lis.item(i);
            if (1 != li.getNodeType()) continue;
            pw.println(String.format(entryTemplate, li.getTextContent()));
        }
        pw.println();
        pw.flush();
    }

    @Override
    public int compareTo(ChangeLogEntry o) {
        return o.date.compareTo(this.date);
    }

    public String getVersion() {
        return this.version;
    }
}

