/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.changelog;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.fullsync.changelog.ChangeLogEntry;
import net.sourceforge.fullsync.changelog.VersionComparator;
import org.xml.sax.SAXException;

public class ChangeLogLoader {
    private DocumentBuilderFactory parserFactory = DocumentBuilderFactory.newInstance();

    public ChangeLogLoader() {
        this.parserFactory.setValidating(false);
        this.parserFactory.setNamespaceAware(false);
        this.parserFactory.setIgnoringComments(true);
        this.parserFactory.setIgnoringElementContentWhitespace(true);
        this.parserFactory.setExpandEntityReferences(false);
    }

    public List<ChangeLogEntry> load(File srcDir, String pattern) throws ParserConfigurationException, SAXException, IOException, ParseException {
        Pattern p = Pattern.compile(pattern);
        LinkedList<ChangeLogEntry> changelogEntries = new LinkedList<ChangeLogEntry>();
        String[] children = srcDir.list();
        if (null != children) {
            for (String file : children) {
                Matcher m = p.matcher(file);
                if (!m.matches()) continue;
                changelogEntries.add(this.loadChangeLogFile(new File(srcDir, file)));
            }
        }
        Collections.sort(changelogEntries);
        return changelogEntries;
    }

    public static List<ChangeLogEntry> filterAfter(List<ChangeLogEntry> changelogEntries, String version) {
        LinkedList<ChangeLogEntry> newerVersions = new LinkedList<ChangeLogEntry>();
        VersionComparator vc = new VersionComparator();
        for (ChangeLogEntry entry : changelogEntries) {
            if (1 != vc.compare(entry.getVersion(), version)) break;
            newerVersions.add(entry);
        }
        return newerVersions;
    }

    private ChangeLogEntry loadChangeLogFile(File f) throws ParserConfigurationException, SAXException, IOException, ParseException {
        DocumentBuilder parser = this.parserFactory.newDocumentBuilder();
        return new ChangeLogEntry(parser.parse(f));
    }
}

