/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.changelog;

import java.util.Comparator;

public class VersionComparator
implements Comparator<String> {
    private int[] parseVersion(String v) {
        String[] components = v.split("\\.");
        int[] numbers = new int[components.length];
        for (int i = 0; i < components.length; ++i) {
            if (components[i].isEmpty()) continue;
            numbers[i] = Integer.parseInt(components[i]);
        }
        return numbers;
    }

    @Override
    public int compare(String o1, String o2) {
        int[] v1components = this.parseVersion(o1);
        int[] v2components = this.parseVersion(o2);
        int num = Math.max(v1components.length, v2components.length);
        for (int i = 0; i < num; ++i) {
            int v2;
            int v1 = i < v1components.length ? v1components[i] : 0;
            int n = v2 = i < v2components.length ? v2components[i] : 0;
            if (v1 > v2) {
                return 1;
            }
            if (v1 >= v2) continue;
            return -1;
        }
        return 0;
    }
}

