/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.rmi.RemoteException;
import java.util.Date;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.Profile;
import net.sourceforge.fullsync.ProfileManager;
import net.sourceforge.fullsync.ProfileSchedulerListener;
import net.sourceforge.fullsync.Synchronizer;
import net.sourceforge.fullsync.TaskTree;
import net.sourceforge.fullsync.Util;
import net.sourceforge.fullsync.impl.ConfigurationPreferences;
import net.sourceforge.fullsync.remote.RemoteController;
import net.sourceforge.fullsync.ui.GuiController;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static Options options;

    private static void initOptions() {
        options = new Options();
        options.addOption("h", "help", false, "this help");
        options.addOption("v", "verbose", false, "verbose output to stdout");
        options.addOption("V", "version", false, "display the version and exit");
        options.addOption("m", "minimized", false, "starts fullsync gui in system tray ");
        OptionBuilder.withLongOpt((String)"profiles-file");
        OptionBuilder.withDescription((String)"uses the specified file instead of profiles.xml");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"filename");
        options.addOption(OptionBuilder.create((String)"P"));
        OptionBuilder.withLongOpt((String)"run");
        OptionBuilder.withDescription((String)"run the specified profile");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"profile");
        options.addOption(OptionBuilder.create((String)"r"));
        options.addOption("d", "daemon", false, "disables the gui and runs in daemon mode with scheduler");
        OptionBuilder.withLongOpt((String)"remoteport");
        OptionBuilder.withDescription((String)"accept incoming connection on the specified port or 10000");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName((String)"port");
        options.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withLongOpt((String)"password");
        OptionBuilder.withDescription((String)"password for incoming connections");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName((String)"passwd");
        options.addOption(OptionBuilder.create((String)"a"));
    }

    private static void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("fullsync [-hvrdp]", options);
    }

    public static String getConfigDir() {
        String configDir = System.getProperty("net.sourceforge.fullsync.configDir");
        if (null == configDir) {
            configDir = System.getenv("XDG_CONFIG_HOME");
        }
        if (null == configDir) {
            configDir = System.getProperty("user.home") + File.separator + ".config";
        }
        if (!new File(configDir = configDir + File.separator + "fullsync" + File.separator).exists()) {
            new File(configDir).mkdirs();
        }
        return configDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void backupFile(File old, File current, String backupName) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(old);
            fos = new FileOutputStream(current);
            FileChannel in = fis.getChannel();
            FileChannel out = fos.getChannel();
            in.transferTo(0L, in.size(), out);
            in.close();
            out.close();
            old.renameTo(new File(backupName));
        }
        finally {
            if (null != fis) {
                fis.close();
            }
            if (null != fos) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block33: {
            Main.initOptions();
            String configDir = Main.getConfigDir();
            try {
                PosixParser parser = new PosixParser();
                CommandLine line = null;
                try {
                    line = parser.parse(options, args);
                }
                catch (ParseException pe) {
                    System.err.println(pe.getMessage());
                    Main.printHelp();
                    return;
                }
                if (line.hasOption('V')) {
                    System.out.println(String.format("FullSync version %s", Util.getFullSyncVersion()));
                    System.exit(0);
                }
                if (!line.hasOption("v")) {
                    System.setErr(new PrintStream(new FileOutputStream(configDir + "fullsync.log")));
                }
                if (line.hasOption("h")) {
                    Main.printHelp();
                    return;
                }
                File newPreferences = new File(configDir + "preferences.properties");
                File oldPreferences = new File("preferences.properties");
                if (!newPreferences.exists() && oldPreferences.exists()) {
                    Main.backupFile(oldPreferences, newPreferences, "preferences_old.properties");
                }
                ConfigurationPreferences preferences = new ConfigurationPreferences(configDir + "preferences.properties");
                String profilesFile = "profiles.xml";
                if (line.hasOption("P")) {
                    profilesFile = line.getOptionValue("P");
                } else {
                    profilesFile = configDir + "profiles.xml";
                    File newProfiles = new File(profilesFile);
                    File oldProfiles = new File("profiles.xml");
                    if (!newProfiles.exists()) {
                        if (!oldProfiles.exists()) {
                            oldProfiles = new File(".." + File.separator + "profiles.xml");
                        }
                        if (oldProfiles.exists()) {
                            Main.backupFile(oldProfiles, newProfiles, "profiles_old.xml");
                        }
                    }
                }
                ProfileManager profileManager = new ProfileManager(profilesFile);
                final Synchronizer sync = new Synchronizer();
                if (line.hasOption("r")) {
                    Profile p = profileManager.getProfile(line.getOptionValue("r"));
                    TaskTree tree = sync.executeProfile(p, false);
                    sync.performActions(tree);
                    p.setLastUpdate(new Date());
                    profileManager.save();
                    return;
                }
                boolean activateRemote = false;
                int port = 10000;
                String password = "admin";
                RemoteException listenerStarupException = null;
                if (line.hasOption("p")) {
                    activateRemote = true;
                    try {
                        String portStr = line.getOptionValue("p");
                        port = Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException portStr) {
                        // empty catch block
                    }
                    if (line.hasOption("a")) {
                        password = line.getOptionValue("a");
                    }
                } else {
                    activateRemote = preferences.listeningForRemoteConnections();
                    port = preferences.getRemoteConnectionsPort();
                    password = preferences.getRemoteConnectionsPassword();
                }
                if (activateRemote) {
                    try {
                        Logger logger = LoggerFactory.getLogger((String)"FullSync");
                        RemoteController.getInstance().startServer(port, password, profileManager, sync);
                        logger.info("Remote Interface available on port: " + port);
                    }
                    catch (RemoteException e) {
                        ExceptionHandler.reportException(e);
                        listenerStarupException = e;
                    }
                }
                if (line.hasOption("d")) {
                    profileManager.addSchedulerListener(new ProfileSchedulerListener(){

                        @Override
                        public void profileExecutionScheduled(Profile profile) {
                            TaskTree tree = sync.executeProfile(profile, false);
                            if (tree == null) {
                                profile.setLastError(1, "An error occured while comparing filesystems.");
                            } else {
                                int errorLevel = sync.performActions(tree);
                                if (errorLevel > 0) {
                                    profile.setLastError(errorLevel, "An error occured while copying files.");
                                } else {
                                    profile.setLastUpdate(new Date());
                                }
                            }
                        }
                    });
                    profileManager.startScheduler();
                    break block33;
                }
                try {
                    GuiController guiController = GuiController.initialize(preferences, profileManager, sync);
                    guiController.startGui(line.hasOption('m'));
                    if (!line.hasOption('P') && !preferences.getHelpShown() && null == System.getProperty("net.sourceforge.fullsync.skipHelp")) {
                        preferences.setHelpShown(true);
                        preferences.save();
                        File f = new File("docs/manual/manual.html");
                        if (f.exists()) {
                            GuiController.launchProgram(f.getAbsolutePath());
                        }
                    }
                    if (listenerStarupException != null) {
                        ExceptionHandler.reportException("Unable to start incoming connections listener.", listenerStarupException);
                    }
                    if (preferences.getAutostartScheduler()) {
                        profileManager.startScheduler();
                    }
                    guiController.run();
                    guiController.disposeGui();
                }
                catch (Exception ex) {
                    ExceptionHandler.reportException(ex);
                }
                finally {
                    profileManager.save();
                }
                RemoteController.getInstance().stopServer();
                if (null == System.getProperty("net.sourceforge.fullsync.skipExit")) {
                    System.exit(-1);
                }
            }
            catch (Exception exp) {
                ExceptionHandler.reportException(exp);
            }
        }
    }
}

