/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.fs.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import net.sourceforge.fullsync.fs.File;
import net.sourceforge.fullsync.fs.buffering.BufferedFile;
import net.sourceforge.fullsync.fs.connection.AbstractFile;
import net.sourceforge.fullsync.fs.connection.BufferedConnection;

class AbstractBufferedFile
extends AbstractFile
implements BufferedFile {
    private static final long serialVersionUID = 2L;
    protected File unbuffered = null;
    private long fsSize;
    private long fsLastModified;

    AbstractBufferedFile(BufferedConnection bc, String name, File parent, boolean directory, boolean exists) {
        super(bc, name, parent, directory, exists);
        this.children = new Hashtable();
        this.fsSize = -1L;
        this.fsLastModified = -1L;
    }

    AbstractBufferedFile(BufferedConnection bc, File unbuffered, File parent, boolean directory, boolean exists) {
        this(bc, unbuffered.getName(), parent, directory, exists);
        this.unbuffered = unbuffered;
    }

    @Override
    public boolean isBuffered() {
        return true;
    }

    @Override
    public File getUnbuffered() throws IOException {
        if (this.unbuffered == null) {
            this.refreshReference();
        }
        return this.unbuffered;
    }

    @Override
    public boolean makeDirectory() throws IOException {
        return this.getUnbuffered().makeDirectory();
    }

    public void setFsLastModified(long lastModified) {
        this.fsLastModified = lastModified;
    }

    public void setFsSize(long size) {
        this.fsSize = size;
    }

    @Override
    public long getFsLastModified() {
        long lm = super.getLastModified();
        if (-1L == lm) {
            lm = this.fsLastModified;
        }
        return lm;
    }

    @Override
    public long getFsSize() {
        long size = super.getSize();
        if (-1L == size) {
            size = this.fsSize;
        }
        return size;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getUnbuffered().getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.getUnbuffered().getOutputStream();
    }

    @Override
    public void addChild(File node) {
        this.children.put(node.getName(), node);
    }

    @Override
    public void removeChild(String name) {
        this.children.remove(name);
    }

    @Override
    public void refresh() throws IOException {
        this.getUnbuffered().refresh();
        this.refreshReference();
    }

    @Override
    public void refreshBuffer() throws IOException {
        File unb = this.getUnbuffered();
        this.directory = unb.isDirectory();
        this.exists = unb.exists();
        if (this.exists && !this.directory) {
            this.setFsLastModified(unb.getLastModified());
            this.setFsSize(unb.getSize());
        }
    }

    @Override
    public void refreshReference() throws IOException {
        this.unbuffered = this.getParent().getUnbuffered().getChild(this.getName());
        if (this.unbuffered == null) {
            this.unbuffered = this.getParent().getUnbuffered().createChild(this.getName(), this.directory);
        }
    }
}

