/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.fs.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import net.sourceforge.fullsync.fs.File;
import net.sourceforge.fullsync.fs.connection.FileSystemConnection;

class AbstractFile
implements File {
    private static final long serialVersionUID = 3L;
    protected FileSystemConnection fs;
    protected String name;
    protected File parent;
    protected boolean exists;
    protected boolean directory;
    protected Hashtable<String, File> children;
    protected long size;
    protected long lastModified;

    AbstractFile(FileSystemConnection fs, String name, File parent, boolean directory, boolean exists) {
        this.fs = fs;
        this.name = name;
        this.parent = parent;
        this.exists = exists;
        this.directory = directory;
        this.children = null;
        this.size = -1L;
        this.lastModified = -1L;
    }

    public FileSystemConnection getConnection() {
        return this.fs;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        String parentPath = null;
        if (this.parent != null) {
            parentPath = this.parent.getPath();
        }
        return null != parentPath ? parentPath + "/" + this.name : this.name;
    }

    @Override
    public File getParent() {
        return this.parent;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public boolean isDirectory() {
        return this.directory;
    }

    @Override
    public boolean isFile() {
        return !this.directory;
    }

    @Override
    public boolean isBuffered() {
        return false;
    }

    @Override
    public File getUnbuffered() throws IOException {
        return this;
    }

    @Override
    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    public void writeFileAttributes() throws IOException {
        this.getConnection().writeFileAttributes(this);
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void setSize(long size) {
        this.size = size;
    }

    @Override
    public File createChild(String name, boolean directory) throws IOException {
        File f = this.getConnection().createChild(this, name, directory);
        this.children.put(name, f);
        return f;
    }

    @Override
    public File getChild(String name) throws IOException {
        if (this.children == null) {
            this.refresh();
        }
        return this.children.get(name);
    }

    @Override
    public Collection<File> getChildren() throws IOException {
        if (this.children == null) {
            this.refresh();
        }
        return this.children.values();
    }

    @Override
    public boolean makeDirectory() throws IOException {
        if (this.isDirectory()) {
            if (this.getConnection().makeDirectory(this)) {
                this.exists = true;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.isFile()) {
            return this.getConnection().readFile(this);
        }
        return null;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.isFile()) {
            OutputStream out = this.getConnection().writeFile(this);
            if (out != null) {
                this.exists = true;
            }
            return out;
        }
        return null;
    }

    @Override
    public boolean delete() throws IOException {
        if (this.fs.delete(this)) {
            this.exists = false;
            return true;
        }
        return false;
    }

    @Override
    public void refresh() throws IOException {
        if (this.isDirectory()) {
            Hashtable<String, File> newChildren = this.getConnection().getChildren(this);
            if (this.children != null) {
                for (File n : this.children.values()) {
                    if (newChildren.containsKey(n.getName())) continue;
                    if (n.exists()) {
                        newChildren.put(n.getName(), new AbstractFile(this.getConnection(), n.getName(), n.getParent(), n.isDirectory(), false));
                        continue;
                    }
                    newChildren.put(n.getName(), n);
                }
            }
            this.children = newChildren;
        } else {
            this.parent.refresh();
        }
    }

    @Override
    public void refreshBuffer() throws IOException {
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append("; ");
        if (this.size >= 0L || this.lastModified > 0L) {
            if (this.size >= 0L) {
                sb.append(this.size);
                sb.append(" Bytes");
            }
            if (this.lastModified > 0L) {
                sb.append(' ');
                sb.append(new Date(this.lastModified));
            }
        } else {
            sb.append('-');
        }
        return sb.toString();
    }
}

