/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.fs.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import net.sourceforge.fullsync.ConnectionDescription;
import net.sourceforge.fullsync.FileSystemException;
import net.sourceforge.fullsync.fs.File;
import net.sourceforge.fullsync.fs.FileSystem;
import net.sourceforge.fullsync.fs.connection.AbstractFile;
import net.sourceforge.fullsync.fs.connection.FileSystemConnection;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VFS;

public class CommonsVfsConnection
implements FileSystemConnection {
    private static final long serialVersionUID = 2L;
    private final boolean canSetLastModifiedFile;
    private final boolean canSetLastModifiedFolder;
    private ConnectionDescription desc;
    private FileObject base;
    private File root;

    public CommonsVfsConnection(ConnectionDescription desc, FileSystem fs) throws FileSystemException {
        try {
            this.desc = desc;
            FileSystemOptions options = new FileSystemOptions();
            if (null != fs) {
                fs.authSetup(desc, options);
            }
            this.base = VFS.getManager().resolveFile(desc.getUri().toString(), options);
            this.root = new AbstractFile(this, ".", null, true, this.base.exists());
            this.canSetLastModifiedFile = this.base.getFileSystem().hasCapability(Capability.SET_LAST_MODIFIED_FILE);
            this.canSetLastModifiedFolder = this.base.getFileSystem().hasCapability(Capability.SET_LAST_MODIFIED_FOLDER);
        }
        catch (org.apache.commons.vfs2.FileSystemException e) {
            throw new FileSystemException(e);
        }
    }

    @Override
    public final File createChild(File parent, String name, boolean directory) throws IOException {
        return new AbstractFile(this, name, parent, directory, false);
    }

    private File buildNode(File parent, FileObject file) throws org.apache.commons.vfs2.FileSystemException {
        String name = file.getName().getBaseName();
        AbstractFile n = new AbstractFile(this, name, parent, file.getType() == FileType.FOLDER, true);
        if (file.getType() == FileType.FILE) {
            FileContent content = file.getContent();
            n.setLastModified(content.getLastModifiedTime());
            n.setSize(content.getSize());
        }
        return n;
    }

    @Override
    public final Hashtable<String, File> getChildren(File dir) throws IOException {
        try {
            Hashtable<String, File> children = new Hashtable<String, File>();
            FileObject obj = this.base.resolveFile(dir.getPath());
            if (obj.exists() && obj.getType() == FileType.FOLDER) {
                FileObject[] list;
                for (FileObject element : list = obj.getChildren()) {
                    children.put(element.getName().getBaseName(), this.buildNode(dir, element));
                }
            }
            return children;
        }
        catch (org.apache.commons.vfs2.FileSystemException fse) {
            throw new IOException(fse.getMessage());
        }
    }

    @Override
    public final boolean makeDirectory(File dir) throws IOException {
        FileObject obj = this.base.resolveFile(dir.getPath());
        obj.createFolder();
        return true;
    }

    @Override
    public final boolean writeFileAttributes(File file) throws IOException {
        FileObject obj = this.base.resolveFile(file.getPath());
        FileContent content = obj.getContent();
        boolean setLastModified = FileType.FOLDER == obj.getType() ? this.canSetLastModifiedFolder : this.canSetLastModifiedFile;
        if (setLastModified) {
            content.setLastModifiedTime(file.getLastModified());
        }
        return true;
    }

    @Override
    public final InputStream readFile(File file) throws IOException {
        FileObject obj = this.base.resolveFile(file.getPath());
        return obj.getContent().getInputStream();
    }

    @Override
    public final OutputStream writeFile(File file) throws IOException {
        FileObject obj = this.base.resolveFile(file.getPath());
        return obj.getContent().getOutputStream();
    }

    @Override
    public final boolean delete(File node) throws IOException {
        FileObject obj = this.base.resolveFile(node.getPath());
        return obj.delete();
    }

    @Override
    public final File getRoot() {
        return this.root;
    }

    @Override
    public final FileObject getBase() {
        return this.base;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public final void close() throws IOException {
        VFS.getManager().closeFileSystem(this.base.getFileSystem());
    }

    @Override
    public final boolean isCaseSensitive() {
        return false;
    }

    @Override
    public final boolean isAvailable() {
        return true;
    }

    @Override
    public ConnectionDescription getConnectionDescription() {
        return this.desc;
    }
}

