/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.fs.connection;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Hashtable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.fullsync.ConnectionDescription;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.fs.File;
import net.sourceforge.fullsync.fs.Site;
import net.sourceforge.fullsync.fs.buffering.BufferedFile;
import net.sourceforge.fullsync.fs.connection.AbstractBufferedFile;
import net.sourceforge.fullsync.fs.connection.BufferedConnection;
import org.apache.commons.vfs2.FileObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SyncFileBufferedConnection
implements BufferedConnection {
    private static final long serialVersionUID = 2L;
    private Site fs;
    private BufferedFile root;
    private boolean monitoringFileSystem;

    public SyncFileBufferedConnection(Site fs) throws IOException {
        this.fs = fs;
        this.monitoringFileSystem = false;
        this.loadFromBuffer();
    }

    @Override
    public boolean isAvailable() {
        return this.fs.isAvailable();
    }

    @Override
    public File createChild(File dir, String name, boolean directory) throws IOException {
        File n = dir.getUnbuffered().getChild(name);
        if (n == null) {
            n = dir.getUnbuffered().createChild(name, directory);
        }
        AbstractBufferedFile bf = new AbstractBufferedFile((BufferedConnection)this, n, dir, directory, false);
        return bf;
    }

    @Override
    public boolean delete(File node) throws IOException {
        node.getUnbuffered().delete();
        ((BufferedFile)node.getParent()).removeChild(node.getName());
        return true;
    }

    @Override
    public Hashtable<String, File> getChildren(File dir) {
        return null;
    }

    @Override
    public File getRoot() {
        return this.root;
    }

    @Override
    public boolean makeDirectory(File dir) {
        return false;
    }

    @Override
    public InputStream readFile(File file) {
        return null;
    }

    @Override
    public OutputStream writeFile(File file) {
        return null;
    }

    @Override
    public boolean writeFileAttributes(File file) {
        return false;
    }

    protected void updateFromFileSystem(BufferedFile buffered) throws IOException {
        Collection<File> fsChildren = buffered.getUnbuffered().getChildren();
        for (File uf : fsChildren) {
            BufferedFile bf = (BufferedFile)buffered.getChild(uf.getName());
            if (bf == null) {
                bf = new AbstractBufferedFile((BufferedConnection)this, uf, (File)this.root, uf.isDirectory(), false);
                buffered.addChild(bf);
            }
            if (!bf.isDirectory()) continue;
            this.updateFromFileSystem(bf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromBuffer() throws IOException {
        File fsRoot = this.fs.getRoot();
        File f = fsRoot.getChild(".syncfiles");
        this.root = new AbstractBufferedFile((BufferedConnection)this, fsRoot, null, true, true);
        if (f == null || !f.exists() || f.isDirectory()) {
            if (this.isMonitoringFileSystem()) {
                this.updateFromFileSystem(this.root);
            }
            return;
        }
        InputStream reader = null;
        try {
            int i;
            ByteArrayOutputStream out = new ByteArrayOutputStream((int)f.getSize());
            GZIPInputStream in = new GZIPInputStream(f.getInputStream());
            byte[] block = new byte[1024];
            while ((i = ((InputStream)in).read(block)) > 0) {
                out.write(block, 0, i);
            }
            ((InputStream)in).close();
            out.close();
            reader = new ByteArrayInputStream(out.toByteArray());
            SAXParser sax = SAXParserFactory.newInstance().newSAXParser();
            sax.parse(reader, (DefaultHandler)new SyncFileDefaultHandler(this));
        }
        catch (IOException ioe) {
            ExceptionHandler.reportException(ioe);
        }
        catch (SAXParseException spe) {
            StringBuffer sb = new StringBuffer(spe.toString());
            sb.append("\n Line number: " + spe.getLineNumber());
            sb.append("\n Column number: " + spe.getColumnNumber());
            sb.append("\n Public ID: " + spe.getPublicId());
            sb.append("\n System ID: " + spe.getSystemId() + "\n");
            System.err.println(sb.toString());
        }
        catch (SAXException e) {
            ExceptionHandler.reportException(e);
        }
        catch (ParserConfigurationException e) {
            ExceptionHandler.reportException(e);
        }
        catch (FactoryConfigurationError e) {
            ExceptionHandler.reportException(e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e1) {
                ExceptionHandler.reportException(e1);
            }
        }
        if (this.isMonitoringFileSystem()) {
            this.updateFromFileSystem(this.root);
        }
    }

    protected Element serializeFile(BufferedFile file, Document doc) throws IOException {
        Element elem = doc.createElement(file.isDirectory() ? "Directory" : "File");
        elem.setAttribute("Name", file.getName());
        if (file.isDirectory()) {
            for (File n : file.getChildren()) {
                if (!n.exists()) continue;
                elem.appendChild(this.serializeFile((BufferedFile)n, doc));
            }
        } else {
            elem.setAttribute("BufferedLength", String.valueOf(file.getSize()));
            elem.setAttribute("BufferedLastModified", String.valueOf(file.getLastModified()));
            elem.setAttribute("FileSystemLength", String.valueOf(file.getFsSize()));
            elem.setAttribute("FileSystemLastModified", String.valueOf(file.getFsLastModified()));
        }
        return elem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToBuffer() throws IOException {
        File fsRoot = this.fs.getRoot();
        File node = fsRoot.getChild(".syncfiles");
        if (node == null || !node.exists()) {
            node = this.root.createChild(".syncfiles", false);
        }
        OutputStream out = null;
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element e = doc.createElement("SyncFiles");
            e.appendChild(this.serializeFile(this.root, doc));
            doc.appendChild(e);
            out = new GZIPOutputStream(node.getOutputStream());
            TransformerFactory fac = TransformerFactory.newInstance();
            fac.setAttribute("indent-number", 2);
            Transformer tf = fac.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new OutputStreamWriter(out, "UTF-8"));
            tf.setOutputProperty("method", "xml");
            tf.setOutputProperty("version", "1.0");
            tf.setOutputProperty("indent", "yes");
            tf.setOutputProperty("standalone", "no");
            tf.transform(source, result);
        }
        catch (IOException ioe) {
            ExceptionHandler.reportException(ioe);
        }
        catch (ParserConfigurationException e) {
            ExceptionHandler.reportException(e);
        }
        catch (FactoryConfigurationError e) {
            ExceptionHandler.reportException(e);
        }
        catch (TransformerConfigurationException e) {
            ExceptionHandler.reportException(e);
        }
        catch (TransformerException e) {
            ExceptionHandler.reportException(e);
        }
        finally {
            if (null != out) {
                out.close();
            }
        }
    }

    @Override
    public boolean isMonitoringFileSystem() {
        return this.monitoringFileSystem;
    }

    @Override
    public void flush() throws IOException {
        this.saveToBuffer();
        this.fs.flush();
    }

    @Override
    public void close() throws IOException {
        this.fs.close();
    }

    @Override
    public boolean isCaseSensitive() {
        return this.fs.isCaseSensitive();
    }

    @Override
    public FileObject getBase() {
        return this.fs.getBase();
    }

    @Override
    public ConnectionDescription getConnectionDescription() {
        return this.fs.getConnectionDescription();
    }

    class SyncFileDefaultHandler
    extends DefaultHandler {
        BufferedConnection bc;
        AbstractBufferedFile current;

        public SyncFileDefaultHandler(SyncFileBufferedConnection bc) {
            this.bc = bc;
            this.current = (AbstractBufferedFile)bc.getRoot();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String name = attributes.getValue("Name");
            if ("Directory".equals(qName)) {
                if ("/".equals(name) || ".".equals(name)) {
                    return;
                }
                AbstractBufferedFile newDir = new AbstractBufferedFile(this.bc, name, (File)this.current, true, true);
                this.current.addChild(newDir);
                this.current = newDir;
            } else if ("File".equals(qName)) {
                AbstractBufferedFile newFile = new AbstractBufferedFile(this.bc, name, (File)this.current, false, true);
                newFile.setSize(Long.parseLong(attributes.getValue("BufferedLength")));
                newFile.setLastModified(Long.parseLong(attributes.getValue("BufferedLastModified")));
                newFile.setFsSize(Long.parseLong(attributes.getValue("FileSystemLength")));
                newFile.setFsLastModified(Long.parseLong(attributes.getValue("FileSystemLastModified")));
                this.current.addChild(newFile);
            }
            super.startElement(uri, localName, qName, attributes);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("Directory".equals(qName)) {
                this.current = (AbstractBufferedFile)this.current.getParent();
            }
            super.endElement(uri, localName, qName);
        }
    }
}

