/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.fs.filesystems;

import java.io.IOException;
import net.sourceforge.fullsync.ConnectionDescription;
import net.sourceforge.fullsync.FileSystemException;
import net.sourceforge.fullsync.fs.FileSystem;
import net.sourceforge.fullsync.fs.Site;
import net.sourceforge.fullsync.fs.connection.CommonsVfsConnection;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.auth.StaticUserAuthenticator;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;

public class FTPFileSystem
implements FileSystem {
    @Override
    public final void authSetup(ConnectionDescription description, FileSystemOptions options) throws org.apache.commons.vfs2.FileSystemException {
        StaticUserAuthenticator auth = new StaticUserAuthenticator(null, description.getParameter("username"), description.getSecretParameter("password"));
        FtpFileSystemConfigBuilder.getInstance().setPassiveMode(options, true);
        DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(options, (UserAuthenticator)auth);
    }

    @Override
    public final Site createConnection(ConnectionDescription description) throws FileSystemException, IOException {
        return new CommonsVfsConnection(description, this);
    }
}

