/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.fs.filesystems;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.util.Arrays;
import net.sourceforge.fullsync.ConnectionDescription;
import net.sourceforge.fullsync.FileSystemException;
import net.sourceforge.fullsync.fs.FileSystem;
import net.sourceforge.fullsync.fs.Site;
import net.sourceforge.fullsync.fs.connection.CommonsVfsConnection;
import net.sourceforge.fullsync.impl.SFTPLogger;
import net.sourceforge.fullsync.ui.GuiController;
import net.sourceforge.fullsync.ui.OptionsDialog;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.auth.StaticUserAuthenticator;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.slf4j.LoggerFactory;

public class SFTPFileSystem
implements FileSystem,
UIKeyboardInteractive,
UserInfo {
    private static boolean loggerSetupCompleted = false;
    private static String sshDirName = null;
    private org.slf4j.Logger logger = LoggerFactory.getLogger((String)"FullSync");
    private ConnectionDescription desc = null;

    public SFTPFileSystem() {
        if (!loggerSetupCompleted) {
            JSch.setLogger((Logger)new SFTPLogger());
        }
        if (null == sshDirName) {
            File sshDir;
            String sshDirPath = System.getProperty("vfs.sftp.sshdir");
            if (sshDirPath == null) {
                sshDirPath = System.getProperty("user.home") + File.separator + ".ssh";
            }
            if (!(sshDir = new File(sshDirPath)).exists() && !sshDir.mkdirs()) {
                this.logger.warn("failed to create the .ssh directory, remembering SSH keys likely won't work... (tried: " + sshDir.getAbsolutePath().toString() + ")");
                sshDir = null;
            } else {
                sshDirName = sshDirPath;
            }
            if (null != sshDir) {
                System.setProperty("vfs.sftp.sshdir", sshDir.getAbsolutePath());
            }
        }
    }

    @Override
    public final void authSetup(ConnectionDescription description, FileSystemOptions options) throws org.apache.commons.vfs2.FileSystemException {
        StaticUserAuthenticator auth = new StaticUserAuthenticator(null, description.getParameter("username"), description.getSecretParameter("password"));
        DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(options, (UserAuthenticator)auth);
        SftpFileSystemConfigBuilder cfg = SftpFileSystemConfigBuilder.getInstance();
        if (null != sshDirName) {
            cfg.setKnownHosts(options, new File(sshDirName, "known_hosts"));
        }
        this.logger.debug("SFTP using knownHosts: ", (Object)cfg.getKnownHosts(options));
        cfg.setUserInfo(options, (UserInfo)this);
        cfg.setStrictHostKeyChecking(options, "ask");
        if ("enabled".equals(description.getParameter("publicKeyAuth"))) {
            cfg.setPreferredAuthentications(options, "publickey,password,keyboard-interactive");
        } else {
            cfg.setPreferredAuthentications(options, "password,keyboard-interactive");
        }
    }

    @Override
    public final Site createConnection(ConnectionDescription description) throws FileSystemException {
        this.desc = description;
        return new CommonsVfsConnection(description, this);
    }

    public final String getPassphrase() {
        this.logger.debug("SFTP UserInfo::getPassphrase");
        return this.desc.getSecretParameter("keyPassphrase");
    }

    public final String getPassword() {
        this.logger.debug("SFTP UserInfo::getPassword");
        return this.desc.getSecretParameter("password");
    }

    public final boolean promptPassword(String message) {
        this.logger.debug("SFTP UserInfo::promptPassword: " + message);
        return true;
    }

    public final boolean promptPassphrase(String message) {
        this.logger.debug("SFTP UserInfo::promptPassphrase: " + message);
        return true;
    }

    public final boolean promptYesNo(final String message) {
        final boolean[] arr = new boolean[]{false};
        if (null != this.desc.getParameter("interactive")) {
            GuiController.getInstance().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    OptionsDialog od = new OptionsDialog(GuiController.getInstance().getMainShell(), 4);
                    od.setText("Question - FullSync");
                    od.setMessage(message);
                    od.setOptions(new String[]{"Yes", "No"});
                    if ("Yes".equals(od.open())) {
                        arr[0] = true;
                    }
                }
            });
        } else {
            this.logger.warn("SFTP UserInfo::promptYesNo: " + message + "; automatic decision: No");
        }
        return arr[0];
    }

    public final void showMessage(String message) {
        this.logger.warn("SFTP UserInfo::showMessage: " + message);
    }

    public final String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
        this.logger.warn("Suppressed promptKeyboardInteractive:");
        this.logger.warn("Destination: " + destination);
        this.logger.warn("Name: " + name);
        this.logger.warn("Instruction: " + instruction);
        this.logger.warn("Prompt (#" + prompt.length + "): " + Arrays.toString(prompt));
        this.logger.warn("echo: (#" + echo.length + "): " + Arrays.toString(echo));
        this.logger.warn("rejecting prompt automatically");
        return null;
    }
}

