/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.fs.filesystems;

import net.sourceforge.fullsync.ConnectionDescription;
import net.sourceforge.fullsync.FileSystemException;
import net.sourceforge.fullsync.fs.FileSystem;
import net.sourceforge.fullsync.fs.Site;
import net.sourceforge.fullsync.fs.connection.CommonsVfsConnection;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.auth.StaticUserAuthenticator;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.smb.SmbFileProvider;

public class SmbFileSystem
implements FileSystem {
    private static boolean initialized = false;

    private static synchronized void init() {
        if (!initialized) {
            try {
                FileSystemManager fsm = VFS.getManager();
                if (!fsm.hasProvider("smb") && fsm instanceof DefaultFileSystemManager) {
                    DefaultFileSystemManager dfsm = (DefaultFileSystemManager)fsm;
                    dfsm.addProvider("smb", (FileProvider)new SmbFileProvider());
                }
            }
            catch (org.apache.commons.vfs2.FileSystemException e) {
                e.printStackTrace();
            }
            initialized = true;
        }
    }

    @Override
    public final Site createConnection(ConnectionDescription description) throws FileSystemException {
        if (!initialized) {
            SmbFileSystem.init();
        }
        return new CommonsVfsConnection(description, this);
    }

    @Override
    public final void authSetup(ConnectionDescription description, FileSystemOptions options) throws org.apache.commons.vfs2.FileSystemException {
        StaticUserAuthenticator auth = new StaticUserAuthenticator(null, description.getParameter("username"), description.getSecretParameter("password"));
        DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(options, (UserAuthenticator)auth);
    }
}

