/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.impl;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import net.sourceforge.fullsync.Action;
import net.sourceforge.fullsync.ActionDecider;
import net.sourceforge.fullsync.ConnectionDescription;
import net.sourceforge.fullsync.DataParseException;
import net.sourceforge.fullsync.FileSystemException;
import net.sourceforge.fullsync.FileSystemManager;
import net.sourceforge.fullsync.Profile;
import net.sourceforge.fullsync.RuleSet;
import net.sourceforge.fullsync.State;
import net.sourceforge.fullsync.Task;
import net.sourceforge.fullsync.TaskGenerationListener;
import net.sourceforge.fullsync.TaskGenerator;
import net.sourceforge.fullsync.TaskTree;
import net.sourceforge.fullsync.fs.File;
import net.sourceforge.fullsync.fs.Site;
import net.sourceforge.fullsync.impl.BackupActionDecider;
import net.sourceforge.fullsync.impl.ExactCopyActionDecider;
import net.sourceforge.fullsync.impl.PublishActionDecider;
import net.sourceforge.fullsync.impl.PublishOverwriteActionDecider;
import net.sourceforge.fullsync.impl.TwoWaySyncActionDecider;

public abstract class AbstractTaskGenerator
implements TaskGenerator {
    protected FileSystemManager fsm = new FileSystemManager();
    protected ArrayList<TaskGenerationListener> taskGenerationListeners = new ArrayList();
    protected boolean active = true;
    protected boolean cancelled = false;
    private ActionDecider actionDecider;

    @Override
    public void addTaskGenerationListener(TaskGenerationListener listener) {
        this.taskGenerationListeners.add(listener);
    }

    @Override
    public void removeTaskGenerationListener(TaskGenerationListener listener) {
        this.taskGenerationListeners.remove(listener);
    }

    @Override
    public boolean isActive() {
        return this.active && !this.cancelled;
    }

    @Override
    public void suspend() {
        this.active = false;
    }

    @Override
    public void resume() {
        this.active = true;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.active = false;
    }

    public ActionDecider getActionDecider() {
        return this.actionDecider;
    }

    @Override
    public TaskTree execute(Profile profile, boolean interactive) throws FileSystemException, URISyntaxException, DataParseException, IOException {
        ActionDecider actionDecider;
        Site d1 = null;
        Site d2 = null;
        RuleSet rules = profile.getRuleSet().createRuleSet();
        if (profile.getSynchronizationType().equals("Publish/Update")) {
            actionDecider = new PublishActionDecider();
        } else if (profile.getSynchronizationType().equals("Publish/Update Overwrite")) {
            actionDecider = new PublishOverwriteActionDecider();
        } else if (profile.getSynchronizationType().equals("Backup Copy")) {
            actionDecider = new BackupActionDecider();
        } else if (profile.getSynchronizationType().equals("Exact Copy")) {
            actionDecider = new ExactCopyActionDecider();
        } else if (profile.getSynchronizationType().equals("Two Way Sync")) {
            actionDecider = new TwoWaySyncActionDecider();
        } else {
            throw new IllegalArgumentException("Profile has unknown synchronization type.");
        }
        try {
            ConnectionDescription srcDesc = profile.getSource();
            ConnectionDescription dstDesc = profile.getDestination();
            if (interactive) {
                srcDesc.setParameter("interactive", "true");
                dstDesc.setParameter("interactive", "true");
            } else {
                srcDesc.clearParameter("interactive");
                dstDesc.clearParameter("interactive");
            }
            d1 = this.fsm.createConnection(srcDesc);
            d2 = this.fsm.createConnection(dstDesc);
            return this.execute(d1, d2, actionDecider, rules);
        }
        catch (FileSystemException ex) {
            if (d1 != null) {
                d1.close();
            }
            if (d2 != null) {
                d2.close();
            }
            throw ex;
        }
    }

    @Override
    public TaskTree execute(Site source, Site destination, ActionDecider actionDecider, RuleSet rules) throws DataParseException, FileSystemException, IOException {
        if (!source.isAvailable()) {
            throw new FileSystemException("source is unavailable");
        }
        if (!destination.isAvailable()) {
            throw new FileSystemException("destination is unavailable");
        }
        this.actionDecider = actionDecider;
        TaskTree tree = new TaskTree(source, destination);
        Task root = new Task(null, null, new State(1, 0), new Action[]{new Action(0, 0, 0, "Root")});
        tree.setRoot(root);
        for (TaskGenerationListener listener : this.taskGenerationListeners) {
            listener.taskTreeStarted(tree);
        }
        this.synchronizeDirectories(source.getRoot(), destination.getRoot(), rules, root);
        for (TaskGenerationListener listener : this.taskGenerationListeners) {
            listener.taskTreeFinished(tree);
        }
        return tree;
    }

    public abstract void synchronizeNodes(File var1, File var2, RuleSet var3, Task var4) throws DataParseException, IOException;

    public abstract void synchronizeDirectories(File var1, File var2, RuleSet var3, Task var4) throws DataParseException, IOException;
}

