/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.impl;

import java.io.IOException;
import net.sourceforge.fullsync.DataParseException;
import net.sourceforge.fullsync.FileComparer;
import net.sourceforge.fullsync.State;
import net.sourceforge.fullsync.fs.File;
import net.sourceforge.fullsync.fs.buffering.BufferedFile;
import net.sourceforge.fullsync.impl.StateDecider;

public class BufferStateDecider
extends StateDecider
implements net.sourceforge.fullsync.BufferStateDecider {
    public BufferStateDecider(FileComparer comparer) {
        super(comparer);
    }

    @Override
    public State getState(File buffered) throws DataParseException, IOException {
        if (!buffered.isBuffered()) {
            return new State(1, buffered.exists() ? 3 : 0);
        }
        File source = buffered.getUnbuffered();
        BufferedFile destination = (BufferedFile)buffered;
        if (!source.exists()) {
            if (!destination.exists()) {
                return new State(1, 0);
            }
            return new State(2, 2);
        }
        if (!destination.exists()) {
            return new State(2, 1);
        }
        if (source.isDirectory()) {
            if (destination.isDirectory()) {
                return new State(1, 3);
            }
            return new State(4, 1);
        }
        if (destination.isDirectory()) {
            return new State(4, 2);
        }
        return this.comparer.compareFiles(source, destination);
    }
}

