/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.impl;

import java.io.File;
import javax.xml.parsers.FactoryConfigurationError;
import net.sourceforge.fullsync.Crypt;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.Preferences;
import net.sourceforge.fullsync.Util;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.eclipse.swt.graphics.Rectangle;

public class ConfigurationPreferences
implements Preferences {
    private PropertiesConfiguration config = new PropertiesConfiguration();
    private String lastFullSyncVersion;

    public ConfigurationPreferences(String configFile) {
        try {
            File file = new File(configFile);
            this.config.setFile(file);
            if (file.exists()) {
                this.config.load();
            }
            this.lastFullSyncVersion = this.config.getString("FullSync.Version", "");
        }
        catch (ConfigurationException e) {
            ExceptionHandler.reportException(e);
        }
        catch (FactoryConfigurationError e) {
            ExceptionHandler.reportException(e);
        }
        if (null == this.lastFullSyncVersion) {
            this.lastFullSyncVersion = "";
        }
    }

    @Override
    public void save() {
        try {
            String currentFullSyncVersion = Util.getFullSyncVersion();
            this.config.setProperty("FullSync.Version", (Object)currentFullSyncVersion);
            this.config.save();
        }
        catch (ConfigurationException e) {
            ExceptionHandler.reportException(e);
        }
    }

    @Override
    public boolean confirmExit() {
        return this.config.getBoolean("Interface.ConfirmExit", true);
    }

    @Override
    public void setConfirmExit(boolean bool) {
        this.config.setProperty("Interface.ConfirmExit", (Object)bool);
    }

    @Override
    public boolean closeMinimizesToSystemTray() {
        return this.config.getBoolean("Interface.CloseMinimizesToSystemTray", false);
    }

    @Override
    public void setCloseMinimizesToSystemTray(boolean bool) {
        this.config.setProperty("Interface.CloseMinimizesToSystemTray", (Object)bool);
    }

    @Override
    public boolean minimizeMinimizesToSystemTray() {
        return this.config.getBoolean("Interface.MinimizeMinimizesToSystemTray", false);
    }

    @Override
    public void setMinimizeMinimizesToSystemTray(boolean bool) {
        this.config.setProperty("Interface.MinimizeMinimizesToSystemTray", (Object)bool);
    }

    @Override
    public boolean systemTrayEnabled() {
        return this.config.getBoolean("Interface.SystemTray.Enabled", true);
    }

    @Override
    public void setSystemTrayEnabled(boolean bool) {
        this.config.setProperty("Interface.SystemTray.Enabled", (Object)bool);
    }

    @Override
    public String getProfileListStyle() {
        return this.config.getString("Interface.ProfileList.Style", "NiceListView");
    }

    @Override
    public void setProfileListStyle(String profileListStyle) {
        this.config.setProperty("Interface.ProfileList.Style", (Object)profileListStyle);
    }

    @Override
    public boolean listeningForRemoteConnections() {
        return this.config.getBoolean("RemoteConnection.active", false);
    }

    @Override
    public void setListeningForRemoteConnections(boolean bool) {
        this.config.setProperty("RemoteConnection.active", (Object)bool);
    }

    @Override
    public int getRemoteConnectionsPort() {
        return this.config.getInt("RemoteConnection.port", 10000);
    }

    @Override
    public void setRemoteConnectionsPort(int port) {
        this.config.setProperty("RemoteConnection.port", (Object)port);
    }

    @Override
    public String getRemoteConnectionsPassword() {
        String passwd = this.config.getString("RemoteConnection.password", "admin");
        String decryptedPassword = Crypt.decrypt(passwd);
        return decryptedPassword;
    }

    @Override
    public void setRemoteConnectionsPassword(String password) {
        String encryptedPasswd = Crypt.encrypt(password);
        this.config.setProperty("RemoteConnection.password", (Object)encryptedPasswd);
    }

    @Override
    public boolean getAutostartScheduler() {
        return this.config.getBoolean("Interface.AutostartScheduler", false);
    }

    @Override
    public void setAutostartScheduler(boolean bool) {
        this.config.setProperty("Interface.AutostartScheduler", (Object)bool);
    }

    @Override
    public String getLanguageCode() {
        return this.config.getString("Interface.LanguageCode", "en");
    }

    @Override
    public void setLanguageCode(String code) {
        this.config.setProperty("Interface.LanguageCode", (Object)code);
    }

    @Override
    public boolean getHelpShown() {
        return this.config.getBoolean("Interface.HelpShown", false);
    }

    @Override
    public void setHelpShown(boolean shown) {
        this.config.setProperty("Interface.HelpShown", (Object)shown);
    }

    @Override
    public boolean getSkipWelcomeScreen() {
        return this.config.getBoolean("Interface.SkipWelcomeScreen", false);
    }

    @Override
    public void setSkipWelcomeScreen(boolean skip) {
        this.config.setProperty("Interface.SkipWelcomeScreen", (Object)skip);
    }

    @Override
    public String getLastVersion() {
        return this.lastFullSyncVersion;
    }

    @Override
    public void setWindowMaximized(boolean maximized) {
        this.config.setProperty("Interface.WindowState.maximized", (Object)maximized);
    }

    @Override
    public boolean getWindowMaximized() {
        return this.config.getBoolean("Interface.WindowState.maximized", false);
    }

    @Override
    public void setWindowMinimized(boolean minimized) {
        this.config.setProperty("Interface.WindowState.minimized", (Object)minimized);
    }

    @Override
    public boolean getWindowMinimized() {
        return this.config.getBoolean("Interface.WindowState.minimized", false);
    }

    @Override
    public void setWindowBounds(Rectangle b) {
        this.config.setProperty("Interface.WindowState.x", (Object)b.x);
        this.config.setProperty("Interface.WindowState.y", (Object)b.y);
        this.config.setProperty("Interface.WindowState.width", (Object)b.width);
        this.config.setProperty("Interface.WindowState.height", (Object)b.height);
    }

    @Override
    public Rectangle getWindowBounds() {
        int x = this.config.getInt("Interface.WindowState.x", 0);
        int y = this.config.getInt("Interface.WindowState.y", 0);
        int width = this.config.getInt("Interface.WindowState.width", 0);
        int height = this.config.getInt("Interface.WindowState.height", 0);
        return new Rectangle(x, y, width, height);
    }
}

