/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.impl;

import java.io.IOException;
import java.util.Vector;
import net.sourceforge.fullsync.Action;
import net.sourceforge.fullsync.ActionDecider;
import net.sourceforge.fullsync.BufferStateDecider;
import net.sourceforge.fullsync.DataParseException;
import net.sourceforge.fullsync.State;
import net.sourceforge.fullsync.StateDecider;
import net.sourceforge.fullsync.Task;
import net.sourceforge.fullsync.fs.File;

public class ExactCopyActionDecider
implements ActionDecider {
    private static final Action addDestination = new Action(1, 2, 2, "Add");
    private static final Action overwriteDestination = new Action(2, 2, 2, "overwrite destination");
    private static final Action updateDestination = new Action(2, 2, 2, "Source changed");
    private static final Action deleteDestinationOrphan = new Action(3, 2, 2, "Delete orphan in destination", false);
    private static final Action inSync = new Action(0, 0, 0, "In Sync");
    private static final Action ignore = new Action(0, 0, 0, "Ignore");

    @Override
    public Task getTask(File src, File dst, StateDecider sd, BufferStateDecider bsd) throws DataParseException, IOException {
        Vector<Action> actions = new Vector<Action>(3);
        State state = sd.getState(src, dst);
        switch (state.getType()) {
            case 2: {
                if (state.getLocation() == 1) {
                    if (!bsd.getState(dst).equals(2, 1)) {
                        actions.add(addDestination);
                        break;
                    }
                    actions.add(overwriteDestination);
                    break;
                }
                if (state.getLocation() != 2) break;
                actions.add(deleteDestinationOrphan);
                break;
            }
            case 4: {
                State buff = bsd.getState(dst);
                if (buff.equals(2, 2)) {
                    actions.add(new Action(1, 2, 2, "There was a node in buff, but its orphan, so add"));
                    break;
                }
                if (buff.equals(4, state.getLocation())) {
                    if (state.getLocation() == 1) {
                        actions.add(new Action(0, 0, 2, "dirherefilethere, but there is a dir instead of file, so its in sync"));
                        break;
                    }
                    actions.add(new Action(12, 2, 0, "file changed from/to dir, can't overwrite"));
                    break;
                }
                actions.add(new Action(12, state.getLocation(), 0, "cant update, dir here file there error occured"));
                break;
            }
            case 3: {
                if (bsd.getState(dst).equals(1, 3)) {
                    if (state.getLocation() == 1) {
                        actions.add(updateDestination);
                        break;
                    }
                    if (state.getLocation() != 2) break;
                    actions.add(overwriteDestination);
                    break;
                }
                actions.add(overwriteDestination);
                break;
            }
            case 1: {
                actions.add(inSync);
                actions.add(overwriteDestination);
                break;
            }
            default: {
                actions.add(new Action(10, 0, 0, "no rule found"));
            }
        }
        actions.add(ignore);
        Action[] as = new Action[actions.size()];
        actions.toArray(as);
        return new Task(src, dst, state, as);
    }
}

