/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sourceforge.fullsync.Task;
import net.sourceforge.fullsync.buffer.EntryDescriptor;
import net.sourceforge.fullsync.fs.File;

public class FileCopyEntryDescriptor
implements EntryDescriptor {
    private Task reference;
    private File src;
    private File dst;
    private InputStream inputStream;
    private OutputStream outputStream;

    public FileCopyEntryDescriptor(Task reference, File src, File dst) {
        this.reference = reference;
        this.src = src;
        this.dst = dst;
    }

    @Override
    public Task getTask() {
        return this.reference;
    }

    @Override
    public long getSize() {
        return this.src.getSize();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = this.src.getInputStream();
        }
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = this.dst.getOutputStream();
        }
        return this.outputStream;
    }

    @Override
    public void finishWrite() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
        }
        this.dst.setLastModified(this.src.getLastModified());
        this.dst.writeFileAttributes();
        this.dst.refresh();
    }

    @Override
    public void finishStore() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }

    @Override
    public String getOperationDescription() {
        return "Copied " + this.src.getPath() + " to " + this.dst.getPath();
    }
}

