/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.impl;

import java.io.IOException;
import java.util.Vector;
import net.sourceforge.fullsync.Action;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.IoStatistics;
import net.sourceforge.fullsync.Task;
import net.sourceforge.fullsync.TaskExecutor;
import net.sourceforge.fullsync.TaskFinishedEvent;
import net.sourceforge.fullsync.TaskFinishedListener;
import net.sourceforge.fullsync.TaskTree;
import net.sourceforge.fullsync.buffer.EntryDescriptor;
import net.sourceforge.fullsync.buffer.EntryFinishedListener;
import net.sourceforge.fullsync.buffer.ExecutionBuffer;
import net.sourceforge.fullsync.fs.File;
import net.sourceforge.fullsync.impl.BufferUpdateEntryDescriptor;
import net.sourceforge.fullsync.impl.DeleteNodeEntryDescriptor;
import net.sourceforge.fullsync.impl.DirCreationEntryDescriptor;
import net.sourceforge.fullsync.impl.FileCopyEntryDescriptor;
import net.sourceforge.fullsync.impl.IoStatisticsImpl;

public class FillBufferTaskExecutor
implements TaskExecutor,
EntryFinishedListener {
    private Vector<TaskFinishedListener> listeners = new Vector();
    private boolean statisticsOnly = false;
    private IoStatisticsImpl stats;
    private ExecutionBuffer buffer;

    public FillBufferTaskExecutor(ExecutionBuffer buffer) {
        this.buffer = buffer;
        buffer.addEntryFinishedListener(this);
    }

    @Override
    public IoStatistics createStatistics(TaskTree tree) {
        this.statisticsOnly = true;
        this.enqueue(tree);
        this.statisticsOnly = false;
        return this.stats;
    }

    @Override
    public void enqueue(TaskTree tree) {
        this.stats = new IoStatisticsImpl();
        this.enqueue(tree.getRoot());
    }

    protected void enqueueTaskChildren(Task task) {
        for (Task t : task.getChildren()) {
            this.enqueue(t);
        }
    }

    @Override
    public void enqueue(Task task) {
        if (!task.getCurrentAction().isBeforeRecursion()) {
            this.enqueueTaskChildren(task);
        }
        this.executeTask(task);
        if (task.getCurrentAction().isBeforeRecursion()) {
            this.enqueueTaskChildren(task);
        }
    }

    protected void storeDirCreation(Task task, File subject) throws IOException {
        if (!this.statisticsOnly) {
            this.buffer.storeEntry(new DirCreationEntryDescriptor(task, subject));
        }
        ++this.stats.dirsCreated;
    }

    protected void storeFileCopy(Task task, File source, File destination) throws IOException {
        try {
            if (!this.statisticsOnly) {
                this.buffer.storeEntry(new FileCopyEntryDescriptor(task, source, destination));
            }
            ++this.stats.filesCopied;
            this.stats.bytesTransferred += source.getSize();
        }
        catch (IOException ioe) {
            this.fireTaskFinished(new TaskFinishedEvent(task, ioe.getMessage()));
        }
    }

    protected void storeDeleteNode(Task task, File subject) throws IOException {
        if (!this.statisticsOnly) {
            this.buffer.storeEntry(new DeleteNodeEntryDescriptor(task, subject));
        }
        ++this.stats.deletions;
    }

    protected void executeTask(Task task) {
        try {
            Action action = task.getCurrentAction();
            File source = task.getSource();
            File destination = task.getDestination();
            switch (action.getType()) {
                case 1: 
                case 2: {
                    if (action.getLocation() == 2) {
                        if (source.isDirectory()) {
                            this.storeDirCreation(task, destination);
                            break;
                        }
                        this.storeFileCopy(task, source, destination);
                        break;
                    }
                    if (action.getLocation() != 1) break;
                    if (destination.isDirectory()) {
                        this.storeDirCreation(task, source);
                        break;
                    }
                    this.storeFileCopy(task, destination, source);
                    break;
                }
                case 3: {
                    if (action.getLocation() == 2) {
                        this.storeDeleteNode(task, destination);
                        break;
                    }
                    if (action.getLocation() != 1) break;
                    this.storeDeleteNode(task, source);
                    break;
                }
            }
            if (action.getBufferUpdate() > 0 && !this.statisticsOnly) {
                this.buffer.storeEntry(new BufferUpdateEntryDescriptor(source, destination, action.getBufferUpdate()));
            }
        }
        catch (IOException ioe) {
            ExceptionHandler.reportException(ioe);
        }
    }

    @Override
    public void flush() throws IOException {
        this.buffer.flush();
    }

    @Override
    public void entryFinished(EntryDescriptor entry, IOException ioe) {
        Task task = entry.getTask();
        if (null != task) {
            if (null != ioe) {
                this.fireTaskFinished(new TaskFinishedEvent(task, ioe.getLocalizedMessage()));
            } else {
                this.fireTaskFinished(new TaskFinishedEvent(task, 0));
            }
        }
    }

    protected void fireTaskFinished(TaskFinishedEvent event) {
        for (TaskFinishedListener listener : this.listeners) {
            listener.taskFinished(event);
        }
    }

    @Override
    public void addTaskFinishedListener(TaskFinishedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeTaskFinishedListener(TaskFinishedListener listener) {
        this.listeners.remove(listener);
    }
}

