/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sourceforge.fullsync.RuleSet;
import net.sourceforge.fullsync.RuleSetDescriptor;
import net.sourceforge.fullsync.impl.SimplyfiedSyncRules;
import net.sourceforge.fullsync.rules.filefilter.FileFilter;
import net.sourceforge.fullsync.rules.filefilter.FileFilterManager;
import net.sourceforge.fullsync.rules.filefilter.FileFilterRule;
import net.sourceforge.fullsync.rules.filefilter.FileNameFileFilterRule;
import net.sourceforge.fullsync.rules.filefilter.filefiltertree.FileFilterTree;
import net.sourceforge.fullsync.rules.filefilter.values.TextValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SimplyfiedRuleSetDescriptor
extends RuleSetDescriptor {
    public static final String RULESET_TYPE = "simple";
    private static final long serialVersionUID = 2L;
    private boolean syncSubDirs = false;
    private String ignorePattern;
    private String takePattern;
    private String patternsType;
    private FileFilter fileFilter;
    private boolean useFilter;
    private FileFilterTree fileFilterTree;

    public SimplyfiedRuleSetDescriptor() {
    }

    public SimplyfiedRuleSetDescriptor(boolean syncSubDirs, FileFilter fileFilter, boolean useFilter, FileFilterTree fileFilterTree) {
        this.syncSubDirs = syncSubDirs;
        this.ignorePattern = "";
        this.takePattern = "";
        this.patternsType = "";
        this.fileFilter = fileFilter;
        this.useFilter = useFilter;
        this.fileFilterTree = fileFilterTree;
    }

    @Override
    public String getType() {
        return RULESET_TYPE;
    }

    @Override
    public Element serializeDescriptor(Document document) {
        Element simpleRuleSetElement = document.createElement("SimpleRuleSet");
        simpleRuleSetElement.setAttribute("syncSubs", String.valueOf(this.isSyncSubDirs()));
        simpleRuleSetElement.setAttribute("patternsType", this.getPatternsType());
        simpleRuleSetElement.setAttribute("ignorePattern", this.getIgnorePattern());
        simpleRuleSetElement.setAttribute("takePattern", this.getTakePattern());
        simpleRuleSetElement.setAttribute("useFilter", String.valueOf(this.isUseFilter()));
        FileFilterManager filterManager = new FileFilterManager();
        if (this.fileFilter != null) {
            Element fileFilterElement = filterManager.serializeFileFilter(this.getFileFilter(), document, "FileFilter", "FileFilterRule");
            simpleRuleSetElement.appendChild(fileFilterElement);
        }
        if (this.fileFilterTree != null) {
            HashMap<String, FileFilter> itemsMap = this.fileFilterTree.getItemsMap();
            Set<Map.Entry<String, FileFilter>> entrySet = itemsMap.entrySet();
            for (Map.Entry<String, FileFilter> entry : entrySet) {
                String path = entry.getKey();
                FileFilter filter = entry.getValue();
                Element subdirFilterElement = document.createElement("SubdirectoryFileFilter");
                subdirFilterElement.setAttribute("path", path);
                Element fileFilterElement = filterManager.serializeFileFilter(filter, document, "FileFilter", "FileFilterRule");
                subdirFilterElement.appendChild(fileFilterElement);
                simpleRuleSetElement.appendChild(subdirFilterElement);
            }
        }
        return simpleRuleSetElement;
    }

    @Override
    protected void unserializeDescriptor(Element element) {
        NodeList ruleSetConfigNodeList = element.getElementsByTagName("SimpleRuleSet");
        if (ruleSetConfigNodeList.getLength() == 0) {
            this.syncSubDirs = true;
            this.useFilter = false;
            this.ignorePattern = "";
            this.takePattern = "";
            this.fileFilter = null;
            this.fileFilterTree = null;
        } else {
            NodeList fileFilterNodeList;
            Element simpleRuleSetConfigElement = (Element)ruleSetConfigNodeList.item(0);
            this.syncSubDirs = Boolean.valueOf(simpleRuleSetConfigElement.getAttribute("syncSubs"));
            this.patternsType = simpleRuleSetConfigElement.getAttribute("patternsType");
            this.ignorePattern = simpleRuleSetConfigElement.getAttribute("ignorePattern");
            this.takePattern = simpleRuleSetConfigElement.getAttribute("takePattern");
            String useFilterStr = simpleRuleSetConfigElement.getAttribute("useFilter");
            if (useFilterStr != null && !useFilterStr.equals("")) {
                this.useFilter = Boolean.valueOf(useFilterStr);
            }
            if ((fileFilterNodeList = simpleRuleSetConfigElement.getElementsByTagName("FileFilter")).getLength() > 0) {
                FileFilterManager filterManager = new FileFilterManager();
                Element fileFilterElement = (Element)fileFilterNodeList.item(0);
                this.fileFilter = filterManager.unserializeFileFilter(fileFilterElement, "FileFilterRule");
                NodeList subdirFiltersNodeList = simpleRuleSetConfigElement.getElementsByTagName("SubdirectoryFileFilter");
                int numOfDirs = subdirFiltersNodeList.getLength();
                this.fileFilterTree = new FileFilterTree();
                for (int i = 0; i < numOfDirs; ++i) {
                    Element subDirElement = (Element)subdirFiltersNodeList.item(i);
                    String path = subDirElement.getAttribute("path");
                    fileFilterNodeList = subDirElement.getElementsByTagName("FileFilter");
                    if (fileFilterNodeList.getLength() <= 0) continue;
                    Element subDirFileFilterElement = (Element)fileFilterNodeList.item(0);
                    FileFilter subDirFileFilter = filterManager.unserializeFileFilter(subDirFileFilterElement, "FileFilterRule");
                    this.fileFilterTree.addFileFilter(path, subDirFileFilter);
                }
            } else {
                this.fileFilter = null;
                if (this.patternsType.equals("RegExp")) {
                    FileFilterRule[] rules;
                    if (!this.ignorePattern.equals("") && this.takePattern.equals("")) {
                        this.fileFilter = new FileFilter();
                        this.fileFilter.setMatchType(0);
                        this.fileFilter.setFilterType(1);
                        rules = new FileFilterRule[]{new FileNameFileFilterRule(new TextValue(this.ignorePattern), 8)};
                        this.fileFilter.setFileFilterRules(rules);
                        this.useFilter = true;
                    }
                    if (this.ignorePattern.equals("") && !this.takePattern.equals("")) {
                        this.fileFilter = new FileFilter();
                        this.fileFilter.setMatchType(0);
                        this.fileFilter.setFilterType(0);
                        rules = new FileFilterRule[]{new FileNameFileFilterRule(new TextValue(this.takePattern), 8)};
                        this.fileFilter.setFileFilterRules(rules);
                        this.useFilter = true;
                    }
                    if (!this.ignorePattern.equals("") && !this.takePattern.equals("")) {
                        this.fileFilter = new FileFilter();
                        this.fileFilter.setMatchType(0);
                        this.fileFilter.setFilterType(1);
                        rules = new FileFilterRule[]{new FileNameFileFilterRule(new TextValue(this.ignorePattern), 8), new FileNameFileFilterRule(new TextValue(this.takePattern), 9)};
                        this.fileFilter.setFileFilterRules(rules);
                        this.useFilter = true;
                    }
                }
            }
        }
    }

    public boolean isSyncSubDirs() {
        return this.syncSubDirs;
    }

    public void setSyncSubDirs(boolean syncSubDirs) {
        this.syncSubDirs = syncSubDirs;
    }

    public String getPatternsType() {
        return this.patternsType;
    }

    public void setPatternsType(String type) {
        this.patternsType = type;
    }

    public String getTakePattern() {
        return this.takePattern;
    }

    public void setTakePattern(String takePattern) {
        this.takePattern = takePattern;
    }

    public String getIgnorePattern() {
        return this.ignorePattern;
    }

    public void setIgnorePattern(String ignorePattern) {
        this.ignorePattern = ignorePattern;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(FileFilter filter) {
        this.fileFilter = filter;
    }

    public boolean isUseFilter() {
        return this.useFilter;
    }

    public FileFilterTree getFileFilterTree() {
        return this.fileFilterTree;
    }

    public void setFileFilterTree(FileFilterTree fileFilterTree) {
        this.fileFilterTree = fileFilterTree;
    }

    @Override
    public RuleSet createRuleSet() {
        SimplyfiedSyncRules ruleSet = new SimplyfiedSyncRules();
        ruleSet.setUsingRecursion(this.syncSubDirs);
        if (this.patternsType != null && !this.patternsType.equals("")) {
            ruleSet.setPatternsType(this.patternsType);
        } else {
            ruleSet.setPatternsType("RegExp");
        }
        ruleSet.setIgnorePattern(this.ignorePattern);
        ruleSet.setTakePattern(this.takePattern);
        ruleSet.setFileFilter(this.fileFilter);
        ruleSet.setUseFilter(this.useFilter);
        ruleSet.setFileFilterTree(this.fileFilterTree);
        return ruleSet;
    }
}

