/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.impl;

import net.sourceforge.fullsync.DataParseException;
import net.sourceforge.fullsync.RuleSet;
import net.sourceforge.fullsync.State;
import net.sourceforge.fullsync.fs.File;
import net.sourceforge.fullsync.rules.filefilter.FileFilter;
import net.sourceforge.fullsync.rules.filefilter.filefiltertree.FileFilterTree;

public class SimplyfiedSyncRules
implements RuleSet {
    private String name;
    private boolean isUsingRecursion = true;
    private String patternsType;
    private String ignorePattern;
    private String takePattern;
    private FileFilter fileFilter;
    private FileFilterTree fileFilterTree;
    private boolean useFilter;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isUsingRecursion() {
        return this.isUsingRecursion;
    }

    public void setUsingRecursion(boolean usingRecursion) {
        this.isUsingRecursion = usingRecursion;
    }

    public void setPatternsType(String type) {
        this.patternsType = type;
    }

    public String getPatternsType() {
        return this.patternsType;
    }

    public void setIgnorePattern(String pattern) {
        this.ignorePattern = pattern;
    }

    public void setTakePattern(String pattern) {
        this.takePattern = pattern;
    }

    public String getIgnorePattern() {
        return this.ignorePattern;
    }

    public String getTakePattern() {
        return this.takePattern;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    public void setUseFilter(boolean bool) {
        this.useFilter = bool;
    }

    public void setFileFilterTree(FileFilterTree fileFilterTree) {
        this.fileFilterTree = fileFilterTree;
    }

    public FileFilterTree getFileFilterTree() {
        return this.fileFilterTree;
    }

    @Override
    public boolean isJustLogging() {
        return false;
    }

    @Override
    public boolean isNodeIgnored(File node) {
        if (this.useFilter) {
            FileFilter subFilter;
            FileFilter filterToUse = this.fileFilter;
            if (this.fileFilterTree != null && (subFilter = this.fileFilterTree.getFilter(node.getPath())) != null) {
                filterToUse = subFilter;
            }
            boolean take = true;
            if (filterToUse != null) {
                take = filterToUse.match(node);
            }
            return !take;
        }
        return false;
    }

    @Override
    public State compareFiles(File src, File dst) throws DataParseException {
        if (Math.floor((double)src.getLastModified() / 1000.0) > Math.floor((double)dst.getLastModified() / 1000.0)) {
            return new State(3, 1);
        }
        if (Math.floor((double)src.getLastModified() / 1000.0) < Math.floor((double)dst.getLastModified() / 1000.0)) {
            return new State(3, 2);
        }
        if (src.getSize() != dst.getSize()) {
            return new State(3, 0);
        }
        return new State(1, 3);
    }

    @Override
    public RuleSet createChild(File src, File dst) {
        return this;
    }
}

