/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.impl;

import net.sourceforge.fullsync.DataParseException;
import net.sourceforge.fullsync.FileComparer;
import net.sourceforge.fullsync.State;
import net.sourceforge.fullsync.fs.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateDecider
implements net.sourceforge.fullsync.StateDecider {
    private static final Logger logger = LoggerFactory.getLogger((String)StateDecider.class.getSimpleName());
    private static final State inSyncNone = new State(1, 0);
    private static final State orphanSrc = new State(2, 1);
    private static final State orphanDst = new State(2, 2);
    private static final State inSyncBoth = new State(1, 3);
    private static final State dirFileSrc = new State(4, 1);
    private static final State dirFileDst = new State(4, 2);
    protected FileComparer comparer;

    public StateDecider(FileComparer comparer) {
        this.comparer = comparer;
    }

    @Override
    public State getState(File source, File destination) throws DataParseException {
        logger.debug(source + " vs. " + destination);
        if (!source.exists()) {
            if (!destination.exists()) {
                logger.debug("both missing");
                return inSyncNone;
            }
            logger.debug("source missing");
            return orphanDst;
        }
        if (!destination.exists()) {
            logger.debug("destination missing");
            return orphanSrc;
        }
        if (source.isDirectory()) {
            if (destination.isDirectory()) {
                logger.debug("both are dirs");
                return inSyncBoth;
            }
            logger.debug("source directory, destination file");
            return dirFileSrc;
        }
        if (destination.isDirectory()) {
            logger.debug("source file, destination directory");
            return dirFileDst;
        }
        return this.comparer.compareFiles(source, destination);
    }
}

